/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.CompositeContext;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import sun.awt.image.IntegerComponentRaster;
import sun.java2d.loops.RasterOutputManager;

class AlphaCompositeContext
implements CompositeContext {
    ColorModel srcCM;
    ColorModel dstCM;
    boolean srcNeedConvert;
    boolean dstNeedConvert;
    int rule;
    float extraAlpha;

    public AlphaCompositeContext(ColorModel colorModel, ColorModel colorModel2, int n, float f) {
        this.srcCM = colorModel;
        this.srcNeedConvert = !this.srcCM.equals(ColorModel.getRGBdefault());
        this.dstCM = colorModel2;
        this.dstNeedConvert = !this.dstCM.equals(ColorModel.getRGBdefault());
        this.rule = n;
        this.extraAlpha = f;
    }

    public void compose(Raster raster, Raster raster2, WritableRaster writableRaster) {
        IntegerComponentRaster integerComponentRaster;
        WritableRaster writableRaster2 = writableRaster;
        if (this.srcNeedConvert) {
            raster = this.convertRaster(raster, this.srcCM, ColorModel.getRGBdefault());
            raster2 = this.convertRaster(raster2, this.srcCM, ColorModel.getRGBdefault());
        }
        if (this.dstNeedConvert && writableRaster != raster && writableRaster != raster2) {
            writableRaster = this.convertRaster(writableRaster, this.dstCM, ColorModel.getRGBdefault());
        }
        if (writableRaster == raster) {
            integerComponentRaster = (IntegerComponentRaster)raster2;
        } else if (writableRaster == raster2) {
            integerComponentRaster = (IntegerComponentRaster)raster;
        } else {
            writableRaster.setDataElements(0, 0, raster2);
            integerComponentRaster = (IntegerComponentRaster)raster;
        }
        IntegerComponentRaster integerComponentRaster2 = (IntegerComponentRaster)writableRaster;
        int n = Math.min(integerComponentRaster.getWidth(), integerComponentRaster2.getWidth());
        int n2 = Math.min(integerComponentRaster.getHeight(), integerComponentRaster2.getHeight());
        RasterOutputManager.ARGBpaintARGB(integerComponentRaster, false, integerComponentRaster2, this.rule, this.extraAlpha, null, 0, 0, 0, 0, 0, 0, n, n2, 0);
        if (this.dstNeedConvert) {
            writableRaster = this.convertRaster(writableRaster, ColorModel.getRGBdefault(), this.dstCM);
            writableRaster2.setDataElements(0, 0, writableRaster);
        }
    }

    WritableRaster convertRaster(Raster raster, ColorModel colorModel, ColorModel colorModel2) {
        if (colorModel instanceof IndexColorModel && colorModel2.equals(ColorModel.getRGBdefault())) {
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            BufferedImage bufferedImage = indexColorModel.convertToIntDiscrete(raster, false);
            return bufferedImage.getRaster();
        }
        BufferedImage bufferedImage = new BufferedImage(colorModel2, colorModel2.createCompatibleWritableRaster(raster.getWidth(), raster.getHeight()), colorModel2.isAlphaPremultiplied(), null);
        int n = 0;
        while (n < raster.getHeight()) {
            int n2 = 0;
            while (n2 < raster.getWidth()) {
                bufferedImage.setRGB(n2, n, colorModel.getRGB(raster.getDataElements(n2, n, null)));
                ++n2;
            }
            ++n;
        }
        return bufferedImage.getRaster();
    }

    public void dispose() {
    }
}

