/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import sun.awt.image.IntegerComponentRaster;

class GradientPaintContext
implements PaintContext {
    static ColorModel xrgbmodel = new DirectColorModel(24, 0xFF0000, 65280, 255);
    double x1;
    double y1;
    double dx;
    double dy;
    boolean cyclic;
    int[] interp;
    Raster saved;
    ColorModel model;

    public GradientPaintContext(Point2D point2D, Point2D point2D2, Color color, Color color2, boolean bl) {
        int n;
        int n2;
        double d;
        double d2;
        double d3 = point2D.getX();
        double d4 = point2D2.getX();
        if (d3 > d4) {
            d2 = d3;
            d3 = d4;
            d4 = d2;
            d2 = point2D2.getY();
            d = point2D.getY();
            n2 = color2.getRGB();
            n = color.getRGB();
        } else {
            d2 = point2D.getY();
            d = point2D2.getY();
            n2 = color.getRGB();
            n = color2.getRGB();
        }
        double d5 = d4 - d3;
        double d6 = d - d2;
        double d7 = d5 * d5 + d6 * d6;
        this.x1 = d3;
        this.y1 = d2;
        if (d7 >= Double.MIN_VALUE) {
            d5 /= d7;
            d6 /= d7;
            if (bl) {
                d5 %= 1.0;
                d6 %= 1.0;
            }
        }
        this.dx = d5;
        this.dy = d6;
        this.cyclic = bl;
        int n3 = n2 >> 24 & 0xFF;
        int n4 = n2 >> 16 & 0xFF;
        int n5 = n2 >> 8 & 0xFF;
        int n6 = n2 & 0xFF;
        int n7 = (n >> 24 & 0xFF) - n3;
        int n8 = (n >> 16 & 0xFF) - n4;
        int n9 = (n >> 8 & 0xFF) - n5;
        int n10 = (n & 0xFF) - n6;
        this.model = (n2 & n) >>> 24 == 255 ? xrgbmodel : ColorModel.getRGBdefault();
        this.interp = new int[bl ? 513 : 257];
        int n11 = 0;
        while (n11 <= 256) {
            int n12;
            float f = (float)n11 / 256.0f;
            this.interp[n11] = n12 = (int)((float)n3 + (float)n7 * f) << 24 | (int)((float)n4 + (float)n8 * f) << 16 | (int)((float)n5 + (float)n9 * f) << 8 | (int)((float)n6 + (float)n10 * f);
            if (bl) {
                this.interp[512 - n11] = n12;
            }
            ++n11;
        }
    }

    void clipFillRaster(int[] nArray, int n, int n2, int n3, int n4, double d, double d2, double d3) {
        while (--n4 >= 0) {
            int n5;
            double d4 = d;
            int n6 = n3;
            if (d4 <= 0.0) {
                n5 = this.interp[0];
                do {
                    nArray[n++] = n5;
                } while (--n6 > 0 && (d4 += d2) <= 0.0);
            }
            while (d4 < 1.0 && --n6 >= 0) {
                nArray[n++] = this.interp[(int)(d4 * 256.0)];
                d4 += d2;
            }
            if (n6 > 0) {
                n5 = this.interp[256];
                do {
                    nArray[n++] = n5;
                } while (--n6 > 0);
            }
            n += n2;
            d += d3;
        }
    }

    void cycleFillRaster(int[] nArray, int n, int n2, int n3, int n4, double d, double d2, double d3) {
        int n5 = (int)((d %= 2.0) * 1.073741824E9) << 1;
        int n6 = (int)(-d2 * -2.147483648E9);
        int n7 = (int)(-d3 * -2.147483648E9);
        while (--n4 >= 0) {
            int n8 = n5;
            int n9 = n3;
            while (n9 > 0) {
                nArray[n++] = this.interp[n8 >>> 23];
                n8 += n6;
                --n9;
            }
            n += n2;
            n5 += n7;
        }
    }

    public void dispose() {
        this.saved = null;
    }

    public ColorModel getColorModel() {
        return this.model;
    }

    public Raster getRaster(int n, int n2, int n3, int n4) {
        double d = ((double)n - this.x1) * this.dx + ((double)n2 - this.y1) * this.dy;
        Raster raster = this.saved;
        if (raster == null || raster.getWidth() < n3 || raster.getHeight() < n4) {
            this.saved = raster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
        }
        IntegerComponentRaster integerComponentRaster = (IntegerComponentRaster)raster;
        int n5 = integerComponentRaster.getDataOffset(0);
        int n6 = integerComponentRaster.getScanlineStride() - n3;
        int[] nArray = integerComponentRaster.getDataStorage();
        if (this.cyclic) {
            this.cycleFillRaster(nArray, n5, n6, n3, n4, d, this.dx, this.dy);
        } else {
            this.clipFillRaster(nArray, n5, n6, n3, n4, d, this.dx, this.dy);
        }
        return raster;
    }
}

