/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPaneAdjustable;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.peer.LightweightPeer;
import java.awt.peer.ScrollPanePeer;
import java.io.Serializable;

public class ScrollPane
extends Container {
    public static final int SCROLLBARS_AS_NEEDED = 0;
    public static final int SCROLLBARS_ALWAYS = 1;
    public static final int SCROLLBARS_NEVER = 2;
    private int scrollbarDisplayPolicy;
    private ScrollPaneAdjustable vAdjustable;
    private ScrollPaneAdjustable hAdjustable;
    private static final String base = "scrollpane";
    private static int nameCounter;
    private static final long serialVersionUID = 7956609840827222915L;

    static {
        Toolkit.loadLibraries();
        ScrollPane.initIDs();
        nameCounter = 0;
    }

    public ScrollPane() {
        this(0);
    }

    public ScrollPane(int n) {
        this.layoutMgr = null;
        this.width = 100;
        this.height = 100;
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.scrollbarDisplayPolicy = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal scrollbar display policy");
            }
        }
        this.vAdjustable = new ScrollPaneAdjustable(this, new PeerFixer(this), 1);
        this.hAdjustable = new ScrollPaneAdjustable(this, new PeerFixer(this), 0);
    }

    protected final void addImpl(Component component, Object object, int n) {
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            if (this.getComponentCount() > 0) {
                this.remove(0);
            }
            if (n > 0) {
                throw new IllegalArgumentException("position greater than 0");
            }
            super.addImpl(component, object, n);
        }
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n = 0;
            int n2 = 0;
            if (this.getComponentCount() > 0) {
                n = this.vAdjustable.getValue();
                n2 = this.hAdjustable.getValue();
                this.vAdjustable.setValue(0);
                this.hAdjustable.setValue(0);
            }
            if (this.peer == null) {
                this.peer = this.getToolkit().createScrollPane(this);
            }
            super.addNotify();
            if (this.getComponentCount() > 0) {
                this.vAdjustable.setValue(n);
                this.hAdjustable.setValue(n2);
            }
            if (this.getComponentCount() > 0) {
                Component component = this.getComponent(0);
                if (component.peer instanceof LightweightPeer) {
                    this.remove(0);
                    Panel panel = new Panel();
                    panel.setLayout(new BorderLayout());
                    panel.add(component);
                    this.add(panel);
                }
            }
        }
    }

    Dimension calculateChildSize() {
        boolean bl;
        boolean bl2;
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        int n = dimension.width - insets.left * 2;
        int n2 = dimension.height - insets.top * 2;
        Component component = this.getComponent(0);
        Dimension dimension2 = new Dimension(component.getPreferredSize());
        if (this.scrollbarDisplayPolicy == 0) {
            bl2 = dimension2.height > n2;
            bl = dimension2.width > n;
        } else if (this.scrollbarDisplayPolicy == 1) {
            bl = true;
            bl2 = true;
        } else {
            bl = false;
            bl2 = false;
        }
        int n3 = this.getVScrollbarWidth();
        int n4 = this.getHScrollbarHeight();
        if (bl2) {
            n -= n3;
        }
        if (bl) {
            n2 -= n4;
        }
        if (dimension2.width < n) {
            dimension2.width = n;
        }
        if (dimension2.height < n2) {
            dimension2.height = n2;
        }
        return dimension2;
    }

    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            String string = base + nameCounter++;
            Object var3_3 = null;
            return string;
        }
    }

    public void doLayout() {
        this.layout();
    }

    public Adjustable getHAdjustable() {
        return this.hAdjustable;
    }

    public int getHScrollbarHeight() {
        ScrollPanePeer scrollPanePeer;
        int n = 0;
        if (this.scrollbarDisplayPolicy != 2 && (scrollPanePeer = (ScrollPanePeer)this.peer) != null) {
            n = scrollPanePeer.getHScrollbarHeight();
        }
        return n;
    }

    public Point getScrollPosition() {
        if (this.ncomponents <= 0) {
            throw new NullPointerException("child is null");
        }
        return new Point(this.hAdjustable.getValue(), this.vAdjustable.getValue());
    }

    public int getScrollbarDisplayPolicy() {
        return this.scrollbarDisplayPolicy;
    }

    public Adjustable getVAdjustable() {
        return this.vAdjustable;
    }

    public int getVScrollbarWidth() {
        ScrollPanePeer scrollPanePeer;
        int n = 0;
        if (this.scrollbarDisplayPolicy != 2 && (scrollPanePeer = (ScrollPanePeer)this.peer) != null) {
            n = scrollPanePeer.getVScrollbarWidth();
        }
        return n;
    }

    public Dimension getViewportSize() {
        Insets insets = this.getInsets();
        return new Dimension(this.width - insets.right - insets.left, this.height - insets.top - insets.bottom);
    }

    private static native void initIDs();

    public void layout() {
        if (this.ncomponents > 0) {
            Component component = this.getComponent(0);
            Point point = this.getScrollPosition();
            Dimension dimension = this.calculateChildSize();
            Dimension dimension2 = this.getViewportSize();
            Insets insets = this.getInsets();
            component.reshape(insets.left - point.x, insets.top - point.y, dimension.width, dimension.height);
            ScrollPanePeer scrollPanePeer = (ScrollPanePeer)this.peer;
            if (scrollPanePeer != null) {
                scrollPanePeer.childResized(dimension.width, dimension.height);
            }
            dimension2 = this.getViewportSize();
            this.hAdjustable.setSpan(0, dimension.width, dimension2.width);
            this.vAdjustable.setSpan(0, dimension.height, dimension2.height);
        }
    }

    public String paramString() {
        String string;
        switch (this.scrollbarDisplayPolicy) {
            case 0: {
                string = "as-needed";
                break;
            }
            case 1: {
                string = "always";
                break;
            }
            case 2: {
                string = "never";
                break;
            }
            default: {
                string = "invalid display policy";
            }
        }
        Point point = this.ncomponents > 0 ? this.getScrollPosition() : new Point(0, 0);
        Insets insets = this.getInsets();
        return String.valueOf(super.paramString()) + ",ScrollPosition=(" + point.x + "," + point.y + ")" + ",Insets=(" + insets.top + "," + insets.left + "," + insets.bottom + "," + insets.right + ")" + ",ScrollbarDisplayPolicy=" + string;
    }

    public void printComponents(Graphics graphics) {
        if (this.ncomponents > 0) {
            Component component = this.component[0];
            Point point = component.getLocation();
            Dimension dimension = this.getViewportSize();
            Insets insets = this.getInsets();
            Graphics graphics2 = graphics.create();
            try {
                graphics2.clipRect(insets.left, insets.top, dimension.width, dimension.height);
                graphics2.translate(point.x, point.y);
                component.printAll(graphics2);
            }
            finally {
                Object var8_7 = null;
                graphics2.dispose();
            }
        }
    }

    public final void setLayout(LayoutManager layoutManager) {
        throw new AWTError("ScrollPane controls layout");
    }

    public void setScrollPosition(int n, int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.ncomponents <= 0) {
                throw new NullPointerException("child is null");
            }
            this.hAdjustable.setValue(n);
            this.vAdjustable.setValue(n2);
        }
    }

    public void setScrollPosition(Point point) {
        this.setScrollPosition(point.x, point.y);
    }

    class PeerFixer
    implements AdjustmentListener,
    Serializable {
        private ScrollPane scroller;

        PeerFixer(ScrollPane scrollPane2) {
            this.scroller = scrollPane2;
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Adjustable adjustable = adjustmentEvent.getAdjustable();
            int n = adjustmentEvent.getValue();
            ScrollPanePeer scrollPanePeer = (ScrollPanePeer)this.scroller.peer;
            if (scrollPanePeer != null) {
                scrollPanePeer.setValue(adjustable, n);
            }
            Component component = this.scroller.getComponent(0);
            switch (adjustable.getOrientation()) {
                case 1: {
                    component.move(component.getLocation().x, -n);
                    break;
                }
                case 0: {
                    component.move(-n, component.getLocation().y);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal adjustable orientation");
                }
            }
        }
    }
}

