/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.TextComponent;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.TextFieldPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TextField
extends TextComponent {
    int columns;
    char echoChar;
    transient ActionListener actionListener;
    private static final String base = "textfield";
    private static int nameCounter = 0;
    private static final long serialVersionUID = -2966288784432217853L;
    private int textFieldSerializedDataVersion = 1;

    static {
        Toolkit.loadLibraries();
        TextField.initIDs();
    }

    public TextField() {
        this("", 0);
    }

    public TextField(int n) {
        this("", n);
    }

    public TextField(String string) {
        this(string, string != null ? string.length() : 0);
    }

    public TextField(String string, int n) {
        super(string);
        this.columns = n;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
        this.newEventsOnly = true;
    }

    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = this.getToolkit().createTextField(this);
            }
            super.addNotify();
        }
    }

    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            String string = base + nameCounter++;
            Object var3_3 = null;
            return string;
        }
    }

    public boolean echoCharIsSet() {
        return this.echoChar != '\u0000';
    }

    boolean eventEnabled(AWTEvent aWTEvent) {
        if (aWTEvent.id == 1001) {
            return (this.eventMask & 0x80L) != 0L || this.actionListener != null;
        }
        return super.eventEnabled(aWTEvent);
    }

    public int getColumns() {
        return this.columns;
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension getMinimumSize(int n) {
        return this.minimumSize(n);
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension getPreferredSize(int n) {
        return this.preferredSize(n);
    }

    private static native void initIDs();

    public Dimension minimumSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension = this.columns > 0 ? this.minimumSize(this.columns) : super.minimumSize();
            Object var3_3 = null;
            return dimension;
        }
    }

    public Dimension minimumSize(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            TextFieldPeer textFieldPeer = (TextFieldPeer)this.peer;
            Dimension dimension = textFieldPeer != null ? textFieldPeer.minimumSize(n) : super.minimumSize();
            Object var4_5 = null;
            return dimension;
        }
    }

    protected String paramString() {
        String string = super.paramString();
        if (this.echoChar != '\u0000') {
            string = String.valueOf(string) + ",echo=" + this.echoChar;
        }
        return string;
    }

    public Dimension preferredSize() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Dimension dimension = this.columns > 0 ? this.preferredSize(this.columns) : super.preferredSize();
            Object var3_3 = null;
            return dimension;
        }
    }

    public Dimension preferredSize(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            TextFieldPeer textFieldPeer = (TextFieldPeer)this.peer;
            Dimension dimension = textFieldPeer != null ? textFieldPeer.preferredSize(n) : super.preferredSize();
            Object var4_5 = null;
            return dimension;
        }
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(actionEvent);
        }
    }

    protected void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        Object object;
        objectInputStream.defaultReadObject();
        while ((object = objectInputStream.readObject()) != null) {
            String string = ((String)object).intern();
            if (string == "actionL") {
                this.addActionListener((ActionListener)objectInputStream.readObject());
                continue;
            }
            objectInputStream.readObject();
        }
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        if (actionListener == null) {
            return;
        }
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public synchronized void setColumns(int n) {
        int n2 = this.columns;
        if (n < 0) {
            throw new IllegalArgumentException("columns less than zero.");
        }
        if (n != n2) {
            this.columns = n;
            this.invalidate();
        }
    }

    public void setEchoChar(char c) {
        this.setEchoCharacter(c);
    }

    public synchronized void setEchoCharacter(char c) {
        this.echoChar = c;
        TextFieldPeer textFieldPeer = (TextFieldPeer)this.peer;
        if (textFieldPeer != null) {
            textFieldPeer.setEchoCharacter(c);
        }
    }

    public void setText(String string) {
        super.setText(string);
        if (this.valid) {
            this.invalidate();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        AWTEventMulticaster.save(objectOutputStream, "actionL", this.actionListener);
        objectOutputStream.writeObject(null);
    }
}

