/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GraphicAttribute;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.im.InputMethodHighlight;
import java.text.Annotation;
import java.text.AttributedCharacterIterator;
import java.util.Hashtable;
import java.util.Map;
import sun.awt.SunToolkit;
import sun.awt.font.Bidi;
import sun.awt.font.ExtendedTextLabel;
import sun.awt.font.ExtendedTextLabelComponent;
import sun.awt.font.GraphicComponent;
import sun.awt.font.TextLabelFactory;
import sun.awt.font.TextLineComponent;
import sun.awt.im.InputMethodHighlightMapping;
import sun.java2d.SunGraphicsEnvironment;

final class TextLine {
    private TextLineComponent[] fComponents;
    private byte[] fComponentBaselines;
    private float[] fBaselineOffsets;
    private int[] fComponentVisualOrder;
    private char[] fChars;
    private int fCharsStart;
    private int fCharsLimit;
    private int[] fCharVisualOrder;
    private int[] fCharLogicalOrder;
    private byte[] fCharLevels;
    private boolean fIsDirectionLTR;
    private TextLineMetrics fMetrics = null;
    private static Function fgAdvanceF = new Function(){

        float computeFunction(TextLine textLine, int n, int n2) {
            TextLineComponent textLineComponent = textLine.fComponents[n];
            return textLineComponent.getCharAdvance(n2);
        }
    };
    private static Function fgXPositionF = new Function(){

        float computeFunction(TextLine textLine, int n, int n2) {
            int n3;
            float f = 0.0f;
            if (textLine.fComponentVisualOrder == null) {
                n3 = 0;
                while (n3 < n) {
                    Rectangle2D rectangle2D = textLine.fComponents[n3].getLogicalBounds();
                    f += (float)rectangle2D.getWidth();
                    ++n3;
                }
            } else {
                n3 = 0;
                while (textLine.fComponentVisualOrder[n3] != n) {
                    int n4 = textLine.fComponentVisualOrder[n3];
                    Rectangle2D rectangle2D = textLine.fComponents[n4].getLogicalBounds();
                    f += (float)rectangle2D.getWidth();
                    ++n3;
                }
            }
            TextLineComponent textLineComponent = textLine.fComponents[n];
            return f + textLineComponent.getCharX(n2);
        }
    };
    private static Function fgYPositionF = new Function(){

        float computeFunction(TextLine textLine, int n, int n2) {
            TextLineComponent textLineComponent = textLine.fComponents[n];
            float f = textLineComponent.getCharY(n2);
            return f + textLine.getComponentShift(n);
        }
    };

    public TextLine(TextLineComponent[] textLineComponentArray, byte[] byArray, float[] fArray, int[] nArray, char[] cArray, int n, int n2, int[] nArray2, byte[] byArray2, boolean bl) {
        this.fComponents = textLineComponentArray;
        this.fComponentBaselines = byArray;
        this.fBaselineOffsets = fArray;
        this.fComponentVisualOrder = nArray;
        this.fChars = cArray;
        this.fCharsStart = n;
        this.fCharsLimit = n2;
        this.fCharLogicalOrder = nArray2;
        this.fCharLevels = byArray2;
        this.fIsDirectionLTR = bl;
    }

    private static Map addInputMethodAttrs(Map map) {
        Object object = map.get(TextAttribute.INPUT_METHOD_HIGHLIGHT);
        try {
            if (object != null) {
                if (object instanceof Annotation) {
                    object = ((Annotation)object).getValue();
                }
                InputMethodHighlight inputMethodHighlight = (InputMethodHighlight)object;
                SunToolkit sunToolkit = (SunToolkit)Toolkit.getDefaultToolkit();
                InputMethodHighlightMapping inputMethodHighlightMapping = sunToolkit.getInputMethodHighlightMapping();
                Map map2 = inputMethodHighlightMapping.mapHighlight(inputMethodHighlight);
                if (map2 != null) {
                    Hashtable hashtable = new Hashtable(5, 0.9f);
                    hashtable.putAll(map);
                    hashtable.putAll(map2);
                    return hashtable;
                }
            }
        }
        catch (ClassCastException classCastException) {}
        return map;
    }

    private float applyFunctionAtIndex(int n, Function function) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fComponents.length) {
            int n4 = n2 + this.fComponents[n3].getNumCharacters();
            if (n4 > n) {
                return function.computeFunction(this, n3, n - n2);
            }
            n2 = n4;
            ++n3;
        }
        throw new IllegalArgumentException("logicalIndex too large.");
    }

    public int characterCount() {
        return this.fCharsLimit - this.fCharsStart;
    }

    public static TextLine createLineFromText(char[] cArray, int n, int n2, FontSource fontSource, TextLabelFactory textLabelFactory, boolean bl, float[] fArray) {
        textLabelFactory.setLineContext(n, n2);
        Bidi bidi = textLabelFactory.getLineBidi();
        int[] nArray = null;
        byte[] byArray = null;
        if (bidi != null) {
            nArray = bidi.getLogicalToVisualMap();
            byArray = bidi.getLevels();
        }
        byte[][] byArray2 = new byte[1][];
        TextLineComponent[] textLineComponentArray = TextLine.getComponents(fontSource, cArray, n, n2, nArray, byArray, textLabelFactory, byArray2);
        int[] nArray2 = null;
        if (nArray != null && textLineComponentArray.length > 1) {
            nArray2 = new int[textLineComponentArray.length];
            int n3 = 0;
            int n4 = 0;
            while (n4 < textLineComponentArray.length) {
                nArray2[n4] = nArray[n3];
                n3 += textLineComponentArray[n4].getNumCharacters();
                ++n4;
            }
            nArray2 = Bidi.getContiguousOrder(nArray2);
            nArray2 = Bidi.getInverseOrder(nArray2);
        }
        return new TextLine(textLineComponentArray, byArray2[0], fArray, nArray2, cArray, n, n2, nArray, byArray, bl);
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        float f3 = f;
        int n = 0;
        while (n < this.fComponents.length) {
            int n2 = this.fComponentVisualOrder == null ? n : this.fComponentVisualOrder[n];
            TextLineComponent textLineComponent = this.fComponents[n2];
            float f4 = this.getComponentShift(n2);
            textLineComponent.draw(graphics2D, f3, f2 + f4);
            if (n != this.fComponents.length - 1) {
                Rectangle2D rectangle2D = textLineComponent.getLogicalBounds();
                f3 += (float)rectangle2D.getWidth();
            }
            ++n;
        }
    }

    private static TextLineComponent[] expandArrays(TextLineComponent[] textLineComponentArray, byte[][] byArray) {
        TextLineComponent[] textLineComponentArray2 = new TextLineComponent[textLineComponentArray.length + 8];
        System.arraycopy(textLineComponentArray, 0, textLineComponentArray2, 0, textLineComponentArray.length);
        if (byArray != null) {
            byte[] byArray2 = new byte[textLineComponentArray2.length + 8];
            System.arraycopy(byArray[0], 0, byArray2, 0, textLineComponentArray.length);
            byArray[0] = byArray2;
        }
        return textLineComponentArray2;
    }

    public static TextLine fastCreateTextLine(FontRenderContext fontRenderContext, char[] cArray, int n, int n2, Font font, LineMetrics lineMetrics, Map map) {
        byte[] byArray;
        TextLineComponent[] textLineComponentArray;
        char[] cArray2;
        boolean bl = true;
        byte[] byArray2 = null;
        int[] nArray = null;
        Bidi bidi = null;
        int n3 = n2 - n;
        if (n != 0) {
            cArray2 = new char[n3];
            System.arraycopy(cArray, n, cArray2, 0, n3);
        } else {
            cArray2 = cArray;
        }
        int n4 = 0;
        while (n4 < cArray2.length) {
            if (Bidi.requiresBidi(cArray2[n4])) {
                bidi = new Bidi(cArray2);
                bl = bidi.isDirectionLTR();
                byArray2 = bidi.getLevels();
                nArray = bidi.getLogicalToVisualMap();
                break;
            }
            ++n4;
        }
        if (map != null) {
            map = TextLine.addInputMethodAttrs(map);
        }
        TextLabelFactory textLabelFactory = new TextLabelFactory(fontRenderContext, cArray2, bidi);
        int[] nArray2 = null;
        if (bidi == null || bidi.getLevelLimit(0) == n3) {
            textLineComponentArray = new TextLineComponent[1];
            byArray = new byte[1];
            ExtendedTextLabel extendedTextLabel = textLabelFactory.createExtended(font, lineMetrics, 0, n3);
            textLineComponentArray[0] = new ExtendedTextLabelComponent(extendedTextLabel, map);
            byArray[0] = font.getBaselineFor(cArray2[0]);
        } else {
            int n5;
            int n6 = 0;
            int n7 = 0;
            while (n7 < n3) {
                n7 = bidi.getLevelLimit(n7);
                ++n6;
            }
            textLineComponentArray = new TextLineComponent[n6];
            byArray = new byte[n6];
            byte by = font.getBaselineFor(cArray2[0]);
            n6 = 0;
            n7 = 0;
            while (n7 < n3) {
                n5 = bidi.getLevelLimit(n7);
                ExtendedTextLabel extendedTextLabel = textLabelFactory.createExtended(font, lineMetrics, n7, n5);
                textLineComponentArray[n6] = new ExtendedTextLabelComponent(extendedTextLabel, map);
                byArray[n6] = by;
                ++n6;
                n7 = n5;
            }
            if (nArray != null) {
                nArray2 = new int[textLineComponentArray.length];
                n5 = 0;
                int n8 = 0;
                while (n8 < textLineComponentArray.length) {
                    nArray2[n8] = nArray[n5];
                    n5 += textLineComponentArray[n8].getNumCharacters();
                    ++n8;
                }
                nArray2 = Bidi.getContiguousOrder(nArray2);
                nArray2 = Bidi.getInverseOrder(nArray2);
            }
        }
        return new TextLine(textLineComponentArray, byArray, lineMetrics.getBaselineOffsets(), nArray2, cArray, n, n2, nArray, byArray2, bl);
    }

    private static int firstVisualChunk(int[] nArray, byte[] byArray, int n, int n2) {
        if (nArray != null && byArray != null) {
            byte by = byArray[n];
            while (++n < n2 && byArray[n] == by) {
            }
            return n;
        }
        return n2;
    }

    public Rectangle2D getBounds() {
        float f = 0.0f;
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MIN_VALUE;
        float f4 = Float.MAX_VALUE;
        float f5 = Float.MIN_VALUE;
        int n = 0;
        while (n < this.fComponents.length) {
            int n2 = this.fComponentVisualOrder == null ? n : this.fComponentVisualOrder[n];
            TextLineComponent textLineComponent = this.fComponents[n2];
            Rectangle2D rectangle2D = textLineComponent.getVisualBounds();
            f2 = Math.min(f2, (float)rectangle2D.getX() + f);
            f3 = Math.max(f3, (float)rectangle2D.getMaxX() + f);
            float f6 = this.getComponentShift(n2);
            f4 = Math.min(f4, (float)rectangle2D.getY() + f6);
            f5 = Math.max(f5, (float)rectangle2D.getMaxY() + f6);
            Rectangle2D rectangle2D2 = textLineComponent.getLogicalBounds();
            f += (float)rectangle2D2.getWidth();
            ++n;
        }
        return new Rectangle2D.Float(f2, f4, f3 - f2, f5 - f4);
    }

    public float getCharAdvance(int n) {
        return this.applyFunctionAtIndex(n, fgAdvanceF);
    }

    public float getCharAngle(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        if (n > this.fCharsLimit - this.fCharsStart) {
            throw new IllegalArgumentException("logicalIndex too large.");
        }
        int n2 = 0;
        int n3 = 0;
        while ((n3 += this.fComponents[n2].getNumCharacters()) <= n && ++n2 < this.fComponents.length) {
        }
        return this.fComponents[n2].getItalicAngle();
    }

    public float getCharAscent(int n) {
        return this.getLineMetricsAt(n).getAscent();
    }

    public Rectangle2D getCharBounds(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fComponents.length) {
            int n4 = n2 + this.fComponents[n3].getNumCharacters();
            if (n4 > n) {
                TextLineComponent textLineComponent = this.fComponents[n3];
                int n5 = n - n2;
                Rectangle2D rectangle2D = textLineComponent.getCharVisualBounds(n5);
                float f = 0.0f;
                if (this.fComponentVisualOrder == null) {
                    int n6 = 0;
                    while (n6 < n3) {
                        Rectangle2D rectangle2D2 = this.fComponents[n6].getLogicalBounds();
                        f += (float)rectangle2D2.getWidth();
                        ++n6;
                    }
                } else {
                    int n7 = 0;
                    while (this.fComponentVisualOrder[n7] != n3) {
                        int n8 = this.fComponentVisualOrder[n7];
                        Rectangle2D rectangle2D3 = this.fComponents[n8].getLogicalBounds();
                        f += (float)rectangle2D3.getWidth();
                        ++n7;
                    }
                }
                rectangle2D.setRect(rectangle2D.getX() + (double)f, rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
                return rectangle2D;
            }
            n2 = n4;
            ++n3;
        }
        throw new IllegalArgumentException("logicalIndex too large.");
    }

    public float getCharDescent(int n) {
        return this.getLineMetricsAt(n).getDescent();
    }

    public byte getCharLevel(int n) {
        return this.fCharLevels == null ? (byte)0 : this.fCharLevels[n];
    }

    public float getCharLinePosition(int n) {
        return this.getCharXPosition(n);
    }

    public int getCharType(int n) {
        return Character.getType(this.fChars[n + this.fCharsStart]);
    }

    public float getCharXPosition(int n) {
        return this.applyFunctionAtIndex(n, fgXPositionF);
    }

    public float getCharYPosition(int n) {
        return this.applyFunctionAtIndex(n, fgYPositionF);
    }

    private float getComponentShift(int n) {
        byte by = this.fComponentBaselines[n];
        if (by >= 0) {
            return this.fBaselineOffsets[by];
        }
        TextLineMetrics textLineMetrics = this.getMetrics();
        LineMetrics lineMetrics = this.fComponents[n].getLineMetrics();
        if (by == -1) {
            return lineMetrics.getAscent() - textLineMetrics.ascent;
        }
        return textLineMetrics.descent - lineMetrics.getDescent();
    }

    public static TextLineComponent[] getComponents(FontSource fontSource, char[] cArray, int n, int n2, int[] nArray, byte[] byArray, TextLabelFactory textLabelFactory, byte[][] byArray2) {
        TextLineComponent[] textLineComponentArray;
        FontRenderContext fontRenderContext = textLabelFactory.getFontRenderContext();
        int n3 = 0;
        TextLineComponent[] textLineComponentArray2 = new TextLineComponent[8];
        if (byArray2 != null) {
            byArray2[0] = new byte[8];
        }
        int n4 = n;
        do {
            Object object;
            int n5;
            GraphicAttribute graphicAttribute;
            int n6;
            if ((n6 = fontSource.getRunLimit(n4)) > n2) {
                n6 = n2;
            }
            if ((graphicAttribute = fontSource.graphicAt(n4)) != null) {
                do {
                    n5 = n + TextLine.firstVisualChunk(nArray, byArray, n4 - n, n6 - n);
                    object = fontSource.attributesAt(n4);
                    GraphicComponent graphicComponent = new GraphicComponent(graphicAttribute, (Map)object, nArray, byArray, n4 - n, n5 - n);
                    n4 = n5;
                    if (++n3 >= textLineComponentArray2.length) {
                        textLineComponentArray2 = TextLine.expandArrays(textLineComponentArray2, byArray2);
                    }
                    textLineComponentArray2[n3 - 1] = graphicComponent;
                    if (byArray2 == null) continue;
                    byArray2[0][n3 - 1] = (byte)graphicAttribute.getAlignment();
                } while (n4 < n6);
                continue;
            }
            do {
                n5 = n6;
                object = fontSource.fontAt(n4);
                if (object == null && (n5 = ((Font)(object = fontSource.getBestFontAt(n4))).canDisplayUpTo(cArray, n4, n6)) == n4) {
                    ++n5;
                }
                do {
                    int n7 = n + TextLine.firstVisualChunk(nArray, byArray, n4 - n, n5 - n);
                    do {
                        Map map = fontSource.attributesAt(n4);
                        int n8 = n4;
                        LineMetrics lineMetrics = ((Font)object).getLineMetrics(cArray, n4, n7, fontRenderContext);
                        ExtendedTextLabel extendedTextLabel = textLabelFactory.createExtended((Font)object, lineMetrics, n8, n4 += lineMetrics.getNumChars());
                        map = TextLine.addInputMethodAttrs(map);
                        ExtendedTextLabelComponent extendedTextLabelComponent = new ExtendedTextLabelComponent(extendedTextLabel, map);
                        if (++n3 >= textLineComponentArray2.length) {
                            textLineComponentArray2 = TextLine.expandArrays(textLineComponentArray2, byArray2);
                        }
                        textLineComponentArray2[n3 - 1] = extendedTextLabelComponent;
                        if (byArray2 == null) continue;
                        byArray2[0][n3 - 1] = (byte)lineMetrics.getBaselineIndex();
                    } while (n4 < n7);
                } while (n4 < n5);
            } while (n4 < n6);
        } while (n4 < n2);
        if (textLineComponentArray2.length == n3) {
            textLineComponentArray = textLineComponentArray2;
        } else {
            textLineComponentArray = new TextLineComponent[n3];
            System.arraycopy(textLineComponentArray2, 0, textLineComponentArray, 0, n3);
        }
        return textLineComponentArray;
    }

    private LineMetrics getLineMetricsAt(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        if (n > this.fCharsLimit - this.fCharsStart) {
            throw new IllegalArgumentException("logicalIndex too large.");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((n4 += this.fComponents[n2].getNumCharacters()) <= n) {
            n3 = n4;
            if (++n2 < this.fComponents.length) continue;
        }
        return this.fComponents[n2].getLineMetrics();
    }

    public TextLineMetrics getMetrics() {
        if (this.fMetrics == null) {
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            boolean bl = false;
            int n = 0;
            while (n < this.fComponents.length) {
                float f7;
                float f8;
                TextLineComponent textLineComponent = this.fComponents[n];
                Rectangle2D rectangle2D = textLineComponent.getLogicalBounds();
                f4 += (float)rectangle2D.getWidth();
                byte by = this.fComponentBaselines[n];
                int n2 = textLineComponent.getNumCharacters();
                LineMetrics lineMetrics = textLineComponent.getLineMetrics();
                if (by >= 0) {
                    f8 = this.fBaselineOffsets[by];
                    f = Math.max(f, -f8 + lineMetrics.getAscent());
                    f7 = f8 + lineMetrics.getDescent();
                    f2 = Math.max(f2, f7);
                    f3 = Math.max(f3, f7 + lineMetrics.getLeading());
                } else {
                    bl = true;
                    f8 = lineMetrics.getAscent() + lineMetrics.getDescent();
                    f7 = f8 + lineMetrics.getLeading();
                    f5 = Math.max(f5, f8);
                    f6 = Math.max(f6, f7);
                }
                ++n;
            }
            if (bl) {
                if (f5 > f + f2) {
                    f2 = f5 - f;
                }
                if (f6 > f + f3) {
                    f3 = f6 - f;
                }
            }
            this.fMetrics = new TextLineMetrics(f, f2, f3 -= f2, f4);
        }
        return this.fMetrics;
    }

    public Shape getOutline(AffineTransform affineTransform) {
        GeneralPath generalPath = new GeneralPath(0);
        float f = 0.0f;
        int n = 0;
        while (n < this.fComponents.length) {
            int n2 = this.fComponentVisualOrder == null ? n : this.fComponentVisualOrder[n];
            TextLineComponent textLineComponent = this.fComponents[n2];
            float f2 = this.getComponentShift(n2);
            generalPath.append(textLineComponent.getOutline(f, f2), false);
            Rectangle2D rectangle2D = textLineComponent.getLogicalBounds();
            f += (float)rectangle2D.getWidth();
            ++n;
        }
        if (affineTransform != null) {
            generalPath.transform(affineTransform);
        }
        return generalPath;
    }

    public int hashCode() {
        return this.fComponents.length << 16 ^ this.fComponents[0].hashCode() << 3 ^ this.fCharsLimit - this.fCharsStart;
    }

    public boolean isCharLTR(int n) {
        return (this.getCharLevel(n) & 1) == 0;
    }

    public boolean isCharSpace(int n) {
        return Character.isSpaceChar(this.fChars[n + this.fCharsStart]);
    }

    public boolean isCharWhitespace(int n) {
        return Character.isWhitespace(this.fChars[n + this.fCharsStart]);
    }

    public boolean isDirectionLTR() {
        return this.fIsDirectionLTR;
    }

    public int logicalToVisual(int n) {
        return this.fCharLogicalOrder == null ? n : this.fCharLogicalOrder[n];
    }

    public static TextLine standardCreateTextLine(FontRenderContext fontRenderContext, AttributedCharacterIterator attributedCharacterIterator, char[] cArray, float[] fArray) {
        ACIFontSource aCIFontSource = new ACIFontSource(attributedCharacterIterator);
        boolean bl = true;
        Bidi bidi = null;
        int n = 0;
        while (n < cArray.length) {
            if (Bidi.requiresBidi(cArray[n])) {
                bidi = new Bidi(cArray);
                bl = bidi.isDirectionLTR();
                break;
            }
            ++n;
        }
        TextLabelFactory textLabelFactory = new TextLabelFactory(fontRenderContext, cArray, bidi);
        return TextLine.createLineFromText(cArray, 0, cArray.length, aCIFontSource, textLabelFactory, bl, fArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.fComponents.length) {
            stringBuffer.append(this.fComponents[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public int visualToLogical(int n) {
        if (this.fCharLogicalOrder == null) {
            return n;
        }
        if (this.fCharVisualOrder == null) {
            this.fCharVisualOrder = Bidi.getInverseOrder(this.fCharLogicalOrder);
        }
        return this.fCharVisualOrder[n];
    }

    public static final class TextLineMetrics {
        public final float ascent;
        public final float descent;
        public final float leading;
        public final float advance;

        public TextLineMetrics(float f, float f2, float f3, float f4) {
            this.ascent = f;
            this.descent = f2;
            this.leading = f3;
            this.advance = f4;
        }
    }

    private static abstract class Function {
        Function() {
        }

        abstract float computeFunction(TextLine var1, int var2, int var3);
    }

    static abstract class FontSource {
        FontSource() {
        }

        abstract Map attributesAt(int var1);

        abstract Font fontAt(int var1);

        abstract Font getBestFontAt(int var1);

        abstract int getLength();

        abstract int getRunLimit(int var1);

        abstract GraphicAttribute graphicAt(int var1);
    }

    static class ACIFontSource
    extends FontSource {
        private AttributedCharacterIterator fIter;
        private int fIterStart;

        public ACIFontSource(AttributedCharacterIterator attributedCharacterIterator) {
            this.fIter = attributedCharacterIterator;
            this.fIterStart = attributedCharacterIterator.getBeginIndex();
        }

        Map attributesAt(int n) {
            this.fIter.setIndex(n + this.fIterStart);
            return this.fIter.getAttributes();
        }

        Font fontAt(int n) {
            this.fIter.setIndex(n + this.fIterStart);
            return (Font)this.fIter.getAttribute(TextAttribute.FONT);
        }

        Font getBestFontAt(int n) {
            int n2 = n + this.fIterStart;
            this.fIter.setIndex(n2);
            return SunGraphicsEnvironment.getBestFontFor(this.fIter, n2, this.fIter.getRunLimit());
        }

        int getLength() {
            return this.fIter.getEndIndex() - this.fIterStart;
        }

        int getRunLimit(int n) {
            this.fIter.setIndex(n + this.fIterStart);
            return this.fIter.getRunLimit() - this.fIterStart;
        }

        GraphicAttribute graphicAt(int n) {
            this.fIter.setIndex(n + this.fIterStart);
            return (GraphicAttribute)this.fIter.getAttribute(TextAttribute.CHAR_REPLACEMENT);
        }
    }
}

