/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.font.TextLine;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;
import sun.awt.font.Bidi;
import sun.awt.font.TextLabelFactory;
import sun.awt.font.TextLineComponent;

class TextMeasurer {
    private FontRenderContext fFrc;
    private int fStart;
    private char[] fChars;
    private AttributedString fText;
    private TextLine.FontSource fFontSource;
    private TextLabelFactory fFactory;
    private TextLineComponent[] fComponents;
    private boolean fIsDirectionLTR;
    private byte fBaseline;
    private float[] fBaselineOffsets;
    private float fJustifyRatio;

    public TextMeasurer(AttributedCharacterIterator attributedCharacterIterator, FontRenderContext fontRenderContext) {
        this.fFrc = fontRenderContext;
        this.initSelf(attributedCharacterIterator);
    }

    private int calcLineBreak(int n, float f) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fComponents.length) {
            int n4 = n2 + this.fComponents[n3].getNumCharacters();
            if (n4 > n) break;
            n2 = n4;
            ++n3;
        }
        while (n3 < this.fComponents.length) {
            TextLineComponent textLineComponent = this.fComponents[n3];
            int n5 = textLineComponent.getNumCharacters();
            int n6 = textLineComponent.getLineBreakIndex(n - n2, f);
            if (n6 == n5) {
                f -= textLineComponent.getAdvanceBetween(n - n2, n6);
            } else {
                return n2 + n6;
            }
            n = n2 += n5;
            ++n3;
        }
        return this.fChars.length;
    }

    private static AttributedString createAttrString(AttributedCharacterIterator attributedCharacterIterator, char[] cArray) {
        String string = new String(cArray);
        int n = attributedCharacterIterator.getBeginIndex();
        AttributedString attributedString = new AttributedString(string);
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            Map map = attributedCharacterIterator.getAttributes();
            attributedString.addAttributes(map, attributedCharacterIterator.getRunStart() - n, attributedCharacterIterator.getRunLimit() - n);
            c = attributedCharacterIterator.setIndex(attributedCharacterIterator.getRunLimit());
        }
        return attributedString;
    }

    public void deleteChar(AttributedCharacterIterator attributedCharacterIterator, int n) {
        this.initSelf(attributedCharacterIterator);
    }

    public float getAdvanceBetween(int n, int n2) {
        TextLayout textLayout = this.getLayout(n, n2);
        return textLayout.getAdvance();
    }

    public TextLayout getLayout(int n, int n2) {
        TextLine textLine = TextLine.createLineFromText(this.fChars, n - this.fStart, n2 - this.fStart, this.fFontSource, this.fFactory, this.fIsDirectionLTR, this.fBaselineOffsets);
        return new TextLayout(textLine, this.fBaseline, this.fBaselineOffsets, this.fJustifyRatio);
    }

    public int getLineBreakIndex(int n, float f) {
        return this.calcLineBreak(n - this.fStart, f) + this.fStart;
    }

    private void initSelf(AttributedCharacterIterator attributedCharacterIterator) {
        this.fStart = attributedCharacterIterator.getBeginIndex();
        this.fChars = new char[attributedCharacterIterator.getEndIndex() - this.fStart];
        int n = 0;
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            this.fChars[n++] = c;
            c = attributedCharacterIterator.next();
        }
        this.fText = TextMeasurer.createAttrString(attributedCharacterIterator, this.fChars);
        this.fFontSource = new TextLine.ACIFontSource(this.fText.getIterator());
        Bidi bidi = new Bidi(this.fChars);
        this.fIsDirectionLTR = bidi.isDirectionLTR();
        this.fFactory = new TextLabelFactory(this.fFrc, this.fChars, bidi);
        TextLine.ACIFontSource aCIFontSource = new TextLine.ACIFontSource(attributedCharacterIterator);
        int[] nArray = bidi.getLogicalToVisualMap();
        byte[] byArray = bidi.getLevels();
        this.fComponents = TextLine.getComponents(this.fFontSource, this.fChars, 0, this.fChars.length, nArray, byArray, this.fFactory, null);
        Font font = this.fFontSource.fontAt(0);
        if (font == null) {
            font = this.fFontSource.getBestFontAt(0);
        }
        LineMetrics lineMetrics = font.getLineMetrics(this.fChars, 0, 1, this.fFrc);
        this.fBaselineOffsets = lineMetrics.getBaselineOffsets();
    }

    public void insertChar(AttributedCharacterIterator attributedCharacterIterator, int n) {
        this.initSelf(attributedCharacterIterator);
    }
}

