/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.BasicPermissionCollection;
import java.security.Permission;
import java.security.PermissionCollection;

public abstract class BasicPermission
extends Permission
implements Serializable {
    private transient boolean wildcard;
    private transient String path;

    public BasicPermission(String string) {
        super(string);
        this.init(string);
    }

    public BasicPermission(String string, String string2) {
        super(string);
        this.init(string);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        BasicPermission basicPermission = (BasicPermission)object;
        return this.getName().equals(basicPermission.getName());
    }

    public String getActions() {
        return "";
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean implies(Permission permission) {
        if (permission == null || permission.getClass() != this.getClass()) {
            return false;
        }
        BasicPermission basicPermission = (BasicPermission)permission;
        if (this.wildcard) {
            if (basicPermission.wildcard) {
                return basicPermission.path.startsWith(this.path);
            }
            return basicPermission.path.length() > this.path.length() && basicPermission.path.startsWith(this.path);
        }
        if (basicPermission.wildcard) {
            return false;
        }
        return this.path.equals(basicPermission.path);
    }

    private void init(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name can't be null");
        }
        if (string.endsWith(".*") || string.equals("*")) {
            this.wildcard = true;
            this.path = string.length() == 1 ? "" : string.substring(0, string.length() - 1);
        } else {
            this.path = string;
        }
    }

    public PermissionCollection newPermissionCollection() {
        return new BasicPermissionCollection();
    }

    private synchronized void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(this.getName());
    }
}

