/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class Properties
extends Hashtable {
    private static final long serialVersionUID = 4112578634029874840L;
    protected Properties defaults;
    private static final String keyValueSeparators = "=: \t\r\n\f";
    private static final String strictKeyValueSeparators = "=:";
    private static final String specialSaveChars = "=: \t\r\n\f#!";
    private static final String whiteSpaceChars = " \t\r\n\f";
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public Properties() {
        this(null);
    }

    public Properties(Properties properties) {
        this.defaults = properties;
    }

    private boolean continueLine(String string) {
        int n = 0;
        int n2 = string.length() - 1;
        while (n2 >= 0 && string.charAt(n2--) == '\\') {
            ++n;
        }
        return n % 2 == 1;
    }

    private synchronized void enumerate(Hashtable hashtable) {
        if (this.defaults != null) {
            this.defaults.enumerate(hashtable);
        }
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashtable.put(string, this.get(string));
        }
    }

    public String getProperty(String string) {
        Object object = super.get(string);
        String string2 = object instanceof String ? (String)object : null;
        return string2 == null && this.defaults != null ? this.defaults.getProperty(string) : string2;
    }

    public String getProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        return string3 == null ? string2 : string3;
    }

    public void list(PrintStream printStream) {
        printStream.println("-- listing properties --");
        Hashtable hashtable = new Hashtable();
        this.enumerate(hashtable);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            if (string2.length() > 40) {
                string2 = String.valueOf(string2.substring(0, 37)) + "...";
            }
            printStream.println(String.valueOf(string) + "=" + string2);
        }
    }

    public void list(PrintWriter printWriter) {
        printWriter.println("-- listing properties --");
        Hashtable hashtable = new Hashtable();
        this.enumerate(hashtable);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            if (string2.length() > 40) {
                string2 = String.valueOf(string2.substring(0, 37)) + "...";
            }
            printWriter.println(String.valueOf(string) + "=" + string2);
        }
    }

    public synchronized void load(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "8859_1"));
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            int n2;
            char c;
            if (string.length() <= 0 || (c = string.charAt(0)) == '#' || c == '!') continue;
            while (this.continueLine(string)) {
                String string2 = bufferedReader.readLine();
                if (string2 == null) {
                    string2 = new String("");
                }
                String string3 = string.substring(0, string.length() - 1);
                n2 = 0;
                n2 = 0;
                while (n2 < string2.length()) {
                    if (whiteSpaceChars.indexOf(string2.charAt(n2)) == -1) break;
                    ++n2;
                }
                string2 = string2.substring(n2, string2.length());
                string = new String(String.valueOf(string3) + string2);
            }
            int n3 = string.length();
            int n4 = 0;
            while (n4 < n3) {
                if (whiteSpaceChars.indexOf(string.charAt(n4)) == -1) break;
                ++n4;
            }
            n2 = n4;
            while (n2 < n3) {
                n = string.charAt(n2);
                if (n == 92) {
                    ++n2;
                } else if (keyValueSeparators.indexOf(n) != -1) break;
                ++n2;
            }
            n = n2 + 1;
            while (n < n3) {
                if (whiteSpaceChars.indexOf(string.charAt(n)) == -1) break;
                ++n;
            }
            if (n < n3 && strictKeyValueSeparators.indexOf(string.charAt(n)) != -1) {
                ++n;
            }
            while (n < n3) {
                if (whiteSpaceChars.indexOf(string.charAt(n)) == -1) break;
                ++n;
            }
            String string4 = string.substring(n4, n2);
            String string5 = n2 < n3 ? string.substring(n, n3) : "";
            string4 = this.loadConvert(string4);
            string5 = this.loadConvert(string5);
            this.put(string4, string5);
        }
        return;
    }

    private String loadConvert(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            int n3;
            if ((n3 = string.charAt(n2++)) == 92) {
                if ((n3 = string.charAt(n2++)) == 117) {
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < 4) {
                        n3 = string.charAt(n2++);
                        switch (n3) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                n4 = (n4 << 4) + n3 - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                n4 = (n4 << 4) + 10 + n3 - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                n4 = (n4 << 4) + 10 + n3 - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++n5;
                    }
                    stringBuffer.append((char)n4);
                    continue;
                }
                if (n3 == 116) {
                    n3 = 9;
                } else if (n3 == 114) {
                    n3 = 13;
                } else if (n3 == 110) {
                    n3 = 10;
                } else if (n3 == 102) {
                    n3 = 12;
                }
                stringBuffer.append((char)n3);
                continue;
            }
            stringBuffer.append((char)n3);
        }
        return stringBuffer.toString();
    }

    public Enumeration propertyNames() {
        Hashtable hashtable = new Hashtable();
        this.enumerate(hashtable);
        return hashtable.keys();
    }

    public synchronized void save(OutputStream outputStream, String string) {
        try {
            this.store(outputStream, string);
        }
        catch (IOException iOException) {}
    }

    private String saveConvert(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n * 2);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2++);
            switch (c) {
                case '\\': {
                    stringBuffer.append('\\');
                    stringBuffer.append('\\');
                    break;
                }
                case '\t': {
                    stringBuffer.append('\\');
                    stringBuffer.append('t');
                    break;
                }
                case '\n': {
                    stringBuffer.append('\\');
                    stringBuffer.append('n');
                    break;
                }
                case '\r': {
                    stringBuffer.append('\\');
                    stringBuffer.append('r');
                    break;
                }
                case '\f': {
                    stringBuffer.append('\\');
                    stringBuffer.append('f');
                    break;
                }
                default: {
                    if (c < '\u0014' || c > '\u007f') {
                        stringBuffer.append('\\');
                        stringBuffer.append('u');
                        stringBuffer.append(Properties.toHex(c >> 12 & 0xF));
                        stringBuffer.append(Properties.toHex(c >> 8 & 0xF));
                        stringBuffer.append(Properties.toHex(c >> 4 & 0xF));
                        stringBuffer.append(Properties.toHex(c & 0xF));
                        break;
                    }
                    if (specialSaveChars.indexOf(c) != -1) {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }

    public synchronized Object setProperty(String string, String string2) {
        return this.put(string, string2);
    }

    public synchronized void store(OutputStream outputStream, String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "8859_1"));
        if (string != null) {
            Properties.writeln(bufferedWriter, "#" + string);
        }
        Properties.writeln(bufferedWriter, "#" + new Date().toString());
        Enumeration enumeration = this.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)this.get(string2);
            string2 = this.saveConvert(string2);
            string3 = this.saveConvert(string3);
            Properties.writeln(bufferedWriter, String.valueOf(string2) + "=" + string3);
        }
        bufferedWriter.flush();
    }

    private static char toHex(int n) {
        return hexDigit[n & 0xF];
    }

    private static void writeln(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write(string);
        bufferedWriter.newLine();
    }
}

