/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class JTree
extends JComponent
implements Scrollable,
Accessible {
    private static final String uiClassID = "TreeUI";
    protected transient TreeModel treeModel;
    protected transient TreeSelectionModel selectionModel;
    protected boolean rootVisible;
    protected transient TreeCellRenderer cellRenderer;
    protected int rowHeight;
    private transient Hashtable expandedState;
    protected boolean showsRootHandles;
    protected transient TreeSelectionRedirector selectionRedirector;
    protected transient TreeCellEditor cellEditor;
    protected boolean editable;
    protected boolean largeModel;
    protected int visibleRowCount;
    protected boolean invokesStopCellEditing;
    protected boolean scrollsOnExpand;
    protected int toggleClickCount = 2;
    protected transient TreeModelListener treeModelListener;
    private transient Stack expandedStack = new Stack();
    private static int TEMP_STACK_SIZE = 11;
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    public static final String TREE_MODEL_PROPERTY = "treeModel";
    public static final String ROOT_VISIBLE_PROPERTY = "rootVisible";
    public static final String SHOWS_ROOT_HANDLES_PROPERTY = "showsRootHandles";
    public static final String ROW_HEIGHT_PROPERTY = "rowHeight";
    public static final String CELL_EDITOR_PROPERTY = "cellEditor";
    public static final String EDITABLE_PROPERTY = "editable";
    public static final String LARGE_MODEL_PROPERTY = "largeModel";
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String VISIBLE_ROW_COUNT_PROPERTY = "visibleRowCount";
    public static final String INVOKES_STOP_CELL_EDITING_PROPERTY = "messagesStopCellEditing";
    public static final String SCROLLS_ON_EXPAND_PROPERTY = "scrollsOnExpand";
    static /* synthetic */ Class class$javax$swing$event$TreeExpansionListener;
    static /* synthetic */ Class class$javax$swing$event$TreeWillExpandListener;
    static /* synthetic */ Class class$javax$swing$event$TreeSelectionListener;

    public JTree() {
        this(JTree.getDefaultTreeModel());
    }

    public JTree(Hashtable hashtable) {
        this(JTree.createTreeModel(hashtable));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    public JTree(Vector vector) {
        this(JTree.createTreeModel(vector));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    public JTree(TreeModel treeModel) {
        this.expandedState = new Hashtable();
        this.setLayout(null);
        this.rowHeight = 16;
        this.visibleRowCount = 20;
        this.rootVisible = true;
        this.selectionModel = new DefaultTreeSelectionModel();
        this.cellRenderer = null;
        this.scrollsOnExpand = true;
        this.setOpaque(true);
        this.updateUI();
        this.setModel(treeModel);
    }

    public JTree(TreeNode treeNode) {
        this(treeNode, false);
    }

    public JTree(TreeNode treeNode, boolean bl) {
        this(new DefaultTreeModel(treeNode, bl));
    }

    public JTree(Object[] objectArray) {
        this(JTree.createTreeModel(objectArray));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
    }

    public void addSelectionInterval(int n, int n2) {
        TreePath[] treePathArray = this.getPathBetweenRows(n, n2);
        this.getSelectionModel().addSelectionPaths(treePathArray);
    }

    public void addSelectionPath(TreePath treePath) {
        this.makeVisible(treePath);
        this.getSelectionModel().addSelectionPath(treePath);
    }

    public void addSelectionPaths(TreePath[] treePathArray) {
        if (treePathArray != null) {
            int n = treePathArray.length - 1;
            while (n >= 0) {
                this.makeVisible(treePathArray[n]);
                --n;
            }
        }
        this.getSelectionModel().addSelectionPaths(treePathArray);
    }

    public void addSelectionRow(int n) {
        int[] nArray = new int[]{n};
        this.addSelectionRows(nArray);
    }

    public void addSelectionRows(int[] nArray) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null && nArray != null) {
            int n = nArray.length;
            TreePath[] treePathArray = new TreePath[n];
            int n2 = 0;
            while (n2 < n) {
                treePathArray[n2] = treeUI.getPathForRow(this, nArray[n2]);
                ++n2;
            }
            this.addSelectionPaths(treePathArray);
        }
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.listenerList.add(class$javax$swing$event$TreeExpansionListener != null ? class$javax$swing$event$TreeExpansionListener : (class$javax$swing$event$TreeExpansionListener = JTree.class$("javax.swing.event.TreeExpansionListener")), treeExpansionListener);
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.add(class$javax$swing$event$TreeSelectionListener != null ? class$javax$swing$event$TreeSelectionListener : (class$javax$swing$event$TreeSelectionListener = JTree.class$("javax.swing.event.TreeSelectionListener")), treeSelectionListener);
        if (this.listenerList.getListenerCount(class$javax$swing$event$TreeSelectionListener != null ? class$javax$swing$event$TreeSelectionListener : (class$javax$swing$event$TreeSelectionListener = JTree.class$("javax.swing.event.TreeSelectionListener"))) != 0 && this.selectionRedirector == null) {
            this.selectionRedirector = new TreeSelectionRedirector();
            this.selectionModel.addTreeSelectionListener(this.selectionRedirector);
        }
    }

    public void addTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.listenerList.add(class$javax$swing$event$TreeWillExpandListener != null ? class$javax$swing$event$TreeWillExpandListener : (class$javax$swing$event$TreeWillExpandListener = JTree.class$("javax.swing.event.TreeWillExpandListener")), treeWillExpandListener);
    }

    public void cancelEditing() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            treeUI.cancelEditing(this);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    protected void clearToggledPaths() {
        this.expandedState.clear();
    }

    public void collapsePath(TreePath treePath) {
        this.setExpandedState(treePath, false);
    }

    public void collapseRow(int n) {
        this.collapsePath(this.getPathForRow(n));
    }

    public String convertValueToText(Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }

    protected static TreeModel createTreeModel(Object object) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (object instanceof Object[] || object instanceof Hashtable || object instanceof Vector) {
            defaultMutableTreeNode = new DefaultMutableTreeNode("root");
            DynamicUtilTreeNode.createChildren(defaultMutableTreeNode, object);
        } else {
            defaultMutableTreeNode = new DynamicUtilTreeNode((Object)"root", object);
        }
        return new DefaultTreeModel(defaultMutableTreeNode, false);
    }

    protected TreeModelListener createTreeModelListener() {
        return new TreeModelHandler();
    }

    public void expandPath(TreePath treePath) {
        TreeModel treeModel = this.getModel();
        if (treePath != null && treeModel != null && !treeModel.isLeaf(treePath.getLastPathComponent())) {
            this.setExpandedState(treePath, true);
        }
    }

    public void expandRow(int n) {
        this.expandPath(this.getPathForRow(n));
    }

    public void fireTreeCollapsed(TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$TreeExpansionListener != null ? class$javax$swing$event$TreeExpansionListener : JTree.class$("javax.swing.event.TreeExpansionListener"))) {
                if (treeExpansionEvent == null) {
                    treeExpansionEvent = new TreeExpansionEvent(this, treePath);
                }
                ((TreeExpansionListener)objectArray[n + 1]).treeCollapsed(treeExpansionEvent);
            }
            n -= 2;
        }
    }

    public void fireTreeExpanded(TreePath treePath) {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$TreeExpansionListener != null ? class$javax$swing$event$TreeExpansionListener : JTree.class$("javax.swing.event.TreeExpansionListener"))) {
                if (treeExpansionEvent == null) {
                    treeExpansionEvent = new TreeExpansionEvent(this, treePath);
                }
                ((TreeExpansionListener)objectArray[n + 1]).treeExpanded(treeExpansionEvent);
            }
            n -= 2;
        }
    }

    public void fireTreeWillCollapse(TreePath treePath) throws ExpandVetoException {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$TreeWillExpandListener != null ? class$javax$swing$event$TreeWillExpandListener : JTree.class$("javax.swing.event.TreeWillExpandListener"))) {
                if (treeExpansionEvent == null) {
                    treeExpansionEvent = new TreeExpansionEvent(this, treePath);
                }
                ((TreeWillExpandListener)objectArray[n + 1]).treeWillCollapse(treeExpansionEvent);
            }
            n -= 2;
        }
    }

    public void fireTreeWillExpand(TreePath treePath) throws ExpandVetoException {
        Object[] objectArray = this.listenerList.getListenerList();
        TreeExpansionEvent treeExpansionEvent = null;
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$TreeWillExpandListener != null ? class$javax$swing$event$TreeWillExpandListener : JTree.class$("javax.swing.event.TreeWillExpandListener"))) {
                if (treeExpansionEvent == null) {
                    treeExpansionEvent = new TreeExpansionEvent(this, treePath);
                }
                ((TreeWillExpandListener)objectArray[n + 1]).treeWillExpand(treeExpansionEvent);
            }
            n -= 2;
        }
    }

    protected void fireValueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$javax$swing$event$TreeSelectionListener != null ? class$javax$swing$event$TreeSelectionListener : JTree.class$("javax.swing.event.TreeSelectionListener"))) {
                ((TreeSelectionListener)objectArray[n + 1]).valueChanged(treeSelectionEvent);
            }
            n -= 2;
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTree();
        }
        return this.accessibleContext;
    }

    private Object getArchivableExpandedState() {
        Enumeration enumeration;
        TreeModel treeModel = this.getModel();
        if (treeModel != null && (enumeration = this.expandedState.keys()) != null) {
            Vector vector = new Vector();
            while (enumeration.hasMoreElements()) {
                int[] nArray;
                TreePath treePath = (TreePath)enumeration.nextElement();
                try {
                    nArray = this.getModelIndexsForPath(treePath);
                }
                catch (Error error) {
                    nArray = null;
                }
                if (nArray == null) continue;
                vector.addElement(nArray);
                vector.addElement(this.expandedState.get(treePath));
            }
            return vector;
        }
        return null;
    }

    public TreeCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public TreeCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public TreePath getClosestPathForLocation(int n, int n2) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getClosestPathForLocation(this, n, n2);
        }
        return null;
    }

    public int getClosestRowForLocation(int n, int n2) {
        return this.getRowForPath(this.getClosestPathForLocation(n, n2));
    }

    protected static TreeModel getDefaultTreeModel() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("JTree");
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("colors");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("blue"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("violet"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("red"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("yellow"));
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("sports");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("basketball"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("soccer"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("football"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("hockey"));
        defaultMutableTreeNode2 = new DefaultMutableTreeNode("food");
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("hot dogs"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("pizza"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("ravioli"));
        defaultMutableTreeNode2.add(new DefaultMutableTreeNode("bananas"));
        return new DefaultTreeModel(defaultMutableTreeNode);
    }

    protected Enumeration getDescendantToggledPaths(TreePath treePath) {
        if (treePath == null) {
            return null;
        }
        Vector vector = new Vector();
        Enumeration enumeration = this.expandedState.keys();
        while (enumeration.hasMoreElements()) {
            TreePath treePath2 = (TreePath)enumeration.nextElement();
            if (!treePath.isDescendant(treePath2)) continue;
            vector.addElement(treePath2);
        }
        return vector.elements();
    }

    public TreePath getEditingPath() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getEditingPath(this);
        }
        return null;
    }

    public Enumeration getExpandedDescendants(TreePath treePath) {
        if (!this.isExpanded(treePath)) {
            return null;
        }
        Enumeration enumeration = this.expandedState.keys();
        Vector vector = new Vector();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                TreePath treePath2 = (TreePath)enumeration.nextElement();
                Object object = this.expandedState.get(treePath2);
                if (object == null || !((Boolean)object).booleanValue() || !treePath.isDescendant(treePath2) || !this.isVisible(treePath2)) continue;
                vector.addElement(treePath2);
            }
        }
        return vector.elements();
    }

    public boolean getInvokesStopCellEditing() {
        return this.invokesStopCellEditing;
    }

    public Object getLastSelectedPathComponent() {
        TreePath treePath = this.getSelectionModel().getSelectionPath();
        if (treePath != null) {
            return treePath.getLastPathComponent();
        }
        return null;
    }

    public TreePath getLeadSelectionPath() {
        return this.getSelectionModel().getLeadSelectionPath();
    }

    public int getLeadSelectionRow() {
        return this.getSelectionModel().getLeadSelectionRow();
    }

    public int getMaxSelectionRow() {
        return this.getSelectionModel().getMaxSelectionRow();
    }

    public int getMinSelectionRow() {
        return this.getSelectionModel().getMinSelectionRow();
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    private int[] getModelIndexsForPath(TreePath treePath) {
        if (treePath != null) {
            TreeModel treeModel = this.getModel();
            int n = treePath.getPathCount();
            int[] nArray = new int[n - 1];
            Object object = treeModel.getRoot();
            int n2 = 1;
            while (n2 < n) {
                nArray[n2 - 1] = treeModel.getIndexOfChild(object, treePath.getPathComponent(n2));
                object = treePath.getPathComponent(n2);
                if (nArray[n2 - 1] < 0) {
                    return null;
                }
                ++n2;
            }
            return nArray;
        }
        return null;
    }

    protected TreePath[] getPathBetweenRows(int n, int n2) {
        TreeUI treeUI = this.getUI();
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        if (treeUI != null) {
            TreePath[] treePathArray = new TreePath[n4 - n3 + 1];
            int n5 = n3;
            while (n5 <= n4) {
                treePathArray[n5 - n3] = treeUI.getPathForRow(this, n5);
                ++n5;
            }
            return treePathArray;
        }
        return null;
    }

    public Rectangle getPathBounds(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getPathBounds(this, treePath);
        }
        return null;
    }

    private TreePath getPathForIndexs(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        TreeModel treeModel = this.getModel();
        if (treeModel == null) {
            return null;
        }
        int n = nArray.length;
        Object object = treeModel.getRoot();
        TreePath treePath = new TreePath(object);
        int n2 = 0;
        while (n2 < n) {
            if ((object = treeModel.getChild(object, nArray[n2])) == null) {
                return null;
            }
            treePath = treePath.pathByAddingChild(object);
            ++n2;
        }
        return treePath;
    }

    public TreePath getPathForLocation(int n, int n2) {
        TreePath treePath = this.getClosestPathForLocation(n, n2);
        if (treePath != null) {
            Rectangle rectangle = this.getPathBounds(treePath);
            if (n >= rectangle.x && n < rectangle.x + rectangle.width && n2 >= rectangle.y && n2 < rectangle.y + rectangle.height) {
                return treePath;
            }
        }
        return null;
    }

    public TreePath getPathForRow(int n) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getPathForRow(this, n);
        }
        return null;
    }

    public Dimension getPreferredScrollableViewportSize() {
        TreeUI treeUI;
        int n = this.getPreferredSize().width;
        int n2 = this.getVisibleRowCount();
        int n3 = this.isFixedRowHeight() ? n2 * this.getRowHeight() : ((treeUI = this.getUI()) != null && treeUI.getRowCount(this) > 0 ? this.getRowBounds((int)0).height * n2 : 16 * n2);
        return new Dimension(n, n3);
    }

    public Rectangle getRowBounds(int n) {
        TreePath treePath = this.getPathForRow(n);
        return this.getPathBounds(this.getPathForRow(n));
    }

    public int getRowCount() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getRowCount(this);
        }
        return 0;
    }

    public int getRowForLocation(int n, int n2) {
        return this.getRowForPath(this.getPathForLocation(n, n2));
    }

    public int getRowForPath(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.getRowForPath(this, treePath);
        }
        return -1;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return n == 1 ? rectangle.height : rectangle.width;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 1) {
            int n3 = this.getClosestRowForLocation(0, rectangle.y);
            if (n3 != -1) {
                Rectangle rectangle2 = this.getRowBounds(n3);
                if (rectangle2.y != rectangle.y) {
                    if (n2 < 0) {
                        return rectangle.y - rectangle2.y;
                    }
                    return rectangle2.y + rectangle2.height - rectangle.y;
                }
                if (n2 < 0) {
                    if (n3 != 0) {
                        rectangle2 = this.getRowBounds(n3 - 1);
                        return rectangle2.height;
                    }
                } else {
                    return rectangle2.height;
                }
            }
            return 0;
        }
        return 4;
    }

    public boolean getScrollsOnExpand() {
        return this.scrollsOnExpand;
    }

    public int getSelectionCount() {
        return this.selectionModel.getSelectionCount();
    }

    public TreeSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public TreePath getSelectionPath() {
        return this.getSelectionModel().getSelectionPath();
    }

    public TreePath[] getSelectionPaths() {
        return this.getSelectionModel().getSelectionPaths();
    }

    public int[] getSelectionRows() {
        return this.getSelectionModel().getSelectionRows();
    }

    public boolean getShowsRootHandles() {
        return this.showsRootHandles;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            TreePath treePath;
            Object object;
            Component component;
            Point point = mouseEvent.getPoint();
            int n = this.getRowForLocation(point.x, point.y);
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (n != -1 && treeCellRenderer != null && (component = treeCellRenderer.getTreeCellRendererComponent(this, object = (treePath = this.getPathForRow(n)).getLastPathComponent(), this.isRowSelected(n), this.isExpanded(n), this.getModel().isLeaf(object), n, true)) instanceof JComponent) {
                Rectangle rectangle = this.getPathBounds(treePath);
                point.translate(-rectangle.x, -rectangle.y);
                MouseEvent mouseEvent2 = new MouseEvent(component, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), point.x, point.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                return ((JComponent)component).getToolTipText(mouseEvent2);
            }
        }
        return null;
    }

    public TreeUI getUI() {
        return (TreeUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public boolean hasBeenExpanded(TreePath treePath) {
        return treePath != null && this.expandedState.get(treePath) != null;
    }

    public boolean isCollapsed(int n) {
        return this.isExpanded(n) ^ true;
    }

    public boolean isCollapsed(TreePath treePath) {
        return this.isExpanded(treePath) ^ true;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isEditing() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.isEditing(this);
        }
        return false;
    }

    public boolean isExpanded(int n) {
        TreePath treePath;
        TreeUI treeUI = this.getUI();
        if (treeUI != null && (treePath = treeUI.getPathForRow(this, n)) != null) {
            return this.isExpanded(treePath);
        }
        return false;
    }

    public boolean isExpanded(TreePath treePath) {
        if (treePath == null) {
            return false;
        }
        Object object = this.expandedState.get(treePath);
        if (object == null || !((Boolean)object).booleanValue()) {
            return false;
        }
        TreePath treePath2 = treePath.getParentPath();
        if (treePath2 != null) {
            return this.isExpanded(treePath2);
        }
        return true;
    }

    public boolean isFixedRowHeight() {
        return this.rowHeight > 0;
    }

    public boolean isLargeModel() {
        return this.largeModel;
    }

    public boolean isPathEditable(TreePath treePath) {
        return this.isEditable();
    }

    public boolean isPathSelected(TreePath treePath) {
        return this.getSelectionModel().isPathSelected(treePath);
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public boolean isRowSelected(int n) {
        return this.getSelectionModel().isRowSelected(n);
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public boolean isVisible(TreePath treePath) {
        if (treePath != null) {
            TreePath treePath2 = treePath.getParentPath();
            if (treePath2 != null) {
                return this.isExpanded(treePath2);
            }
            return true;
        }
        return false;
    }

    public void makeVisible(TreePath treePath) {
        TreePath treePath2;
        if (treePath != null && (treePath2 = treePath.getParentPath()) != null) {
            this.expandPath(treePath2);
        }
    }

    protected String paramString() {
        String string = this.rootVisible ? "true" : "false";
        String string2 = this.showsRootHandles ? "true" : "false";
        String string3 = this.editable ? "true" : "false";
        String string4 = this.largeModel ? "true" : "false";
        String string5 = this.invokesStopCellEditing ? "true" : "false";
        String string6 = this.scrollsOnExpand ? "true" : "false";
        return String.valueOf(super.paramString()) + ",editable=" + string3 + ",invokesStopCellEditing=" + string5 + ",largeModel=" + string4 + ",rootVisible=" + string + ",rowHeight=" + this.rowHeight + ",scrollsOnExpand=" + string6 + ",showsRootHandles=" + string2 + ",toggleClickCount=" + this.toggleClickCount + ",visibleRowCount=" + this.visibleRowCount;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.expandedState = new Hashtable();
        this.expandedStack = new Stack();
        Vector vector = (Vector)objectInputStream.readObject();
        int n = 0;
        int n2 = vector.size();
        if (n < n2 && vector.elementAt(n).equals(CELL_RENDERER_PROPERTY)) {
            this.cellRenderer = (TreeCellRenderer)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals(CELL_EDITOR_PROPERTY)) {
            this.cellEditor = (TreeCellEditor)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals(TREE_MODEL_PROPERTY)) {
            this.treeModel = (TreeModel)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals(SELECTION_MODEL_PROPERTY)) {
            this.selectionModel = (TreeSelectionModel)vector.elementAt(++n);
            ++n;
        }
        if (n < n2 && vector.elementAt(n).equals("expandedState")) {
            this.unarchiveExpandedState(vector.elementAt(++n));
            ++n;
        }
        if (this.listenerList.getListenerCount(class$javax$swing$event$TreeSelectionListener != null ? class$javax$swing$event$TreeSelectionListener : (class$javax$swing$event$TreeSelectionListener = JTree.class$("javax.swing.event.TreeSelectionListener"))) != 0) {
            this.selectionRedirector = new TreeSelectionRedirector();
            this.selectionModel.addTreeSelectionListener(this.selectionRedirector);
        }
        if (this.treeModel != null) {
            this.treeModelListener = this.createTreeModelListener();
            if (this.treeModelListener != null) {
                this.treeModel.addTreeModelListener(this.treeModelListener);
            }
        }
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
    }

    protected void removeDescendantToggledPaths(Enumeration enumeration) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Enumeration enumeration2 = this.getDescendantToggledPaths((TreePath)enumeration.nextElement());
                if (enumeration2 == null) continue;
                while (enumeration2.hasMoreElements()) {
                    this.expandedState.remove(enumeration2.nextElement());
                }
            }
        }
    }

    public void removeSelectionInterval(int n, int n2) {
        TreePath[] treePathArray = this.getPathBetweenRows(n, n2);
        this.getSelectionModel().removeSelectionPaths(treePathArray);
    }

    public void removeSelectionPath(TreePath treePath) {
        this.getSelectionModel().removeSelectionPath(treePath);
    }

    public void removeSelectionPaths(TreePath[] treePathArray) {
        this.getSelectionModel().removeSelectionPaths(treePathArray);
    }

    public void removeSelectionRow(int n) {
        int[] nArray = new int[]{n};
        this.removeSelectionRows(nArray);
    }

    public void removeSelectionRows(int[] nArray) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null && nArray != null) {
            int n = nArray.length;
            TreePath[] treePathArray = new TreePath[n];
            int n2 = 0;
            while (n2 < n) {
                treePathArray[n2] = treeUI.getPathForRow(this, nArray[n2]);
                ++n2;
            }
            this.removeSelectionPaths(treePathArray);
        }
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.listenerList.remove(class$javax$swing$event$TreeExpansionListener != null ? class$javax$swing$event$TreeExpansionListener : (class$javax$swing$event$TreeExpansionListener = JTree.class$("javax.swing.event.TreeExpansionListener")), treeExpansionListener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.listenerList.remove(class$javax$swing$event$TreeSelectionListener != null ? class$javax$swing$event$TreeSelectionListener : (class$javax$swing$event$TreeSelectionListener = JTree.class$("javax.swing.event.TreeSelectionListener")), treeSelectionListener);
        if (this.listenerList.getListenerCount(class$javax$swing$event$TreeSelectionListener != null ? class$javax$swing$event$TreeSelectionListener : (class$javax$swing$event$TreeSelectionListener = JTree.class$("javax.swing.event.TreeSelectionListener"))) == 0 && this.selectionRedirector != null) {
            this.selectionModel.removeTreeSelectionListener(this.selectionRedirector);
            this.selectionRedirector = null;
        }
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.listenerList.remove(class$javax$swing$event$TreeWillExpandListener != null ? class$javax$swing$event$TreeWillExpandListener : (class$javax$swing$event$TreeWillExpandListener = JTree.class$("javax.swing.event.TreeWillExpandListener")), treeWillExpandListener);
    }

    public void scrollPathToVisible(TreePath treePath) {
        if (treePath != null) {
            this.makeVisible(treePath);
            Rectangle rectangle = this.getPathBounds(treePath);
            if (rectangle != null) {
                this.scrollRectToVisible(rectangle);
                if (this.accessibleContext != null) {
                    ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                }
            }
        }
    }

    public void scrollRowToVisible(int n) {
        this.scrollPathToVisible(this.getPathForRow(n));
    }

    public void setCellEditor(TreeCellEditor treeCellEditor) {
        TreeCellEditor treeCellEditor2 = this.cellEditor;
        this.cellEditor = treeCellEditor;
        this.firePropertyChange(CELL_EDITOR_PROPERTY, treeCellEditor2, treeCellEditor);
        this.invalidate();
    }

    public void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        TreeCellRenderer treeCellRenderer2 = this.cellRenderer;
        this.cellRenderer = treeCellRenderer;
        this.firePropertyChange(CELL_RENDERER_PROPERTY, treeCellRenderer2, this.cellRenderer);
        this.invalidate();
    }

    public void setEditable(boolean bl) {
        boolean bl2 = this.editable;
        this.editable = bl;
        this.firePropertyChange(EDITABLE_PROPERTY, bl2, bl);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleState", bl2 ? AccessibleState.EDITABLE : null, bl ? AccessibleState.EDITABLE : null);
        }
    }

    protected void setExpandedState(TreePath treePath, boolean bl) {
        if (treePath != null) {
            TreePath treePath2 = treePath.getParentPath();
            Stack stack = this.expandedStack.size() == 0 ? new Stack() : (Stack)this.expandedStack.pop();
            try {
                while (treePath2 != null) {
                    if (this.isExpanded(treePath2)) {
                        treePath2 = null;
                        continue;
                    }
                    stack.push(treePath2);
                    treePath2 = treePath2.getParentPath();
                }
                int n = stack.size() - 1;
                while (n >= 0) {
                    treePath2 = (TreePath)stack.pop();
                    if (!this.isExpanded(treePath2)) {
                        try {
                            this.fireTreeWillExpand(treePath2);
                        }
                        catch (ExpandVetoException expandVetoException) {
                            Object var6_6 = null;
                            if (this.expandedStack.size() < TEMP_STACK_SIZE) {
                                stack.removeAllElements();
                                this.expandedStack.push(stack);
                            }
                            return;
                        }
                        this.expandedState.put(treePath2, Boolean.TRUE);
                        this.fireTreeExpanded(treePath2);
                        if (this.accessibleContext != null) {
                            ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                        }
                    }
                    --n;
                }
            }
            finally {
                Object var6_7 = null;
                if (this.expandedStack.size() < TEMP_STACK_SIZE) {
                    stack.removeAllElements();
                    this.expandedStack.push(stack);
                }
            }
            if (!bl) {
                Object object = this.expandedState.get(treePath);
                if (object != null && ((Boolean)object).booleanValue()) {
                    try {
                        this.fireTreeWillCollapse(treePath);
                    }
                    catch (ExpandVetoException expandVetoException) {
                        return;
                    }
                    this.expandedState.put(treePath, Boolean.FALSE);
                    this.fireTreeCollapsed(treePath);
                    if (this.accessibleContext != null) {
                        ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                    }
                }
            } else {
                Object object = this.expandedState.get(treePath);
                if (object == null || !((Boolean)object).booleanValue()) {
                    try {
                        this.fireTreeWillExpand(treePath);
                    }
                    catch (ExpandVetoException expandVetoException) {
                        return;
                    }
                    this.expandedState.put(treePath, Boolean.TRUE);
                    this.fireTreeExpanded(treePath);
                    if (this.accessibleContext != null) {
                        ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
                    }
                }
            }
        }
    }

    public void setInvokesStopCellEditing(boolean bl) {
        boolean bl2 = this.invokesStopCellEditing;
        this.invokesStopCellEditing = bl;
        this.firePropertyChange(INVOKES_STOP_CELL_EDITING_PROPERTY, bl2, bl);
    }

    public void setLargeModel(boolean bl) {
        boolean bl2 = this.largeModel;
        this.largeModel = bl;
        this.firePropertyChange(LARGE_MODEL_PROPERTY, bl2, bl);
    }

    public void setModel(TreeModel treeModel) {
        TreeModel treeModel2 = this.treeModel;
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
        if (this.accessibleContext != null) {
            if (this.treeModel != null) {
                this.treeModel.removeTreeModelListener((TreeModelListener)((Object)this.accessibleContext));
            }
            if (treeModel != null) {
                treeModel.addTreeModelListener((TreeModelListener)((Object)this.accessibleContext));
            }
        }
        this.treeModel = treeModel;
        this.clearToggledPaths();
        if (this.treeModel != null) {
            if (this.treeModelListener == null) {
                this.treeModelListener = this.createTreeModelListener();
            }
            if (this.treeModelListener != null) {
                this.treeModel.addTreeModelListener(this.treeModelListener);
            }
            if (!this.treeModel.isLeaf(this.treeModel.getRoot())) {
                this.expandedState.put(new TreePath(this.treeModel.getRoot()), Boolean.TRUE);
            }
        }
        this.firePropertyChange(TREE_MODEL_PROPERTY, treeModel2, this.treeModel);
        this.invalidate();
    }

    public void setRootVisible(boolean bl) {
        boolean bl2 = this.rootVisible;
        this.rootVisible = bl;
        this.firePropertyChange(ROOT_VISIBLE_PROPERTY, bl2, this.rootVisible);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
        }
    }

    public void setRowHeight(int n) {
        int n2 = this.rowHeight;
        this.rowHeight = n;
        this.firePropertyChange(ROW_HEIGHT_PROPERTY, n2, this.rowHeight);
        this.invalidate();
    }

    public void setScrollsOnExpand(boolean bl) {
        boolean bl2 = this.scrollsOnExpand;
        this.scrollsOnExpand = bl;
        this.firePropertyChange(SCROLLS_ON_EXPAND_PROPERTY, bl2, bl);
    }

    public void setSelectionInterval(int n, int n2) {
        TreePath[] treePathArray = this.getPathBetweenRows(n, n2);
        this.getSelectionModel().setSelectionPaths(treePathArray);
    }

    public void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        if (treeSelectionModel == null) {
            treeSelectionModel = EmptySelectionModel.sharedInstance();
        }
        TreeSelectionModel treeSelectionModel2 = this.selectionModel;
        if (this.accessibleContext != null) {
            this.selectionModel.removeTreeSelectionListener((TreeSelectionListener)((Object)this.accessibleContext));
            treeSelectionModel.addTreeSelectionListener((TreeSelectionListener)((Object)this.accessibleContext));
        }
        this.selectionModel = treeSelectionModel;
        this.firePropertyChange(SELECTION_MODEL_PROPERTY, treeSelectionModel2, this.selectionModel);
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleSelection", new Boolean(false), new Boolean(true));
        }
    }

    public void setSelectionPath(TreePath treePath) {
        this.makeVisible(treePath);
        this.getSelectionModel().setSelectionPath(treePath);
    }

    public void setSelectionPaths(TreePath[] treePathArray) {
        if (treePathArray != null) {
            int n = treePathArray.length - 1;
            while (n >= 0) {
                this.makeVisible(treePathArray[n]);
                --n;
            }
        }
        this.getSelectionModel().setSelectionPaths(treePathArray);
    }

    public void setSelectionRow(int n) {
        int[] nArray = new int[]{n};
        this.setSelectionRows(nArray);
    }

    public void setSelectionRows(int[] nArray) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null && nArray != null) {
            int n = nArray.length;
            TreePath[] treePathArray = new TreePath[n];
            int n2 = 0;
            while (n2 < n) {
                treePathArray[n2] = treeUI.getPathForRow(this, nArray[n2]);
                ++n2;
            }
            this.setSelectionPaths(treePathArray);
        }
    }

    public void setShowsRootHandles(boolean bl) {
        boolean bl2 = this.showsRootHandles;
        TreeModel treeModel = this.getModel();
        this.showsRootHandles = bl;
        this.firePropertyChange(SHOWS_ROOT_HANDLES_PROPERTY, bl2, this.showsRootHandles);
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
        }
        if (treeModel != null) {
            this.expandPath(new TreePath(treeModel.getRoot()));
        }
        this.invalidate();
    }

    public void setUI(TreeUI treeUI) {
        if ((TreeUI)this.ui != treeUI) {
            super.setUI(treeUI);
            this.repaint();
        }
    }

    public void setVisibleRowCount(int n) {
        int n2 = this.visibleRowCount;
        this.visibleRowCount = n;
        this.firePropertyChange(VISIBLE_ROW_COUNT_PROPERTY, n2, this.visibleRowCount);
        this.invalidate();
        if (this.accessibleContext != null) {
            ((AccessibleJTree)this.accessibleContext).fireVisibleDataPropertyChange();
        }
    }

    public void startEditingAtPath(TreePath treePath) {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            treeUI.startEditingAtPath(this, treePath);
        }
    }

    public boolean stopEditing() {
        TreeUI treeUI = this.getUI();
        if (treeUI != null) {
            return treeUI.stopEditing(this);
        }
        return false;
    }

    public void treeDidChange() {
        this.revalidate();
        this.repaint();
    }

    private void unarchiveExpandedState(Object object) {
        if (object instanceof Vector) {
            Vector vector = (Vector)object;
            int n = vector.size() - 1;
            while (n >= 0) {
                Boolean bl = (Boolean)vector.elementAt(n--);
                try {
                    TreePath treePath = this.getPathForIndexs((int[])vector.elementAt(n));
                    if (treePath != null) {
                        this.expandedState.put(treePath, bl);
                    }
                }
                catch (Error error) {}
                --n;
            }
        }
    }

    public void updateUI() {
        this.setUI((TreeUI)UIManager.getUI(this));
        this.invalidate();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Object object;
        Vector vector = new Vector();
        objectOutputStream.defaultWriteObject();
        if (this.cellRenderer != null && this.cellRenderer instanceof Serializable) {
            vector.addElement(CELL_RENDERER_PROPERTY);
            vector.addElement(this.cellRenderer);
        }
        if (this.cellEditor != null && this.cellEditor instanceof Serializable) {
            vector.addElement(CELL_EDITOR_PROPERTY);
            vector.addElement(this.cellEditor);
        }
        if (this.treeModel != null && this.treeModel instanceof Serializable) {
            vector.addElement(TREE_MODEL_PROPERTY);
            vector.addElement(this.treeModel);
        }
        if (this.selectionModel != null && this.selectionModel instanceof Serializable) {
            vector.addElement(SELECTION_MODEL_PROPERTY);
            vector.addElement(this.selectionModel);
        }
        if ((object = this.getArchivableExpandedState()) != null) {
            vector.addElement("expandedState");
            vector.addElement(object);
        }
        objectOutputStream.writeObject(vector);
    }

    protected static class EmptySelectionModel
    extends DefaultTreeSelectionModel {
        protected static final EmptySelectionModel sharedInstance = new EmptySelectionModel();

        protected EmptySelectionModel() {
        }

        public void addSelectionPaths(TreePath[] treePathArray) {
        }

        public void removeSelectionPaths(TreePath[] treePathArray) {
        }

        public void setSelectionPaths(TreePath[] treePathArray) {
        }

        public static EmptySelectionModel sharedInstance() {
            return sharedInstance;
        }
    }

    protected class TreeSelectionRedirector
    implements Serializable,
    TreeSelectionListener {
        protected TreeSelectionRedirector() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreeSelectionEvent treeSelectionEvent2 = (TreeSelectionEvent)treeSelectionEvent.cloneWithSource(JTree.this);
            JTree.this.fireValueChanged(treeSelectionEvent2);
        }
    }

    protected class TreeModelHandler
    implements TreeModelListener {
        protected TreeModelHandler() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            TreeModel treeModel;
            if (treeModelEvent == null) {
                return;
            }
            TreePath treePath = treeModelEvent.getTreePath();
            Object[] objectArray = treeModelEvent.getChildren();
            if (objectArray == null) {
                return;
            }
            Vector vector = new Vector(Math.max(1, objectArray.length));
            int n = objectArray.length - 1;
            while (n >= 0) {
                TreePath treePath2 = treePath.pathByAddingChild(objectArray[n]);
                if (JTree.this.expandedState.get(treePath2) != null) {
                    vector.addElement(treePath2);
                }
                --n;
            }
            if (vector.size() > 0) {
                JTree.this.removeDescendantToggledPaths(vector.elements());
            }
            if ((treeModel = JTree.this.getModel()) == null || treeModel.isLeaf(treePath.getLastPathComponent())) {
                JTree.this.expandedState.remove(treePath);
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            if (treeModelEvent == null) {
                return;
            }
            TreePath treePath = treeModelEvent.getTreePath();
            if (treePath == null) {
                return;
            }
            if (JTree.this.expandedState.get(treePath) != null) {
                Vector vector = new Vector(1);
                boolean bl = JTree.this.isExpanded(treePath);
                vector.addElement(treePath);
                JTree.this.removeDescendantToggledPaths(vector.elements());
                if (bl) {
                    TreeModel treeModel = JTree.this.getModel();
                    if (treeModel == null || treeModel.isLeaf(treePath.getLastPathComponent())) {
                        JTree.this.collapsePath(treePath);
                    } else {
                        JTree.this.expandedState.put(treePath, Boolean.TRUE);
                    }
                }
            }
        }
    }

    public static class DynamicUtilTreeNode
    extends DefaultMutableTreeNode {
        protected boolean hasChildren;
        protected Object childValue;
        protected boolean loadedChildren = false;

        public DynamicUtilTreeNode(Object object, Object object2) {
            super(object);
            this.childValue = object2;
            if (object2 != null) {
                if (object2 instanceof Vector) {
                    this.setAllowsChildren(true);
                } else if (object2 instanceof Hashtable) {
                    this.setAllowsChildren(true);
                } else if (object2 instanceof Object[]) {
                    this.setAllowsChildren(true);
                } else {
                    this.setAllowsChildren(false);
                }
            } else {
                this.setAllowsChildren(false);
            }
        }

        public Enumeration children() {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.children();
        }

        public static void createChildren(DefaultMutableTreeNode defaultMutableTreeNode, Object object) {
            block4: {
                block5: {
                    block3: {
                        if (!(object instanceof Vector)) break block3;
                        Vector vector = (Vector)object;
                        int n = 0;
                        int n2 = vector.size();
                        while (n < n2) {
                            defaultMutableTreeNode.add(new DynamicUtilTreeNode(vector.elementAt(n), vector.elementAt(n)));
                            ++n;
                        }
                        break block4;
                    }
                    if (!(object instanceof Hashtable)) break block5;
                    Hashtable hashtable = (Hashtable)object;
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        Object object2 = enumeration.nextElement();
                        defaultMutableTreeNode.add(new DynamicUtilTreeNode(object2, hashtable.get(object2)));
                    }
                    break block4;
                }
                if (!(object instanceof Object[])) break block4;
                Object[] objectArray = (Object[])object;
                int n = 0;
                int n3 = objectArray.length;
                while (n < n3) {
                    defaultMutableTreeNode.add(new DynamicUtilTreeNode(objectArray[n], objectArray[n]));
                    ++n;
                }
            }
        }

        public TreeNode getChildAt(int n) {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.getChildAt(n);
        }

        public int getChildCount() {
            if (!this.loadedChildren) {
                this.loadChildren();
            }
            return super.getChildCount();
        }

        public boolean isLeaf() {
            return this.getAllowsChildren() ^ true;
        }

        protected void loadChildren() {
            this.loadedChildren = true;
            DynamicUtilTreeNode.createChildren(this, this.childValue);
        }
    }

    protected class AccessibleJTree
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    TreeSelectionListener,
    TreeModelListener,
    TreeExpansionListener {
        TreePath leadSelectionPath;
        Accessible leadSelectionAccessible;

        public AccessibleJTree() {
            JTree.this.getModel().addTreeModelListener(this);
            JTree.this.addTreeExpansionListener(this);
            JTree.this.addTreeSelectionListener(this);
            this.leadSelectionPath = JTree.this.getLeadSelectionPath();
            this.leadSelectionAccessible = this.leadSelectionPath != null ? new AccessibleJTreeNode(JTree.this, this.leadSelectionPath, JTree.this) : null;
        }

        public void addAccessibleSelection(int n) {
            TreeModel treeModel = JTree.this.getModel();
            if (treeModel != null && n == 0) {
                Object[] objectArray = new Object[]{treeModel.getRoot()};
                TreePath treePath = new TreePath(objectArray);
                JTree.this.addSelectionPath(treePath);
            }
        }

        public void clearAccessibleSelection() {
            int n = this.getAccessibleChildrenCount();
            int n2 = 0;
            while (n2 < n) {
                this.removeAccessibleSelection(n2);
                ++n2;
            }
        }

        public void fireVisibleDataPropertyChange() {
            this.firePropertyChange("AccessibleVisibleData", new Boolean(false), new Boolean(true));
        }

        public Accessible getAccessibleAt(Point point) {
            TreePath treePath = JTree.this.getClosestPathForLocation(point.x, point.y);
            if (treePath != null) {
                return new AccessibleJTreeNode(JTree.this, treePath, JTree.this);
            }
            return null;
        }

        public Accessible getAccessibleChild(int n) {
            TreeModel treeModel = JTree.this.getModel();
            if (treeModel != null) {
                if (n != 0) {
                    return null;
                }
                Object[] objectArray = new Object[]{treeModel.getRoot()};
                TreePath treePath = new TreePath(objectArray);
                return new AccessibleJTreeNode(JTree.this, treePath, JTree.this);
            }
            return null;
        }

        public int getAccessibleChildrenCount() {
            TreeModel treeModel = JTree.this.getModel();
            if (treeModel != null) {
                return 1;
            }
            return 0;
        }

        public int getAccessibleIndexInParent() {
            return 0;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TREE;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleSelection(int n) {
            TreePath[] treePathArray = JTree.this.getSelectionPaths();
            if (n < 0 || n >= treePathArray.length) {
                return null;
            }
            return new AccessibleJTreeNode(JTree.this, treePathArray[n], JTree.this);
        }

        public int getAccessibleSelectionCount() {
            return JTree.this.getSelectionCount();
        }

        private AccessibleContext getCurrentAccessibleContext() {
            Component component = this.getCurrentComponent();
            if (component instanceof Accessible) {
                return ((Accessible)((Object)component)).getAccessibleContext();
            }
            return null;
        }

        private Component getCurrentComponent() {
            TreeModel treeModel = JTree.this.getModel();
            TreePath treePath = new TreePath(treeModel.getRoot());
            if (JTree.this.isVisible(treePath)) {
                TreeCellRenderer treeCellRenderer = JTree.this.getCellRenderer();
                TreeUI treeUI = JTree.this.getUI();
                if (treeUI != null) {
                    int n = treeUI.getRowForPath(JTree.this, treePath);
                    int n2 = JTree.this.getLeadSelectionRow();
                    boolean bl = JTree.this.hasFocus() && n2 == n;
                    boolean bl2 = JTree.this.isPathSelected(treePath);
                    boolean bl3 = JTree.this.isExpanded(treePath);
                    return treeCellRenderer.getTreeCellRendererComponent(JTree.this, treeModel.getRoot(), bl2, bl3, treeModel.isLeaf(treeModel.getRoot()), n, bl);
                }
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int n) {
            TreePath[] treePathArray = JTree.this.getSelectionPaths();
            TreeModel treeModel = JTree.this.getModel();
            int n2 = 0;
            while (n2 < treePathArray.length) {
                Object object = treePathArray[n2].getLastPathComponent();
                if (n == treeModel.getIndexOfChild(treeModel.getRoot(), object)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void removeAccessibleSelection(int n) {
            TreeModel treeModel = JTree.this.getModel();
            if (treeModel != null && n == 0) {
                Object[] objectArray = new Object[]{treeModel.getRoot()};
                TreePath treePath = new TreePath(objectArray);
                JTree.this.removeSelectionPath(treePath);
            }
        }

        public void selectAllAccessibleSelection() {
            TreeModel treeModel = JTree.this.getModel();
            if (treeModel != null) {
                Object[] objectArray = new Object[]{treeModel.getRoot()};
                TreePath treePath = new TreePath(objectArray);
                JTree.this.addSelectionPath(treePath);
            }
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            this.fireVisibleDataPropertyChange();
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            this.fireVisibleDataPropertyChange();
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            this.fireVisibleDataPropertyChange();
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            this.fireVisibleDataPropertyChange();
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            this.fireVisibleDataPropertyChange();
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            this.fireVisibleDataPropertyChange();
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = this.leadSelectionPath;
            this.leadSelectionPath = JTree.this.getLeadSelectionPath();
            if (treePath != this.leadSelectionPath) {
                Accessible accessible = this.leadSelectionAccessible;
                this.leadSelectionAccessible = this.leadSelectionPath != null ? new AccessibleJTreeNode(JTree.this, this.leadSelectionPath, JTree.this) : null;
                this.firePropertyChange("AccessibleActiveDescendant", accessible, this.leadSelectionAccessible);
            }
            this.firePropertyChange("AccessibleSelection", new Boolean(false), new Boolean(true));
        }

        protected class AccessibleJTreeNode
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent,
        AccessibleSelection,
        AccessibleAction {
            private JTree tree = null;
            private TreeModel treeModel = null;
            private Object obj = null;
            private Object objParent = null;
            private TreePath path = null;
            private Accessible accessibleParent = null;
            private int index = -1;
            private boolean isLeaf = false;

            public AccessibleJTreeNode(JTree jTree, TreePath treePath, Accessible accessible) {
                this.tree = jTree;
                this.path = treePath;
                this.accessibleParent = accessible;
                this.treeModel = jTree.getModel();
                this.obj = treePath.getLastPathComponent();
                Object[] objectArray = treePath.getPath();
                if (objectArray.length > 1) {
                    this.objParent = objectArray[objectArray.length - 2];
                    if (this.treeModel != null) {
                        this.index = this.treeModel.getIndexOfChild(this.objParent, this.obj);
                    }
                    Object[] objectArray2 = new Object[objectArray.length - 1];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length - 1);
                    TreePath treePath2 = new TreePath(objectArray2);
                    this.setAccessibleParent(this.accessibleParent);
                } else if (this.treeModel != null) {
                    this.index = this.treeModel.getIndexOfChild(this.treeModel.getRoot(), this.obj);
                    this.setAccessibleParent(this.tree);
                }
                if (this.treeModel != null) {
                    this.isLeaf = this.treeModel.isLeaf(this.obj);
                }
            }

            public void addAccessibleSelection(int n) {
                TreeModel treeModel = JTree.this.getModel();
                if (treeModel != null && n >= 0 && n < this.getAccessibleChildrenCount()) {
                    TreePath treePath = this.getChildTreePath(n);
                    JTree.this.addSelectionPath(treePath);
                }
            }

            public void addFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.addFocusListener(focusListener);
                    }
                }
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.addPropertyChangeListener(propertyChangeListener);
                } else {
                    super.addPropertyChangeListener(propertyChangeListener);
                }
            }

            public void clearAccessibleSelection() {
                int n = this.getAccessibleChildrenCount();
                int n2 = 0;
                while (n2 < n) {
                    this.removeAccessibleSelection(n2);
                    ++n2;
                }
            }

            public boolean contains(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                    return rectangle.contains(point);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    Rectangle rectangle = component.getBounds();
                    return rectangle.contains(point);
                }
                return this.getBounds().contains(point);
            }

            public boolean doAccessibleAction(int n) {
                AccessibleAction accessibleAction;
                if (n < 0 || n >= this.getAccessibleActionCount()) {
                    return false;
                }
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (n == 0) {
                    if (JTree.this.isExpanded(this.path)) {
                        JTree.this.collapsePath(this.path);
                    } else {
                        JTree.this.expandPath(this.path);
                    }
                    return true;
                }
                if (accessibleContext != null && (accessibleAction = accessibleContext.getAccessibleAction()) != null) {
                    return accessibleAction.doAccessibleAction(n - 1);
                }
                return false;
            }

            public AccessibleAction getAccessibleAction() {
                return this;
            }

            public int getAccessibleActionCount() {
                AccessibleAction accessibleAction;
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && (accessibleAction = accessibleContext.getAccessibleAction()) != null) {
                    return accessibleAction.getAccessibleActionCount() + (this.isLeaf ? 0 : 1);
                }
                return this.isLeaf ? 0 : 1;
            }

            public String getAccessibleActionDescription(int n) {
                AccessibleAction accessibleAction;
                if (n < 0 || n >= this.getAccessibleActionCount()) {
                    return null;
                }
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (n == 0) {
                    return "toggle expand";
                }
                if (accessibleContext != null && (accessibleAction = accessibleContext.getAccessibleAction()) != null) {
                    return accessibleAction.getAccessibleActionDescription(n - 1);
                }
                return null;
            }

            public Accessible getAccessibleAt(Point point) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
                }
                return null;
            }

            public Accessible getAccessibleChild(int n) {
                if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                    return null;
                }
                Object object = this.treeModel.getChild(this.obj, n);
                Object[] objectArray = this.path.getPath();
                Object[] objectArray2 = new Object[objectArray.length + 1];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                objectArray2[objectArray2.length - 1] = object;
                TreePath treePath = new TreePath(objectArray2);
                return new AccessibleJTreeNode(JTree.this, treePath, this);
            }

            public int getAccessibleChildrenCount() {
                return this.treeModel.getChildCount(this.obj);
            }

            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            public AccessibleContext getAccessibleContext() {
                return this;
            }

            public String getAccessibleDescription() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleDescription();
                }
                return super.getAccessibleDescription();
            }

            public int getAccessibleIndexInParent() {
                return this.index;
            }

            public String getAccessibleName() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    String string = accessibleContext.getAccessibleName();
                    if (string != null && string != "") {
                        return accessibleContext.getAccessibleName();
                    }
                    return null;
                }
                if (this.accessibleName != null && this.accessibleName != "") {
                    return this.accessibleName;
                }
                return null;
            }

            public Accessible getAccessibleParent() {
                return this.accessibleParent;
            }

            public AccessibleRole getAccessibleRole() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getAccessibleRole();
                }
                return AccessibleRole.UNKNOWN;
            }

            public AccessibleSelection getAccessibleSelection() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null && this.isLeaf) {
                    return this.getCurrentAccessibleContext().getAccessibleSelection();
                }
                return this;
            }

            public Accessible getAccessibleSelection(int n) {
                int n2 = this.getAccessibleChildrenCount();
                if (n < 0 || n >= n2) {
                    return null;
                }
                int n3 = 0;
                int n4 = 0;
                while (n4 < n2 && n >= n3) {
                    TreePath treePath = this.getChildTreePath(n4);
                    if (this.tree.isPathSelected(treePath)) {
                        if (n3 == n) {
                            return new AccessibleJTreeNode(this.tree, treePath, this);
                        }
                        ++n3;
                    }
                    ++n4;
                }
                return null;
            }

            public int getAccessibleSelectionCount() {
                int n = 0;
                int n2 = this.getAccessibleChildrenCount();
                int n3 = 0;
                while (n3 < n2) {
                    TreePath treePath = this.getChildTreePath(n3);
                    if (this.tree.isPathSelected(treePath)) {
                        ++n;
                    }
                    ++n3;
                }
                return n;
            }

            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                int n = this.tree.getUI().getRowForPath(this.tree, this.path);
                int n2 = this.tree.getLeadSelectionRow();
                AccessibleStateSet accessibleStateSet = accessibleContext != null ? accessibleContext.getAccessibleStateSet() : new AccessibleStateSet();
                if (this.isShowing()) {
                    accessibleStateSet.add(AccessibleState.SHOWING);
                } else if (accessibleStateSet.contains(AccessibleState.SHOWING)) {
                    accessibleStateSet.remove(AccessibleState.SHOWING);
                }
                if (this.isVisible()) {
                    accessibleStateSet.add(AccessibleState.VISIBLE);
                } else if (accessibleStateSet.contains(AccessibleState.VISIBLE)) {
                    accessibleStateSet.remove(AccessibleState.VISIBLE);
                }
                if (this.tree.isPathSelected(this.path)) {
                    accessibleStateSet.add(AccessibleState.SELECTED);
                }
                if (n2 == n) {
                    accessibleStateSet.add(AccessibleState.ACTIVE);
                }
                if (!this.isLeaf) {
                    accessibleStateSet.add(AccessibleState.EXPANDABLE);
                }
                if (this.tree.isExpanded(this.path)) {
                    accessibleStateSet.add(AccessibleState.EXPANDED);
                } else {
                    accessibleStateSet.add(AccessibleState.COLLAPSED);
                }
                if (this.tree.isEditable()) {
                    accessibleStateSet.add(AccessibleState.EDITABLE);
                }
                return accessibleStateSet;
            }

            public AccessibleText getAccessibleText() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return this.getCurrentAccessibleContext().getAccessibleText();
                }
                return null;
            }

            public AccessibleValue getAccessibleValue() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return this.getCurrentAccessibleContext().getAccessibleValue();
                }
                return null;
            }

            public Color getBackground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getBackground();
                }
                return null;
            }

            public Rectangle getBounds() {
                Rectangle rectangle = this.tree.getPathBounds(this.path);
                Accessible accessible = this.getAccessibleParent();
                if (accessible != null && accessible instanceof AccessibleJTreeNode) {
                    Point point = ((AccessibleJTreeNode)accessible).getLocationInJTree();
                    if (point != null && rectangle != null) {
                        rectangle.translate(-point.x, -point.y);
                    } else {
                        return null;
                    }
                }
                return rectangle;
            }

            private TreePath getChildTreePath(int n) {
                if (n < 0 || n >= this.getAccessibleChildrenCount()) {
                    return null;
                }
                Object object = this.treeModel.getChild(this.obj, n);
                Object[] objectArray = this.path.getPath();
                Object[] objectArray2 = new Object[objectArray.length + 1];
                System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                objectArray2[objectArray2.length - 1] = object;
                return new TreePath(objectArray2);
            }

            private AccessibleContext getCurrentAccessibleContext() {
                Component component = this.getCurrentComponent();
                if (component instanceof Accessible) {
                    return ((Accessible)((Object)component)).getAccessibleContext();
                }
                return null;
            }

            private Component getCurrentComponent() {
                if (this.tree.isVisible(this.path)) {
                    TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
                    if (treeCellRenderer == null) {
                        return null;
                    }
                    TreeUI treeUI = this.tree.getUI();
                    if (treeUI != null) {
                        int n = treeUI.getRowForPath(JTree.this, this.path);
                        boolean bl = this.tree.isPathSelected(this.path);
                        boolean bl2 = this.tree.isExpanded(this.path);
                        boolean bl3 = false;
                        return treeCellRenderer.getTreeCellRendererComponent(this.tree, this.obj, bl, bl2, this.isLeaf, n, bl3);
                    }
                }
                return null;
            }

            public Cursor getCursor() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getCursor();
                }
                Accessible accessible = this.getAccessibleParent();
                if (accessible instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessible)).getCursor();
                }
                return null;
            }

            public Font getFont() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFont();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFont();
                }
                return null;
            }

            public FontMetrics getFontMetrics(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getFontMetrics(font);
                }
                return null;
            }

            public Color getForeground() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.getForeground();
                }
                return null;
            }

            public Locale getLocale() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    return accessibleContext.getLocale();
                }
                return this.tree.getLocale();
            }

            public Point getLocation() {
                Rectangle rectangle = this.getBounds();
                if (rectangle != null) {
                    return rectangle.getLocation();
                }
                return null;
            }

            protected Point getLocationInJTree() {
                Rectangle rectangle = this.tree.getPathBounds(this.path);
                if (rectangle != null) {
                    return rectangle.getLocation();
                }
                return null;
            }

            public Point getLocationOnScreen() {
                if (this.tree != null) {
                    Point point = this.tree.getLocationOnScreen();
                    Point point2 = this.getLocation();
                    point2.translate(point.x, point.y);
                    return point2;
                }
                return null;
            }

            public Dimension getSize() {
                return this.getBounds().getSize();
            }

            public boolean isAccessibleChildSelected(int n) {
                int n2 = this.getAccessibleChildrenCount();
                if (n < 0 || n >= n2) {
                    return false;
                }
                TreePath treePath = this.getChildTreePath(n);
                return this.tree.isPathSelected(treePath);
            }

            public boolean isEnabled() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isEnabled();
                }
                return false;
            }

            public boolean isFocusTraversable() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
                }
                Component component = this.getCurrentComponent();
                if (component != null) {
                    return component.isFocusTraversable();
                }
                return false;
            }

            public boolean isShowing() {
                return this.tree.isShowing() && this.isVisible();
            }

            public boolean isVisible() {
                Rectangle rectangle = this.tree.getPathBounds(this.path);
                Rectangle rectangle2 = this.tree.getVisibleRect();
                return rectangle != null && rectangle2 != null && rectangle2.intersects(rectangle);
            }

            public void removeAccessibleSelection(int n) {
                TreeModel treeModel = JTree.this.getModel();
                if (treeModel != null && n >= 0 && n < this.getAccessibleChildrenCount()) {
                    TreePath treePath = this.getChildTreePath(n);
                    JTree.this.removeSelectionPath(treePath);
                }
            }

            public void removeFocusListener(FocusListener focusListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.removeFocusListener(focusListener);
                    }
                }
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.removePropertyChangeListener(propertyChangeListener);
                } else {
                    super.removePropertyChangeListener(propertyChangeListener);
                }
            }

            public void requestFocus() {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.requestFocus();
                    }
                }
            }

            public void selectAllAccessibleSelection() {
                TreeModel treeModel = JTree.this.getModel();
                if (treeModel != null) {
                    int n = this.getAccessibleChildrenCount();
                    int n2 = 0;
                    while (n2 < n) {
                        TreePath treePath = this.getChildTreePath(n2);
                        JTree.this.addSelectionPath(treePath);
                        ++n2;
                    }
                }
            }

            public void setAccessibleDescription(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleDescription(string);
                } else {
                    super.setAccessibleDescription(string);
                }
            }

            public void setAccessibleName(String string) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext != null) {
                    accessibleContext.setAccessibleName(string);
                } else {
                    super.setAccessibleName(string);
                }
            }

            public void setBackground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBackground(color);
                    }
                }
            }

            public void setBounds(Rectangle rectangle) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setBounds(rectangle);
                    }
                }
            }

            public void setCursor(Cursor cursor) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setCursor(cursor);
                    }
                }
            }

            public void setEnabled(boolean bl) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setEnabled(bl);
                    }
                }
            }

            public void setFont(Font font) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setFont(font);
                    }
                }
            }

            public void setForeground(Color color) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setForeground(color);
                    }
                }
            }

            public void setLocation(Point point) {
            }

            public void setSize(Dimension dimension) {
                AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
                if (accessibleContext instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
                } else {
                    Component component = this.getCurrentComponent();
                    if (component != null) {
                        component.setSize(dimension);
                    }
                }
            }

            public void setVisible(boolean bl) {
            }
        }
    }
}

