/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ExtendedTextLabel;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StandardExtendedTextLabel;
import javax.swing.text.StateInvariantError;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class LabelView
extends View {
    Font font;
    Color fg;
    boolean underline;
    boolean strike;
    boolean superscript;
    boolean subscript;
    Segment text = new Segment();
    LabelFragment[] fragments;
    TabExpander expander;
    int x;

    public LabelView(Element element) {
        super(element);
    }

    public View breakView(int n, int n2, float f, float f2) {
        this.syncFragments();
        if (this.fragments.length > 1) {
            throw new StateInvariantError("Method invalid for multi-directional LabelView");
        }
        return this.fragments[0].breakView(n, n2, f, f2);
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.font = null;
        this.fragments = null;
    }

    public View createFragment(int n, int n2) {
        this.syncFragments();
        int n3 = 0;
        while (n3 < this.fragments.length) {
            LabelFragment labelFragment = this.fragments[n3];
            int n4 = ((View)labelFragment).getStartOffset();
            int n5 = ((View)labelFragment).getEndOffset();
            if (n < n4) {
                return this;
            }
            if (n == n4) {
                if (n2 < n5) {
                    return ((View)labelFragment).createFragment(n, n2);
                }
                if (n2 == n5) {
                    return labelFragment;
                }
                if (n2 > n5) {
                    throw new StateInvariantError("frags can't span dir boundaries");
                }
            } else if (n < n5) {
                if (n2 <= n5) {
                    return ((View)labelFragment).createFragment(n, n2);
                }
                throw new StateInvariantError("frags can't span dir boundaries");
            }
            ++n3;
        }
        return this;
    }

    public float getAlignment(int n) {
        this.syncFragments();
        if (this.fragments.length > 1) {
            throw new StateInvariantError("Method invalid for multi-directional LabelView");
        }
        return this.fragments[0].getAlignment(n);
    }

    public int getBreakWeight(int n, float f, float f2) {
        this.syncFragments();
        if (this.fragments.length > 1) {
            throw new StateInvariantError("Method invalid for multi-directional LabelView");
        }
        return this.fragments[0].getBreakWeight(n, f, f2);
    }

    protected Font getFont() {
        this.syncProperties();
        return this.font;
    }

    protected FontMetrics getFontMetrics() {
        this.syncProperties();
        return Toolkit.getDefaultToolkit().getFontMetrics(this.font);
    }

    public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
        this.syncFragments();
        if (this.fragments.length > 1) {
            throw new StateInvariantError("Method invalid for multi-directional LabelView");
        }
        return this.fragments[0].getNextVisualPositionFrom(n, bias, shape, n2, biasArray);
    }

    public float getPreferredSpan(int n) {
        this.syncFragments();
        float f = 0.0f;
        int n2 = 0;
        while (n2 < this.fragments.length) {
            f += this.fragments[n2].getPreferredSpan(n);
            ++n2;
        }
        return f;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.fragments = null;
        super.insertUpdate(documentEvent, shape, viewFactory);
    }

    final void loadText(int n, int n2) {
        try {
            Document document = this.getDocument();
            document.getText(n, n2 - n, this.text);
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("LabelView: Stale view: " + badLocationException);
        }
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        this.syncFragments();
        if (this.fragments.length > 1) {
            throw new StateInvariantError("Method invalid for multi-directional LabelView");
        }
        return this.fragments[0].modelToView(n, shape, bias);
    }

    public void paint(Graphics graphics, Shape shape) {
        this.syncFragments();
        if (this.fragments.length > 1) {
            throw new StateInvariantError("Method invalid for multi-directional LabelView");
        }
        this.fragments[0].paint(graphics, shape);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.fragments = null;
        super.removeUpdate(documentEvent, shape, viewFactory);
    }

    protected void setPropertiesFromAttributes() {
        AttributeSet attributeSet = this.getAttributes();
        Document document = this.getDocument();
        if (attributeSet != null) {
            if (document instanceof StyledDocument) {
                StyledDocument styledDocument = (StyledDocument)document;
                this.font = styledDocument.getFont(attributeSet);
                this.fg = styledDocument.getForeground(attributeSet);
                this.setStrikeThrough(StyleConstants.isStrikeThrough(attributeSet));
                this.setSuperscript(StyleConstants.isSuperscript(attributeSet));
                this.setSubscript(StyleConstants.isSubscript(attributeSet));
                this.setUnderline(StyleConstants.isUnderline(attributeSet));
            } else {
                throw new StateInvariantError("LabelView needs StyledDocument");
            }
        }
    }

    protected void setStrikeThrough(boolean bl) {
        this.strike = bl;
    }

    protected void setSubscript(boolean bl) {
        this.subscript = bl;
    }

    protected void setSuperscript(boolean bl) {
        this.superscript = bl;
    }

    protected void setUnderline(boolean bl) {
        this.underline = bl;
    }

    private final void syncFragments() {
        int n;
        if (this.fragments != null) {
            return;
        }
        int n2 = this.getStartOffset();
        int n3 = this.getEndOffset();
        Element element = this.getElement();
        AbstractDocument abstractDocument = (AbstractDocument)this.getDocument();
        Element element2 = abstractDocument.getParagraphElement(n2);
        int n4 = element2.getStartOffset();
        int n5 = element2.getEndOffset();
        if (n3 > n5) {
            throw new StateInvariantError("LabelView may not span paragraphs");
        }
        Element element3 = abstractDocument.getBidiRootElement();
        int n6 = element3.getElementIndex(n2);
        if (n6 > (n = element3.getElementIndex(n3 - 1))) {
            throw new StateInvariantError("0 length element encountered.");
        }
        this.syncProperties();
        Graphics2D graphics2D = (Graphics2D)this.getContainer().getGraphics();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        this.fragments = new LabelFragment[n - n6 + 1];
        int n7 = n2;
        int n8 = n6;
        while (n8 <= n) {
            AbstractDocument.BidiElement bidiElement = (AbstractDocument.BidiElement)element3.getElement(n8);
            int n9 = bidiElement.getStartOffset();
            int n10 = bidiElement.getEndOffset();
            int n11 = Math.min(n3, n10);
            int n12 = Math.max(n4, n9);
            int n13 = Math.min(n5, n10);
            this.loadText(n12, n13);
            ExtendedTextLabel extendedTextLabel = StandardExtendedTextLabel.create(this.text.array, this.text.offset, this.text.count, this.text.offset + n7 - n12, n11 - n7, bidiElement.isLeftToRight(), this.font, fontRenderContext);
            this.fragments[n8 - n6] = new LabelFragment(element, n7, n11, extendedTextLabel);
            this.fragments[n8 - n6].setParent(this);
            n7 = n11;
            ++n8;
        }
    }

    final void syncProperties() {
        if (this.font == null) {
            this.setPropertiesFromAttributes();
        }
    }

    public String toString() {
        String string = "LabelView: elem = " + this.getElement().toString();
        if (this.fragments == null) {
            string = String.valueOf(string) + "\tfragments = null\n";
        } else {
            int n = 0;
            while (n < this.fragments.length) {
                string = String.valueOf(string) + "\tfragment = " + this.fragments[n].toString() + "\n";
                ++n;
            }
        }
        return string;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        this.syncFragments();
        if (this.fragments.length > 1) {
            throw new StateInvariantError("Method invalid for multi-directional LabelView");
        }
        return this.fragments[0].viewToModel(f, f2, shape, biasArray);
    }

    class LabelFragment
    extends View {
        short offset;
        short length;
        int x;
        boolean rightToLeft;
        ExtendedTextLabel glyphs;

        public LabelFragment(Element element, int n, int n2, ExtendedTextLabel extendedTextLabel) {
            super(element);
            this.offset = (short)(n - element.getStartOffset());
            this.length = (short)(n2 - n);
            this.glyphs = extendedTextLabel;
            Document document = this.getDocument();
            if (document instanceof AbstractDocument) {
                this.rightToLeft = ((AbstractDocument)document).isLeftToRight(n, n2) ^ true;
            }
        }

        public View breakView(int n, int n2, float f, float f2) {
            if (n == 0) {
                char c;
                LabelView.this.syncProperties();
                LabelView.this.loadText(n2, this.getEndOffset());
                int n3 = this.glyphs.getLineBreakIndex(n2 - this.getStartOffset(), f2);
                int n4 = LabelView.this.text.offset + Math.min(n3, LabelView.this.text.count - 1);
                while (n4 >= LabelView.this.text.offset) {
                    c = LabelView.this.text.array[n4];
                    if (Character.isWhitespace(c)) {
                        n3 = n4 - LabelView.this.text.offset + 1;
                        break;
                    }
                    --n4;
                }
                c = n2 + n3;
                LabelFragment labelFragment = (LabelFragment)LabelView.this.createFragment(n2, c);
                labelFragment.x = (int)f;
                return labelFragment;
            }
            return this;
        }

        public View createFragment(int n, int n2) {
            int n3;
            int n4 = this.getStartOffset();
            int n5 = this.getEndOffset();
            AbstractDocument abstractDocument = (AbstractDocument)this.getDocument();
            Element element = abstractDocument.getParagraphElement(n4);
            int n6 = element.getStartOffset();
            int n7 = element.getEndOffset();
            if (n5 > n7) {
                throw new StateInvariantError("LabelFragment may not span paragraphs");
            }
            Element element2 = abstractDocument.getBidiRootElement();
            AbstractDocument.BidiElement bidiElement = (AbstractDocument.BidiElement)element2.getElement(n3 = element2.getElementIndex(n4));
            if (bidiElement.getEndOffset() < n5) {
                throw new StateInvariantError("LabelFragments may not span directional boundaries.");
            }
            LabelView.this.syncProperties();
            Graphics2D graphics2D = (Graphics2D)this.getContainer().getGraphics();
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            int n8 = bidiElement.getStartOffset();
            int n9 = bidiElement.getEndOffset();
            int n10 = Math.max(n6, n8);
            int n11 = Math.min(n7, n9);
            LabelView.this.loadText(n10, n11);
            ExtendedTextLabel extendedTextLabel = StandardExtendedTextLabel.create(LabelView.this.text.array, LabelView.this.text.offset, LabelView.this.text.count, LabelView.this.text.offset + n - n10, n2 - n, bidiElement.isLeftToRight(), LabelView.this.font, fontRenderContext);
            return new LabelFragment(this.getElement(), n, n2, extendedTextLabel);
        }

        public float getAlignment(int n) {
            if (n == 1) {
                LineMetrics lineMetrics = this.glyphs.getLineMetrics();
                return lineMetrics.getAscent() / lineMetrics.getHeight();
            }
            return super.getAlignment(n);
        }

        public int getBreakWeight(int n, float f, float f2) {
            int n2 = this.getStartOffset();
            int n3 = this.getEndOffset();
            if (n == 0) {
                LabelView.this.syncProperties();
                LabelView.this.loadText(n2, n3);
                if (f2 < 0.0f) {
                    return 0;
                }
                int n4 = this.glyphs.getLineBreakIndex(0, f2);
                if (n4 == 0) {
                    return 0;
                }
                int n5 = LabelView.this.text.offset + Math.min(n4, LabelView.this.text.count - 1);
                while (n5 >= LabelView.this.text.offset) {
                    char c = LabelView.this.text.array[n5];
                    if (Character.isWhitespace(c)) {
                        return 2000;
                    }
                    --n5;
                }
                return 1000;
            }
            return super.getBreakWeight(n, f, f2);
        }

        public Container getContainer() {
            return LabelView.this.getContainer();
        }

        public int getEndOffset() {
            Element element = this.getElement();
            return element.getStartOffset() + this.offset + this.length;
        }

        public int getNextVisualPositionFrom(int n, Position.Bias bias, Shape shape, int n2, Position.Bias[] biasArray) throws BadLocationException {
            int n3 = this.getStartOffset();
            int n4 = this.getEndOffset();
            switch (n2) {
                case 3: {
                    if (n3 == this.getDocument().getLength()) {
                        if (n == -1) {
                            biasArray[0] = Position.Bias.Forward;
                            return n3;
                        }
                        return -1;
                    }
                    if (this.rightToLeft) {
                        if (n == -1) {
                            LabelView.this.loadText(n4 - 1, n4);
                            if (LabelView.this.text.array[LabelView.this.text.offset] == '\n') {
                                biasArray[0] = Position.Bias.Forward;
                                return n4 - 1;
                            }
                            biasArray[0] = Position.Bias.Backward;
                            return n4;
                        }
                        if (n == n3) {
                            return -1;
                        }
                        biasArray[0] = Position.Bias.Forward;
                        while (--n >= n3 && this.glyphs.getCharAdvance(n - n3) == 0.0f) {
                        }
                        if (n < n3) {
                            return -1;
                        }
                        return n;
                    }
                    if (n == -1) {
                        biasArray[0] = Position.Bias.Forward;
                        return n3;
                    }
                    if (n == n4) {
                        return -1;
                    }
                    if (++n == n4) {
                        LabelView.this.loadText(n4 - 1, n4);
                        if (LabelView.this.text.array[LabelView.this.text.offset] == '\n') {
                            return -1;
                        }
                        biasArray[0] = Position.Bias.Backward;
                    } else {
                        biasArray[0] = Position.Bias.Forward;
                    }
                    return n;
                }
                case 7: {
                    if (n3 == this.getDocument().getLength()) {
                        if (n == -1) {
                            biasArray[0] = Position.Bias.Forward;
                            return n3;
                        }
                        return -1;
                    }
                    if (this.rightToLeft) {
                        if (n == -1) {
                            biasArray[0] = Position.Bias.Forward;
                            return n3;
                        }
                        if (n == n4) {
                            return -1;
                        }
                        if (++n == n4) {
                            LabelView.this.loadText(n4 - 1, n4);
                            if (LabelView.this.text.array[LabelView.this.text.offset] == '\n') {
                                return -1;
                            }
                            biasArray[0] = Position.Bias.Backward;
                        } else {
                            biasArray[0] = Position.Bias.Forward;
                        }
                        return n;
                    }
                    if (n == -1) {
                        LabelView.this.loadText(n4 - 1, n4);
                        if (LabelView.this.text.array[LabelView.this.text.offset] == '\n') {
                            biasArray[0] = Position.Bias.Forward;
                            return n4 - 1;
                        }
                        biasArray[0] = Position.Bias.Backward;
                        return n4;
                    }
                    if (n == n3) {
                        return -1;
                    }
                    biasArray[0] = Position.Bias.Forward;
                    return n - 1;
                }
                default: {
                    throw new IllegalArgumentException("Bad direction: " + n2);
                }
                case 1: 
                case 5: 
            }
            return n;
        }

        public float getPreferredSpan(int n) {
            Rectangle2D rectangle2D = this.glyphs.getLogicalBounds(0.0f, 0.0f);
            switch (n) {
                case 0: {
                    return Math.max((float)rectangle2D.getWidth(), 1.0f);
                }
                case 1: {
                    return (float)rectangle2D.getHeight();
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + n);
        }

        public int getStartOffset() {
            Element element = this.getElement();
            return element.getStartOffset() + this.offset;
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            float f;
            float f2;
            int n2 = this.getStartOffset();
            int n3 = this.getEndOffset();
            if (n > n3 || n < n2 || n == n3 && bias == Position.Bias.Forward || n == n2 && bias == Position.Bias.Backward) {
                String string = "modelToView - Position (" + n + "," + bias + ") not in view's range of (" + this.getStartOffset() + "," + this.getEndOffset() + ").";
                throw new BadLocationException(string, n);
            }
            int n4 = n - n2;
            float f3 = 0.0f;
            if (this.rightToLeft) {
                if (bias == Position.Bias.Forward) {
                    f2 = this.glyphs.getCharX(n4);
                    f = this.glyphs.getCharAdvance(n4);
                    f3 = f2 + f;
                } else {
                    f3 = this.glyphs.getCharX(n4 - 1);
                }
            } else if (bias == Position.Bias.Forward) {
                f3 = this.glyphs.getCharX(n4);
            } else {
                f2 = this.glyphs.getCharX(n4 - 1);
                f = this.glyphs.getCharAdvance(n4 - 1);
                f3 = f2 + f;
            }
            Rectangle rectangle = shape.getBounds();
            f = this.glyphs.getLineMetrics().getHeight();
            return new Rectangle(rectangle.x + (int)f3, rectangle.y, 0, (int)f);
        }

        public void paint(Graphics graphics, Shape shape) {
            LabelView.this.syncProperties();
            JTextComponent jTextComponent = (JTextComponent)this.getContainer();
            Highlighter highlighter = jTextComponent.getHighlighter();
            if (highlighter instanceof LayeredHighlighter) {
                ((LayeredHighlighter)highlighter).paintLayeredHighlights(graphics, this.getStartOffset(), this.getEndOffset(), shape, jTextComponent, this);
            }
            if (Utilities.isComposedTextElement(this.getElement())) {
                this.paintComposedText((Graphics2D)graphics, shape.getBounds(), this.getStartOffset(), this.getEndOffset());
            } else {
                this.paintText((Graphics2D)graphics, shape);
            }
        }

        void paintComposedText(Graphics2D graphics2D, Rectangle rectangle, int n, int n2) {
            AttributeSet attributeSet = this.getElement().getAttributes();
            AttributedString attributedString = (AttributedString)attributeSet.getAttribute(StyleConstants.ComposedTextAttribute);
            int n3 = this.getElement().getStartOffset();
            int n4 = rectangle.y + rectangle.height - (int)this.glyphs.getLineMetrics().getDescent();
            int n5 = rectangle.x;
            attributedString.addAttribute(TextAttribute.FONT, LabelView.this.font);
            attributedString.addAttribute(TextAttribute.FOREGROUND, LabelView.this.fg);
            if (StyleConstants.isBold(attributeSet)) {
                attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            if (StyleConstants.isItalic(attributeSet)) {
                attributedString.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
            }
            if (LabelView.this.underline) {
                attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            }
            if (LabelView.this.strike) {
                attributedString.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            }
            if (LabelView.this.superscript) {
                attributedString.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER);
            }
            if (LabelView.this.subscript) {
                attributedString.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB);
            }
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator(null, n - n3, n2 - n3);
            TextLayout textLayout = new TextLayout(attributedCharacterIterator, graphics2D.getFontRenderContext());
            textLayout.draw(graphics2D, n5, n4);
        }

        void paintSelection(Graphics graphics, Shape shape) {
            int n;
            int n2;
            int n3;
            JTextComponent jTextComponent = (JTextComponent)this.getContainer();
            if (jTextComponent == null) {
                return;
            }
            Color color = jTextComponent.getSelectionColor();
            if (color == null) {
                return;
            }
            int n4 = this.getStartOffset();
            int n5 = this.getEndOffset();
            Position.Bias[] biasArray = new Position.Bias[1];
            Position.Bias[] biasArray2 = new Position.Bias[1];
            int n6 = jTextComponent.getSelectionStart(biasArray);
            if (n6 == (n3 = jTextComponent.getSelectionEnd(biasArray2))) {
                return;
            }
            if (n6 <= n4) {
                n2 = n4;
                biasArray[0] = Position.Bias.Forward;
            } else {
                n2 = Math.min(n6, n5);
            }
            if (n3 >= n5) {
                n = n5;
                biasArray2[0] = Position.Bias.Backward;
            } else {
                n = Math.max(n3, n4);
            }
            if (n2 == n) {
                return;
            }
            try {
                Rectangle rectangle = this.modelToView(n, shape, biasArray2[0]).getBounds();
                Rectangle rectangle2 = this.modelToView(n2, shape, biasArray[0]).getBounds();
                Rectangle rectangle3 = rectangle2.union(rectangle);
                graphics.setColor(color);
                graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            }
            catch (BadLocationException badLocationException) {}
        }

        void paintText(Graphics2D graphics2D, Shape shape) {
            Rectangle rectangle = shape.getBounds();
            float f = (float)rectangle.y + this.glyphs.getLineMetrics().getAscent();
            graphics2D.setFont(LabelView.this.font);
            graphics2D.setColor(LabelView.this.fg);
            this.glyphs.draw(graphics2D, rectangle.x, f);
            if (LabelView.this.underline || LabelView.this.strike) {
                float f2;
                float f3;
                LineMetrics lineMetrics = this.glyphs.getLineMetrics();
                if (LabelView.this.underline) {
                    f3 = f + lineMetrics.getUnderlineOffset();
                    f2 = lineMetrics.getUnderlineThickness();
                } else {
                    f3 = f + lineMetrics.getStrikethroughOffset();
                    f2 = lineMetrics.getStrikethroughThickness();
                }
                Rectangle2D.Float float_ = new Rectangle2D.Float(rectangle.x, f3, rectangle.width, f2);
                graphics2D.fill(float_);
            }
        }

        public String toString() {
            String string = "LabelFrag: elem(" + this.getStartOffset() + ", " + this.getEndOffset() + ")\n";
            return string;
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            Rectangle rectangle;
            Rectangle rectangle2 = rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            if (f < (float)rectangle.x) {
                if (this.rightToLeft) {
                    biasArray[0] = Position.Bias.Backward;
                    return this.getEndOffset();
                }
                biasArray[0] = Position.Bias.Forward;
                return this.getStartOffset();
            }
            if (f >= (float)(rectangle.x + rectangle.width)) {
                if (this.rightToLeft) {
                    biasArray[0] = Position.Bias.Forward;
                    return this.getStartOffset();
                }
                biasArray[0] = Position.Bias.Backward;
                return this.getEndOffset();
            }
            float f3 = f - (float)rectangle.x;
            int n = this.glyphs.getCharIndexAtWidth(f3);
            float f4 = this.glyphs.getCharX(n);
            float f5 = this.glyphs.getCharAdvance(n);
            int n2 = this.getStartOffset();
            if (f3 < f4 + f5 / 2.0f) {
                if (this.rightToLeft) {
                    n2 += n + 1;
                    biasArray[0] = Position.Bias.Backward;
                } else {
                    n2 += n;
                    biasArray[0] = Position.Bias.Forward;
                }
            } else if (this.rightToLeft) {
                n2 += n;
                biasArray[0] = Position.Bias.Forward;
            } else {
                n2 += n + 1;
                biasArray[0] = Position.Bias.Backward;
            }
            return n2;
        }
    }
}

