/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.TextAction;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.BRView;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;
import javax.swing.text.html.CommentView;
import javax.swing.text.html.FormView;
import javax.swing.text.html.FrameSetView;
import javax.swing.text.html.FrameView;
import javax.swing.text.html.HRuleView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import javax.swing.text.html.HTMLWriter;
import javax.swing.text.html.HiddenTagView;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.InlineView;
import javax.swing.text.html.IsindexView;
import javax.swing.text.html.LineView;
import javax.swing.text.html.ListView;
import javax.swing.text.html.MinimalHTMLWriter;
import javax.swing.text.html.NoFramesView;
import javax.swing.text.html.ObjectView;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.StyleSheet;
import javax.swing.text.html.TableView;

public class HTMLEditorKit
extends StyledEditorKit {
    public static final String DEFAULT_CSS = "default.css";
    private static StyleSheet defaultStyles = null;
    private MouseListener linkHandler = new LinkController();
    private static Parser defaultParser = null;
    public static final String BOLD_ACTION = "html-bold-action";
    public static final String ITALIC_ACTION = "html-italic-action";
    public static final String PARA_INDENT_LEFT = "html-para-indent-left";
    public static final String PARA_INDENT_RIGHT = "html-para-indent-right";
    public static final String FONT_CHANGE_BIGGER = "html-font-bigger";
    public static final String FONT_CHANGE_SMALLER = "html-font-smaller";
    public static final String COLOR_ACTION = "html-color-action";
    public static final String LOGICAL_STYLE_ACTION = "html-logical-style-action";
    public static final String IMG_ALIGN_TOP = "html-image-align-top";
    public static final String IMG_ALIGN_MIDDLE = "html-image-align-middle";
    public static final String IMG_ALIGN_BOTTOM = "html-image-align-bottom";
    public static final String IMG_BORDER = "html-image-border";
    private static final String INSERT_TABLE_HTML = "<table border=1><tr><td></td></tr></table>";
    private static final String INSERT_UL_HTML = "<ul><li></li></ul>";
    private static final String INSERT_OL_HTML = "<ol><li></li></ol>";
    private static final Action[] defaultActions = new Action[]{new InsertHTMLTextAction("InsertTable", "<table border=1><tr><td></td></tr></table>", HTML.Tag.BODY, HTML.Tag.TABLE), new InsertHTMLTextAction("InsertTableRow", "<table border=1><tr><td></td></tr></table>", HTML.Tag.TABLE, HTML.Tag.TR, HTML.Tag.BODY, HTML.Tag.TABLE), new InsertHTMLTextAction("InsertTableDataCell", "<table border=1><tr><td></td></tr></table>", HTML.Tag.TR, HTML.Tag.TD, HTML.Tag.BODY, HTML.Tag.TABLE), new InsertHTMLTextAction("InsertUnorderedList", "<ul><li></li></ul>", HTML.Tag.BODY, HTML.Tag.UL), new InsertHTMLTextAction("InsertUnorderedListItem", "<ul><li></li></ul>", HTML.Tag.UL, HTML.Tag.LI, HTML.Tag.BODY, HTML.Tag.UL), new InsertHTMLTextAction("InsertOrderedList", "<ol><li></li></ol>", HTML.Tag.BODY, HTML.Tag.OL), new InsertHTMLTextAction("InsertOrderedListItem", "<ol><li></li></ol>", HTML.Tag.OL, HTML.Tag.LI, HTML.Tag.BODY, HTML.Tag.OL)};
    static /* synthetic */ Class class$javax$swing$text$html$HTMLEditorKit;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public Object clone() {
        return new HTMLEditorKit();
    }

    public Document createDefaultDocument() {
        StyleSheet styleSheet = this.getStyleSheet();
        HTMLDocument hTMLDocument = new HTMLDocument(styleSheet);
        hTMLDocument.setAsynchronousLoadPriority(4);
        hTMLDocument.setTokenThreshold(100);
        return hTMLDocument;
    }

    protected void createInputAttributes(Element element, MutableAttributeSet mutableAttributeSet) {
        mutableAttributeSet.removeAttributes(mutableAttributeSet);
        mutableAttributeSet.addAttributes(element.getAttributes());
        mutableAttributeSet.removeAttribute(StyleConstants.ComposedTextAttribute);
        Object object = mutableAttributeSet.getAttribute(StyleConstants.NameAttribute);
        if (object instanceof HTML.Tag) {
            HTML.Tag tag = (HTML.Tag)object;
            if (tag == HTML.Tag.IMG) {
                mutableAttributeSet.removeAttribute(HTML.Attribute.SRC);
                mutableAttributeSet.removeAttribute(HTML.Attribute.HEIGHT);
                mutableAttributeSet.removeAttribute(HTML.Attribute.WIDTH);
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            } else if (tag == HTML.Tag.HR) {
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
            } else if (tag == HTML.Tag.COMMENT) {
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                mutableAttributeSet.removeAttribute(HTML.Attribute.COMMENT);
            } else if (tag instanceof HTML.UnknownTag) {
                mutableAttributeSet.addAttribute(StyleConstants.NameAttribute, HTML.Tag.CONTENT);
                mutableAttributeSet.removeAttribute(HTML.Attribute.ENDTAG);
            }
        }
    }

    public void deinstall(JEditorPane jEditorPane) {
        jEditorPane.removeMouseListener(this.linkHandler);
        super.deinstall(jEditorPane);
    }

    public Action[] getActions() {
        return TextAction.augmentList(super.getActions(), defaultActions);
    }

    public String getContentType() {
        return "text/html";
    }

    protected Parser getParser() {
        block2: {
            if (defaultParser != null) break block2;
            try {
                Class clazz = Class.forName("javax.swing.text.html.parser.ParserDelegator");
                defaultParser = (Parser)clazz.newInstance();
            }
            catch (Throwable throwable) {}
        }
        return defaultParser;
    }

    public StyleSheet getStyleSheet() {
        block2: {
            if (defaultStyles != null) break block2;
            defaultStyles = new StyleSheet();
            try {
                InputStream inputStream = (class$javax$swing$text$html$HTMLEditorKit != null ? class$javax$swing$text$html$HTMLEditorKit : (class$javax$swing$text$html$HTMLEditorKit = HTMLEditorKit.class$("javax.swing.text.html.HTMLEditorKit"))).getResourceAsStream(DEFAULT_CSS);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                defaultStyles.loadRules(bufferedReader, null);
                ((Reader)bufferedReader).close();
            }
            catch (Throwable throwable) {}
        }
        return defaultStyles;
    }

    public ViewFactory getViewFactory() {
        return new HTMLFactory();
    }

    public void insertHTML(HTMLDocument hTMLDocument, int n, String string, int n2, int n3, HTML.Tag tag) throws BadLocationException, IOException {
        Parser parser = this.getParser();
        if (parser == null) {
            throw new IOException("Can't load parser");
        }
        if (n > hTMLDocument.getLength()) {
            throw new BadLocationException("Invalid location", n);
        }
        ParserCallback parserCallback = hTMLDocument.getReader(n, n2, n3, tag);
        Boolean bl = (Boolean)hTMLDocument.getProperty("IgnoreCharsetDirective");
        parser.parse(new StringReader(string), parserCallback, bl == null ? false : bl);
        parserCallback.flush();
    }

    public void install(JEditorPane jEditorPane) {
        jEditorPane.addMouseListener(this.linkHandler);
        super.install(jEditorPane);
    }

    public void read(Reader reader, Document document, int n) throws IOException, BadLocationException {
        if (document instanceof HTMLDocument) {
            HTMLDocument hTMLDocument = (HTMLDocument)document;
            Parser parser = this.getParser();
            if (parser == null) {
                throw new IOException("Can't load parser");
            }
            if (n > document.getLength()) {
                throw new BadLocationException("Invalid location", n);
            }
            ParserCallback parserCallback = hTMLDocument.getReader(n);
            Boolean bl = (Boolean)document.getProperty("IgnoreCharsetDirective");
            parser.parse(reader, parserCallback, bl == null ? false : bl);
            parserCallback.flush();
        } else {
            super.read(reader, document, n);
        }
    }

    public void setStyleSheet(StyleSheet styleSheet) {
        defaultStyles = styleSheet;
    }

    public void write(Writer writer, Document document, int n, int n2) throws IOException, BadLocationException {
        if (document instanceof HTMLDocument) {
            HTMLWriter hTMLWriter = new HTMLWriter(writer, (HTMLDocument)document, n, n2);
            hTMLWriter.write();
        } else if (document instanceof StyledDocument) {
            MinimalHTMLWriter minimalHTMLWriter = new MinimalHTMLWriter(writer, (StyledDocument)document, n, n2);
            minimalHTMLWriter.write();
        } else {
            super.write(writer, document, n, n2);
        }
    }

    public static class LinkController
    extends MouseAdapter
    implements Serializable {
        protected void activateLink(int n, JEditorPane jEditorPane) {
            Document document = jEditorPane.getDocument();
            if (document instanceof HTMLDocument) {
                String string;
                HTMLDocument hTMLDocument = (HTMLDocument)document;
                Element element = hTMLDocument.getCharacterElement(n);
                AttributeSet attributeSet = element.getAttributes();
                AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
                String string2 = string = attributeSet2 != null ? (String)attributeSet2.getAttribute(HTML.Attribute.HREF) : null;
                if (string != null) {
                    URL uRL;
                    try {
                        uRL = new URL(hTMLDocument.getBase(), string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        uRL = null;
                    }
                    HyperlinkEvent hyperlinkEvent = null;
                    if (!hTMLDocument.isFrameDocument()) {
                        hyperlinkEvent = new HyperlinkEvent(jEditorPane, HyperlinkEvent.EventType.ACTIVATED, uRL, string);
                    } else {
                        String string3 = (String)attributeSet2.getAttribute(HTML.Attribute.TARGET);
                        if (string3 == null || string3.equals("")) {
                            string3 = "_self";
                        }
                        hyperlinkEvent = new HTMLFrameHyperlinkEvent((Object)jEditorPane, HyperlinkEvent.EventType.ACTIVATED, uRL, string, string3);
                    }
                    jEditorPane.fireHyperlinkUpdate(hyperlinkEvent);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Point point;
            int n;
            JEditorPane jEditorPane = (JEditorPane)mouseEvent.getSource();
            if (!jEditorPane.isEditable() && (n = jEditorPane.viewToModel(point = new Point(mouseEvent.getX(), mouseEvent.getY()))) >= 0) {
                this.activateLink(n, jEditorPane);
            }
        }
    }

    public static abstract class Parser {
        public abstract void parse(Reader var1, ParserCallback var2, boolean var3) throws IOException;
    }

    public static class ParserCallback {
        public void flush() throws BadLocationException {
        }

        public void handleComment(char[] cArray, int n) {
        }

        public void handleEndTag(HTML.Tag tag, int n) {
        }

        public void handleError(String string, int n) {
        }

        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
        }

        public void handleStartTag(HTML.Tag tag, MutableAttributeSet mutableAttributeSet, int n) {
        }

        public void handleText(char[] cArray, int n) {
        }
    }

    public static class HTMLFactory
    implements ViewFactory {
        public View create(Element element) {
            Object object = element.getAttributes().getAttribute(StyleConstants.NameAttribute);
            if (object instanceof HTML.Tag) {
                HTML.Tag tag = (HTML.Tag)object;
                if (tag == HTML.Tag.CONTENT) {
                    return new InlineView(element);
                }
                if (tag == HTML.Tag.IMPLIED) {
                    String string = (String)element.getAttributes().getAttribute(CSS.Attribute.WHITE_SPACE);
                    if (string != null && string.equals("pre")) {
                        return new LineView(element);
                    }
                    return new ParagraphView(element);
                }
                if (tag == HTML.Tag.P || tag == HTML.Tag.H1 || tag == HTML.Tag.H2 || tag == HTML.Tag.H3 || tag == HTML.Tag.H4 || tag == HTML.Tag.H5 || tag == HTML.Tag.H6 || tag == HTML.Tag.DT) {
                    return new ParagraphView(element);
                }
                if (tag == HTML.Tag.MENU || tag == HTML.Tag.DIR || tag == HTML.Tag.UL || tag == HTML.Tag.OL) {
                    return new ListView(element);
                }
                if (tag == HTML.Tag.LI || tag == HTML.Tag.CENTER || tag == HTML.Tag.DL || tag == HTML.Tag.DD || tag == HTML.Tag.BODY || tag == HTML.Tag.HTML || tag == HTML.Tag.DIV || tag == HTML.Tag.BLOCKQUOTE || tag == HTML.Tag.PRE) {
                    return new BlockView(element, 1);
                }
                if (tag == HTML.Tag.NOFRAMES) {
                    return new NoFramesView(element, 1);
                }
                if (tag == HTML.Tag.IMG) {
                    return new ImageView(element);
                }
                if (tag == HTML.Tag.ISINDEX) {
                    return new IsindexView(element);
                }
                if (tag == HTML.Tag.HR) {
                    return new HRuleView(element);
                }
                if (tag == HTML.Tag.BR) {
                    return new BRView(element);
                }
                if (tag == HTML.Tag.TABLE) {
                    return new TableView(element);
                }
                if (tag == HTML.Tag.INPUT || tag == HTML.Tag.SELECT || tag == HTML.Tag.TEXTAREA) {
                    return new FormView(element);
                }
                if (tag == HTML.Tag.OBJECT) {
                    return new ObjectView(element);
                }
                if (tag == HTML.Tag.FRAMESET) {
                    if (element.getAttributes().isDefined(HTML.Attribute.ROWS)) {
                        return new FrameSetView(element, 1);
                    }
                    if (element.getAttributes().isDefined(HTML.Attribute.COLS)) {
                        return new FrameSetView(element, 0);
                    }
                    throw new Error("Can't build a" + tag + ", " + element + ":" + "no ROWS or COLS defined.");
                }
                if (tag == HTML.Tag.FRAME) {
                    return new FrameView(element);
                }
                if (tag instanceof HTML.UnknownTag) {
                    return new HiddenTagView(element);
                }
                if (tag == HTML.Tag.COMMENT) {
                    return new CommentView(element);
                }
                if (tag == HTML.Tag.HEAD || tag == HTML.Tag.TITLE || tag == HTML.Tag.META || tag == HTML.Tag.LINK || tag == HTML.Tag.STYLE || tag == HTML.Tag.SCRIPT || tag == HTML.Tag.AREA || tag == HTML.Tag.MAP || tag == HTML.Tag.PARAM || tag == HTML.Tag.APPLET) {
                    return new HiddenTagView(element);
                }
                throw new Error("Can't build a " + tag + ", " + element);
            }
            throw new Error("Can't build a " + element);
        }
    }

    public static abstract class HTMLTextAction
    extends StyledEditorKit.StyledTextAction {
        public HTMLTextAction(String string) {
            super(string);
        }

        protected int elementCountToTag(HTMLDocument hTMLDocument, int n, HTML.Tag tag) {
            int n2 = -1;
            Element element = hTMLDocument.getCharacterElement(n);
            while (element != null && element.getAttributes().getAttribute(StyleConstants.NameAttribute) != tag) {
                element = element.getParentElement();
                ++n2;
            }
            if (element == null) {
                return -1;
            }
            return n2;
        }

        protected Element findElementMatchingTag(HTMLDocument hTMLDocument, int n, HTML.Tag tag) {
            Element element = hTMLDocument.getDefaultRootElement();
            Element element2 = null;
            while (element != null) {
                if (element.getAttributes().getAttribute(StyleConstants.NameAttribute) == tag) {
                    element2 = element;
                }
                element = element.getElement(element.getElementIndex(n));
            }
            return element2;
        }

        private Element[] getElementsAt(Element element, int n, int n2) {
            if (element.isLeaf()) {
                Element[] elementArray = new Element[n2 + 1];
                elementArray[n2] = element;
                return elementArray;
            }
            Element[] elementArray = this.getElementsAt(element.getElement(element.getElementIndex(n)), n, n2 + 1);
            elementArray[n2] = element;
            return elementArray;
        }

        protected Element[] getElementsAt(HTMLDocument hTMLDocument, int n) {
            return this.getElementsAt(hTMLDocument.getDefaultRootElement(), n, 0);
        }

        protected HTMLDocument getHTMLDocument(JEditorPane jEditorPane) {
            Document document = jEditorPane.getDocument();
            if (document instanceof HTMLDocument) {
                return (HTMLDocument)document;
            }
            throw new IllegalArgumentException("document must be HTMLDocument");
        }

        protected HTMLEditorKit getHTMLEditorKit(JEditorPane jEditorPane) {
            EditorKit editorKit = jEditorPane.getEditorKit();
            if (editorKit instanceof HTMLEditorKit) {
                return (HTMLEditorKit)editorKit;
            }
            throw new IllegalArgumentException("EditorKit must be HTMLEditorKit");
        }
    }

    public static class InsertHTMLTextAction
    extends HTMLTextAction {
        protected String html;
        protected HTML.Tag parentTag;
        protected HTML.Tag addTag;
        protected HTML.Tag alternateParentTag;
        protected HTML.Tag alternateAddTag;

        public InsertHTMLTextAction(String string, String string2, HTML.Tag tag, HTML.Tag tag2) {
            this(string, string2, tag, tag2, null, null);
        }

        public InsertHTMLTextAction(String string, String string2, HTML.Tag tag, HTML.Tag tag2, HTML.Tag tag3, HTML.Tag tag4) {
            super(string);
            this.html = string2;
            this.parentTag = tag;
            this.addTag = tag2;
            this.alternateParentTag = tag3;
            this.alternateAddTag = tag4;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JEditorPane jEditorPane = this.getEditor(actionEvent);
            if (jEditorPane != null) {
                int n;
                HTMLDocument hTMLDocument = this.getHTMLDocument(jEditorPane);
                Element element = this.findElementMatchingTag(hTMLDocument, n = jEditorPane.getSelectionStart(), this.parentTag);
                if (element != null && element.getStartOffset() == n) {
                    this.insertAtBoundry(jEditorPane, hTMLDocument, n, element, this.html, this.parentTag, this.addTag);
                } else {
                    int n2 = this.elementCountToTag(hTMLDocument, n - 1, this.parentTag);
                    if (n2 != -1) {
                        this.insertHTML(jEditorPane, hTMLDocument, n, this.html, n2, 0, this.addTag);
                    } else if (this.alternateParentTag != null && (n2 = this.elementCountToTag(hTMLDocument, n - 1, this.alternateParentTag)) != -1) {
                        this.insertHTML(jEditorPane, hTMLDocument, n, this.html, n2, 0, this.alternateAddTag);
                    }
                }
            }
        }

        protected void insertAtBoundry(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, Element element, String string, HTML.Tag tag, HTML.Tag tag2) {
            Element element2 = hTMLDocument.getDefaultRootElement();
            while (element2 != null && element2.getStartOffset() != n && !element2.isLeaf()) {
                element2 = element2.getElement(element2.getElementIndex(n));
            }
            if (element2 != null) {
                Element element3 = element2 = element2.getParentElement();
                int n2 = 0;
                --n;
                while (element2 != null && !element2.isLeaf()) {
                    element2 = element2.getElement(element2.getElementIndex(n));
                    ++n2;
                }
                n2 = Math.max(0, n2 - 1);
                int n3 = 0;
                element2 = element3;
                ++n;
                while (element2 != null && element2 != element) {
                    element2 = element2.getElement(element2.getElementIndex(n));
                    ++n3;
                }
                this.insertHTML(jEditorPane, hTMLDocument, n, string, n2, n3, tag2);
            }
        }

        protected void insertHTML(JEditorPane jEditorPane, HTMLDocument hTMLDocument, int n, String string, int n2, int n3, HTML.Tag tag) {
            try {
                this.getHTMLEditorKit(jEditorPane).insertHTML(hTMLDocument, n, string, n2, n3, tag);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to insert: " + iOException);
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException("Unable to insert: " + badLocationException);
            }
        }
    }
}

