/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import sun.applet.AppletMessageHandler;
import sun.applet.AppletThreadGroup;

public class AppletClassLoader
extends URLClassLoader {
    private URL base;
    private CodeSource codesource;
    private AccessControlContext acc;
    private AppletThreadGroup threadGroup;
    private static AppletMessageHandler mh = new AppletMessageHandler("appletclassloader");

    protected AppletClassLoader(URL uRL) {
        super(new URL[0]);
        this.base = uRL;
        this.codesource = new CodeSource(uRL, null);
        this.acc = AccessController.getContext();
    }

    void addJar(String string) {
        URL uRL;
        try {
            uRL = new URL(this.base, string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("name");
        }
        this.addURL(uRL);
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        try {
            return super.findClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            final String string2 = string.replace('.', '/').concat(".class");
            try {
                byte[] byArray = (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return AppletClassLoader.getBytes(new URL(base, string2));
                    }
                }, this.acc);
                if (byArray != null) {
                    return this.defineClass(string, byArray, 0, byArray.length, this.codesource);
                }
                throw new ClassNotFoundException(string);
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new ClassNotFoundException(string, privilegedActionException.getException());
            }
        }
    }

    public URL findResource(String string) {
        URL uRL;
        block3: {
            uRL = super.findResource(string);
            if (uRL != null) break block3;
            try {
                uRL = new URL(this.base, string);
                if (!this.resourceExists(uRL)) {
                    uRL = null;
                }
            }
            catch (Exception exception) {
                uRL = null;
            }
        }
        return uRL;
    }

    public Enumeration findResources(String string) throws IOException {
        URL uRL;
        try {
            uRL = new URL(this.base, string);
            uRL.openConnection().connect();
        }
        catch (IOException iOException) {
            uRL = null;
        }
        final Enumeration enumeration = super.findResources(string);
        final URL uRL2 = uRL;
        return new Enumeration(){
            private boolean done;

            public boolean hasMoreElements() {
                return !this.done && (enumeration.hasMoreElements() || uRL2 != null);
            }

            public Object nextElement() {
                if (!this.done) {
                    if (enumeration.hasMoreElements()) {
                        return enumeration.nextElement();
                    }
                    this.done = true;
                    if (uRL2 != null) {
                        return uRL2;
                    }
                }
                throw new NoSuchElementException();
            }
        };
    }

    URL getBaseURL() {
        return this.base;
    }

    private static byte[] getBytes(URL uRL) throws IOException {
        byte[] byArray;
        InputStream inputStream;
        block6: {
            URLConnection uRLConnection = uRL.openConnection();
            int n = uRLConnection.getContentLength();
            inputStream = uRLConnection.getInputStream();
            try {
                byte[] byArray2;
                if (n != -1) {
                    byArray = new byte[n];
                    while (n > 0) {
                        int n2 = inputStream.read(byArray, byArray.length - n, n);
                        if (n2 == -1) {
                            throw new IOException("unexpected EOF");
                        }
                        n -= n2;
                    }
                    break block6;
                }
                byArray = new byte[1024];
                int n3 = 0;
                while ((n = inputStream.read(byArray, n3, byArray.length - n3)) != -1) {
                    if ((n3 += n) < byArray.length) continue;
                    byArray2 = new byte[n3 * 2];
                    System.arraycopy(byArray, 0, byArray2, 0, n3);
                    byArray = byArray2;
                }
                if (n3 == byArray.length) break block6;
                byArray2 = new byte[n3];
                System.arraycopy(byArray, 0, byArray2, 0, n3);
                byArray = byArray2;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                inputStream.close();
                throw throwable;
            }
        }
        Object var6_8 = null;
        inputStream.close();
        return byArray;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        final PermissionCollection permissionCollection = super.getPermissions(codeSource);
        URL uRL = codeSource.getLocation();
        if (uRL.getProtocol().equals("file")) {
            int n;
            String string = uRL.getFile().replace('/', File.separatorChar);
            if (!string.endsWith(File.separator) && (n = string.lastIndexOf(File.separatorChar)) != -1) {
                string = String.valueOf(string.substring(0, n + 1)) + "-";
                permissionCollection.add(new FilePermission(string, "read"));
            }
            permissionCollection.add(new SocketPermission("localhost", "connect,accept"));
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        String string = InetAddress.getLocalHost().getHostName();
                        permissionCollection.add(new SocketPermission(string, "connect,accept"));
                    }
                    catch (UnknownHostException unknownHostException) {}
                    return null;
                }
            });
            if (this.base.getProtocol().equals("file")) {
                String string2 = this.base.getFile().replace('/', File.separatorChar);
                if (string2.endsWith(File.separator)) {
                    string2 = String.valueOf(string2) + "-";
                }
                permissionCollection.add(new FilePermission(string2, "read"));
            }
        }
        return permissionCollection;
    }

    synchronized ThreadGroup getThreadGroup() {
        if (this.threadGroup == null || this.threadGroup.isDestroyed()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    AppletClassLoader.this.threadGroup = new AppletThreadGroup(String.valueOf(String.valueOf(AppletClassLoader.this.base)) + "-threadGroup");
                    AppletClassLoader.this.threadGroup.setDaemon(true);
                    return null;
                }
            });
        }
        return this.threadGroup;
    }

    public URL[] getURLs() {
        URL[] uRLArray = super.getURLs();
        URL[] uRLArray2 = new URL[uRLArray.length + 1];
        System.arraycopy(uRLArray, 0, uRLArray2, 0, uRLArray.length);
        uRLArray2[uRLArray2.length - 1] = this.base;
        return uRLArray2;
    }

    public synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        SecurityManager securityManager;
        int n = string.lastIndexOf(46);
        if (n != -1 && (securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPackageAccess(string.substring(0, n));
        }
        try {
            return super.loadClass(string, bl);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Error error) {
            throw error;
        }
    }

    Class loadCode(String string) throws ClassNotFoundException {
        string = string.replace('/', '.');
        String string2 = string = string.replace(File.separatorChar, '.');
        if (string.endsWith(".class") || string.endsWith(".java")) {
            string = string.substring(0, string.lastIndexOf(46));
        }
        try {
            return this.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return this.loadClass(string2);
        }
    }

    private static void printError(String string, Throwable throwable) {
        String string2 = null;
        if (throwable == null) {
            string2 = mh.getMessage("filenotfound", string);
        } else if (throwable instanceof IOException) {
            string2 = mh.getMessage("fileioexception", string);
        } else if (throwable instanceof ClassFormatError) {
            string2 = mh.getMessage("fileformat", string);
        } else if (throwable instanceof ThreadDeath) {
            string2 = mh.getMessage("filedeath", string);
        } else if (throwable instanceof Error) {
            string2 = mh.getMessage("fileerror", throwable.toString(), string);
        }
        if (string2 != null) {
            System.err.println(string2);
        }
    }

    private boolean resourceExists(URL uRL) {
        boolean bl = true;
        try {
            URLConnection uRLConnection = uRL.openConnection();
            if (uRLConnection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                int n = httpURLConnection.getResponseCode();
                if (n == 200) {
                    return true;
                }
                if (n >= 400) {
                    return false;
                }
            } else {
                InputStream inputStream = uRL.openStream();
                inputStream.close();
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }
}

