/*
 * Decompiled with CFR 0.152.
 */
package sun.audio;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import sun.audio.AudioContainerInputStream;
import sun.audio.AudioFormat;
import sun.audio.BadAudioHeaderException;

class AudioAiffInputStream
extends AudioContainerInputStream {
    private boolean DEBUG = false;

    AudioAiffInputStream(byte[] byArray, InputStream inputStream) throws IOException, BadAudioHeaderException {
        super(byArray, inputStream);
    }

    protected AudioFormat readFormat(byte[] byArray) throws BadAudioHeaderException, IOException {
        boolean bl;
        int n = -1;
        int n2 = -1;
        String string = null;
        int n3 = -1;
        int n4 = 1;
        int n5 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        byte[] byArray2 = new byte[4];
        short s = 0;
        DataInputStream dataInputStream = byArray == null ? new DataInputStream(this.in) : new DataInputStream(new SequenceInputStream(new ByteArrayInputStream(byArray), this.in));
        int n6 = dataInputStream.readInt();
        n5 += 4;
        boolean bl4 = true;
        this.totalBytes = dataInputStream.readInt();
        n5 += 4;
        dataInputStream.read(byArray2, 0, 4);
        n5 += 4;
        String string2 = new String(byArray2);
        if (string2.startsWith("AIFC")) {
            bl3 = true;
        }
        if (this.DEBUG) {
            System.err.println("This a " + (bl3 ? "AIFF-C" : "AIFF") + " stream.");
        }
        while (true) {
            int n7;
            dataInputStream.read(byArray2, 0, 4);
            n5 += 4;
            string2 = new String(byArray2);
            if (this.DEBUG) {
                System.err.println("Read a new AIFF chunk: \"" + string2 + "\"");
            }
            if (string2.startsWith("FVER")) {
                dataInputStream.readLong();
                n5 += 8;
                continue;
            }
            if (string2.startsWith("COMM")) {
                n7 = dataInputStream.readInt();
                n5 += 4;
                if (n7 != 18 && n7 != 34) {
                    throw new BadAudioHeaderException("Invalid chunksize");
                }
                n2 = dataInputStream.readShort();
                n5 += 2;
                dataInputStream.readInt();
                n5 += 4;
                s = dataInputStream.readShort();
                n5 += 2;
                n = (int)this.read_ieee_extended(dataInputStream);
                n5 += 10;
                string = "JAUDIO_LINEAR";
                if (!bl3) continue;
                dataInputStream.read(byArray2, 0, 4);
                n5 += 4;
                string2 = new String(byArray2);
                if (string2.startsWith("NONE")) {
                    string = "JAUDIO_LINEAR";
                    continue;
                }
                if (string2.startsWith("G722")) {
                    string = "JAUDIO_G722";
                    continue;
                }
                if (string2.startsWith("ULAW")) {
                    string = "JAUDIO_G711_ULAW";
                    continue;
                }
                if (string2.startsWith("ALAW")) {
                    string = "JAUDIO_G711_ALAW";
                    continue;
                }
                throw new BadAudioHeaderException("Unknown encoding");
            }
            if (string2.startsWith("SSND")) {
                n7 = dataInputStream.readInt();
                n5 += 4;
                int n8 = dataInputStream.readInt();
                n5 += 4;
                int bl5 = dataInputStream.readInt();
                n5 += 4;
                if (n7 < this.totalBytes) {
                    this.totalBytes = n7;
                    break;
                }
                this.totalBytes -= n5;
                break;
            }
            n7 = dataInputStream.readInt();
            n5 += 4;
            n5 += dataInputStream.skipBytes(n7);
        }
        boolean bl6 = true;
        switch (s) {
            case 8: {
                n3 = 1;
                if (string != "JAUDIO_LINEAR") break;
                bl = false;
                break;
            }
            case 16: {
                n3 = 2;
                break;
            }
        }
        this.headerSize = n5;
        return new AudioFormat(n, string, n3, n4, n2, bl4, bl);
    }

    private double read_ieee_extended(DataInputStream dataInputStream) throws IOException {
        double d = 0.0;
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        double d2 = 3.4028234663852886E38;
        n = dataInputStream.readUnsignedShort();
        long l3 = dataInputStream.readUnsignedShort();
        long l4 = dataInputStream.readUnsignedShort();
        l = l3 << 16 | l4;
        l3 = dataInputStream.readUnsignedShort();
        l4 = dataInputStream.readUnsignedShort();
        l2 = l3 << 16 | l4;
        if (n == 0 && l == 0L && l2 == 0L) {
            d = 0.0;
        } else if (n == Short.MAX_VALUE) {
            d = d2;
        } else {
            n -= 16383;
            d = (double)l * Math.pow(2.0, n -= 31);
            d += (double)l2 * Math.pow(2.0, n -= 32);
        }
        return d;
    }
}

