/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import java.awt.Shape;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;

public class AffineTransform {
    protected double m00;
    protected double m10;
    protected double m01;
    protected double m11;
    protected double m02;
    protected double m12;
    private int fAccelerator = 0;
    private int fRotateAccelerator = 0;
    private static final double k90DegreeInRadians = 1.5707963267948966;
    private static final double k180DegreeInRadians = Math.PI;
    private static final double k270DegreeInRadians = 4.71238898038469;
    private static final double k360DegreeInRadians = Math.PI * 2;
    protected static final int TYPE_IDENTITY = 0;
    protected static final int TYPE_ROTATE = 1;
    protected static final int TYPE_TRANSLATE = 2;
    protected static final int TYPE_SCALE = 3;
    protected static final int TYPE_AFFINE = 4;
    protected static final int ROTATE_0 = 0;
    protected static final int ROTATE_90 = 1;
    protected static final int ROTATE_180 = 2;
    protected static final int ROTATE_270 = 3;
    protected static final int ROTATE_SLOW = 4;
    public static final int ELEMENT_SCALE_X = 0;
    public static final int ELEMENT_SHEAR_Y = 1;
    public static final int ELEMENT_SHEAR_X = 2;
    public static final int ELEMENT_SCALE_Y = 3;
    public static final int ELEMENT_TRANSLATE_X = 4;
    public static final int ELEMENT_TRANSLATE_Y = 5;
    protected static final int kAngle = 0;
    protected static final int kSin = 1;
    protected static final int kCos = 2;
    protected static final int kCenterX = 3;
    protected static final int kCenterY = 4;

    public AffineTransform() {
        this.m11 = 1.0;
        this.m00 = 1.0;
    }

    public AffineTransform(double d, double d2, double d3, double d4, double d5, double d6) {
        this.m00 = d;
        this.m10 = d2;
        this.m01 = d3;
        this.m11 = d4;
        this.m02 = d5;
        this.m12 = d6;
        this.fAccelerator = this.GetAccelerator();
        if (this.fAccelerator != 0 || this.fAccelerator != 2) {
            this.fRotateAccelerator = 4;
        }
    }

    public AffineTransform(float f, float f2, float f3, float f4, float f5, float f6) {
        this.m00 = f;
        this.m10 = f2;
        this.m01 = f3;
        this.m11 = f4;
        this.m02 = f5;
        this.m12 = f6;
        this.fAccelerator = this.GetAccelerator();
        if (this.fAccelerator != 0 || this.fAccelerator != 2) {
            this.fRotateAccelerator = 4;
        }
    }

    public AffineTransform(java.awt.geom.AffineTransform affineTransform) {
        this(AffineTransform.extractMatrix(affineTransform));
    }

    protected AffineTransform(AffineTransform affineTransform) {
        this(affineTransform.m00, affineTransform.m10, affineTransform.m01, affineTransform.m11, affineTransform.m02, affineTransform.m12);
    }

    public AffineTransform(double[] dArray) {
        this.m00 = dArray[0];
        this.m10 = dArray[1];
        this.m01 = dArray[2];
        this.m11 = dArray[3];
        if (dArray.length > 4) {
            this.m02 = dArray[4];
            this.m12 = dArray[5];
        }
        this.fAccelerator = this.GetAccelerator();
        if (this.fAccelerator != 0 || this.fAccelerator != 2) {
            this.fRotateAccelerator = 4;
        }
    }

    public AffineTransform(float[] fArray) {
        this.m00 = fArray[0];
        this.m10 = fArray[1];
        this.m01 = fArray[2];
        this.m11 = fArray[3];
        if (fArray.length > 4) {
            this.m02 = fArray[4];
            this.m12 = fArray[5];
        }
        this.fAccelerator = this.GetAccelerator();
        if (this.fAccelerator != 0 || this.fAccelerator != 2) {
            this.fRotateAccelerator = 4;
        }
    }

    public AffineTransform(double[][] dArray) {
        this.m00 = dArray[0][0];
        this.m10 = dArray[1][0];
        this.m01 = dArray[0][1];
        this.m11 = dArray[1][1];
        if (dArray.length > 2) {
            this.m02 = dArray[0][2];
            this.m12 = dArray[1][2];
        }
        this.fAccelerator = this.GetAccelerator();
        if (this.fAccelerator != 0 || this.fAccelerator != 2) {
            this.fRotateAccelerator = 4;
        }
    }

    public AffineTransform(float[][] fArray) {
        this.m00 = fArray[0][0];
        this.m10 = fArray[1][0];
        this.m01 = fArray[0][1];
        this.m11 = fArray[1][1];
        if (fArray.length > 2) {
            this.m02 = fArray[0][2];
            this.m12 = fArray[1][2];
        }
        this.fAccelerator = this.GetAccelerator();
        if (this.fAccelerator != 0 || this.fAccelerator != 2) {
            this.fRotateAccelerator = 4;
        }
    }

    private void ComputeCosAndSin() {
        double d = this.m01;
        double d2 = 0.0;
        double d3 = 0.0;
        if (d == 0.0) {
            d2 = 1.0;
        } else if (d == 1.5707963267948966) {
            d3 = 1.0;
        } else if (d == Math.PI) {
            d2 = -1.0;
        } else if (d == 4.71238898038469) {
            d3 = -1.0;
        } else {
            d2 = Math.cos(d);
            d3 = Math.sin(d);
        }
        this.m11 = d2;
        this.m10 = d3;
    }

    private double FirstCycle(double d) {
        if ((d = Math.IEEEremainder(d, Math.PI * 2)) < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    private int GetAccelerator() {
        if (this.m01 != 0.0 || this.m10 != 0.0) {
            return 4;
        }
        if (this.m00 != 1.0 || this.m11 != 1.0) {
            return 3;
        }
        if (this.m02 != 0.0 || this.m12 != 0.0) {
            return 2;
        }
        return 0;
    }

    private int GetFastRotate(double d) {
        if (d == 0.0) {
            return 0;
        }
        if (d == 1.5707963267948966) {
            return 1;
        }
        if (d == Math.PI) {
            return 2;
        }
        if (d == 4.71238898038469) {
            return 3;
        }
        return 4;
    }

    private void InternalSetToIdentity() {
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m12 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
        this.m10 = 0.0;
    }

    private void PostMatrixMult(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = this.m00;
        this.m00 = d7 * d + this.m10 * d3;
        this.m10 = d7 * d2 + this.m10 * d4;
        d7 = this.m01;
        this.m01 = d7 * d + this.m11 * d3;
        this.m11 = d7 * d2 + this.m11 * d4;
        d7 = this.m02;
        this.m02 = d7 * d + this.m12 * d3 + d5;
        this.m12 = d7 * d2 + this.m12 * d4 + d6;
    }

    private void PreMatrixMult(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = this.m01;
        this.m02 += d5 * this.m00 + d6 * d7;
        this.m01 = d3 * this.m00 + d4 * d7;
        this.m00 = d * this.m00 + d2 * d7;
        d7 = this.m11;
        this.m12 += d5 * this.m10 + d6 * d7;
        this.m11 = d3 * this.m10 + d4 * d7;
        this.m10 = d * this.m10 + d2 * d7;
    }

    private void RotateToAffine(int n) {
        double d = this.m02;
        double d2 = this.m12;
        double d3 = 1.0;
        double d4 = 0.0;
        switch (n) {
            case 1: {
                d3 = 0.0;
                d4 = 1.0;
                break;
            }
            case 2: {
                d3 = -1.0;
                d4 = 0.0;
                break;
            }
            case 3: {
                d3 = 0.0;
                d4 = -1.0;
                break;
            }
            case 4: {
                d3 = this.m11;
                d4 = this.m10;
            }
        }
        this.m00 = d3;
        this.m10 = d4;
        this.m01 = -d4;
        this.m11 = d3;
        this.m02 = -d * (d3 - 1.0) + d2 * d4;
        this.m12 = -d * d4 - d2 * (d3 - 1.0);
    }

    private static double _matround(double d) {
        return Math.rint(d * 1.0E15) / 1.0E15;
    }

    public void append(AffineTransform affineTransform) {
        this.concatenate(affineTransform);
    }

    public Object clone() {
        return new AffineTransform(this.m00, this.m10, this.m01, this.m11, this.m02, this.m12);
    }

    public void concatenate(AffineTransform affineTransform) {
        if (affineTransform.fAccelerator == 0) {
            return;
        }
        if (this.fAccelerator == 0) {
            this.fAccelerator = affineTransform.fAccelerator;
            if (this.fAccelerator != 2) {
                this.m00 = affineTransform.m00;
                this.m10 = affineTransform.m10;
                this.m01 = affineTransform.m01;
                this.m11 = affineTransform.m11;
            }
            this.m02 = affineTransform.m02;
            this.m12 = affineTransform.m12;
            this.fRotateAccelerator = affineTransform.fRotateAccelerator;
            return;
        }
        if (this.fAccelerator == 2 && affineTransform.fAccelerator == 2) {
            this.m02 += affineTransform.m02;
            this.m12 += affineTransform.m12;
        }
        if (affineTransform.fAccelerator == 1) {
            if (this.fAccelerator == 1) {
                if (this.m02 == affineTransform.m02 && this.m12 == affineTransform.m12) {
                    this.m01 = this.FirstCycle(this.m01 + affineTransform.m01);
                    this.fRotateAccelerator = this.GetFastRotate(this.m01);
                    if (this.fRotateAccelerator != 0) {
                        this.ComputeCosAndSin();
                    } else {
                        this.fAccelerator = 0;
                    }
                    return;
                }
                this.RotateToAffine(this.fRotateAccelerator);
            }
            double[] dArray = new double[6];
            affineTransform.getMatrix(dArray);
            this.PreMatrixMult(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
            this.fAccelerator = this.GetAccelerator();
            return;
        }
        if (affineTransform.fAccelerator == 2) {
            this.translate(affineTransform.m02, affineTransform.m12);
            return;
        }
        if (this.fAccelerator == 1) {
            this.RotateToAffine(this.fRotateAccelerator);
        }
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        this.PreMatrixMult(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
        this.fAccelerator = this.GetAccelerator();
    }

    public AffineTransform createInverse() throws NoninvertibleTransformException {
        AffineTransform affineTransform = new AffineTransform(this.m00, this.m10, this.m01, this.m11, this.m02, this.m12);
        affineTransform.invert();
        return affineTransform;
    }

    public Shape createTransformedShape(Shape shape) {
        throw new NoSuchMethodError("Not implemented yet");
    }

    public boolean equals(AffineTransform affineTransform) {
        if (this.fAccelerator == affineTransform.fAccelerator) {
            switch (this.fAccelerator) {
                case 0: {
                    return true;
                }
                case 2: {
                    return this.m02 == affineTransform.m02 && this.m12 == affineTransform.m12;
                }
                case 1: {
                    return this.m01 == affineTransform.m01 && this.m02 == affineTransform.m02 && this.m12 == affineTransform.m12;
                }
            }
        }
        return this.m00 == affineTransform.m00 && this.m10 == affineTransform.m10 && this.m01 == affineTransform.m01 && this.m11 == affineTransform.m11 && this.m02 == affineTransform.m02 && this.m12 == affineTransform.m12;
    }

    static double[] extractMatrix(java.awt.geom.AffineTransform affineTransform) {
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        return dArray;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Enabled aggressive block sorting
     */
    public double getElement(int n) {
        if (this.fAccelerator == 1) {
            switch (n) {
                case 0: {
                    return this.m11;
                }
                case 1: {
                    return this.m10;
                }
                case 2: {
                    return -this.m10;
                }
                case 3: {
                    return this.m11;
                }
                case 4: {
                    if (this.m02 == 0.0) {
                        return 0.0;
                    }
                    double d = -this.m02 * (this.m11 - 1.0) + this.m12 * this.m10;
                    return d;
                }
                case 5: {
                    if (this.m12 == 0.0) {
                        return 0.0;
                    }
                    double d = -this.m02 * this.m10 - this.m12 * (this.m11 - 1.0);
                    return d;
                }
                default: {
                    throw new IndexOutOfBoundsException("AffineTransform getElement index out of range");
                }
            }
        }
        switch (n) {
            case 0: {
                return this.m00;
            }
            case 1: {
                return this.m10;
            }
            case 2: {
                return this.m01;
            }
            case 3: {
                return this.m11;
            }
            case 4: {
                return this.m02;
            }
            case 5: {
                return this.m12;
            }
        }
        throw new IndexOutOfBoundsException("AffineTransform getElement index out of range");
    }

    public void getMatrix(double[] dArray) {
        dArray[0] = this.m00;
        dArray[1] = this.m10;
        if (this.fAccelerator == 1) {
            dArray[0] = this.m00;
            dArray[1] = this.m10;
            dArray[2] = -this.m10;
            dArray[3] = this.m00;
            if (dArray.length > 4) {
                dArray[4] = this.m02 == 0.0 ? 0.0 : -this.m02 * (this.m00 - 1.0) + this.m12 * this.m10;
                dArray[5] = this.m12 == 0.0 ? 0.0 : -this.m02 * this.m10 - this.m12 * (this.m00 - 1.0);
            }
        } else {
            dArray[2] = this.m01;
            dArray[3] = this.m11;
            if (dArray.length > 4) {
                dArray[4] = this.m02;
                dArray[5] = this.m12;
            }
        }
    }

    public void getMatrix(double[][] dArray) {
        dArray[0][0] = this.m00;
        dArray[1][0] = this.m10;
        if (this.fAccelerator == 1) {
            dArray[0][1] = -this.m10;
            dArray[1][1] = this.m00;
            dArray[0][2] = this.m02 == 0.0 ? 0.0 : -this.m02 * (this.m00 - 1.0) + this.m12 * this.m10;
            dArray[1][2] = this.m12 == 0.0 ? 0.0 : -this.m02 * this.m10 - this.m12 * (this.m00 - 1.0);
        } else {
            dArray[0][1] = this.m01;
            dArray[1][1] = this.m11;
            dArray[0][2] = this.m02;
            dArray[1][2] = this.m12;
        }
    }

    protected int getRotateType() {
        return this.fRotateAccelerator;
    }

    protected double getRotationElement(int n) {
        if (this.fAccelerator == 1) {
            switch (n) {
                case 0: {
                    return this.m01;
                }
                case 1: {
                    return this.m10;
                }
                case 2: {
                    return this.m11;
                }
                case 3: {
                    return this.m02;
                }
                case 4: {
                    return this.m12;
                }
            }
        }
        throw new IndexOutOfBoundsException("AffineTransform getRotationElement index out of range");
    }

    protected int getTransformType() {
        return this.fAccelerator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Point2D inverseTransform(Point2D point2D, Point2D point2D2) throws NoninvertibleTransformException {
        if (point2D2 == null) {
            point2D2 = new Point2D.Float();
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        switch (this.fAccelerator) {
            case 0: {
                point2D2.setLocation(d, d2);
                return point2D2;
            }
            case 2: {
                point2D2.setLocation(d - this.m02, d2 - this.m12);
                return point2D2;
            }
            case 3: {
                if (this.m00 == 0.0 && this.m11 == 0.0) throw new NoninvertibleTransformException("inverseTransform(): Singular Scale Transform");
                point2D2.setLocation((d - this.m02) / this.m00, (d2 - this.m12) / this.m11);
                return point2D2;
            }
            case 1: {
                switch (this.fRotateAccelerator) {
                    case 0: {
                        point2D2.setLocation(d, d2);
                        return point2D2;
                    }
                    case 1: {
                        point2D2.setLocation(d2 + this.m02 - this.m12, -d + this.m02 + this.m12);
                        return point2D2;
                    }
                    case 2: {
                        point2D2.setLocation(-d + 2.0 * this.m02, -d2 + 2.0 * this.m12);
                        return point2D2;
                    }
                    case 3: {
                        point2D2.setLocation(-d2 + this.m02 + this.m12, d - this.m02 + this.m12);
                        return point2D2;
                    }
                    case 4: {
                        double d3 = this.m11;
                        double d4 = this.m10;
                        double d5 = 1.0 - d3;
                        double d6 = d;
                        point2D2.setLocation(d3 * d6 + d4 * d2 + this.m02 * d5 - this.m12 * d4, -d4 * d6 + d3 * d2 + this.m12 * d5 + this.m02 * d4);
                        return point2D2;
                    }
                    default: {
                        return point2D2;
                    }
                }
            }
            case 4: {
                double d7 = this.m00 * this.m11 - this.m01 * this.m10;
                if (d7 == 0.0) throw new NoninvertibleTransformException("inverseTransform(): Singular Affine Transform");
                point2D2.setLocation((this.m11 * (d - this.m02) - this.m01 * (d2 - this.m12)) / d7, (-this.m10 * (d - this.m02) + this.m00 * (d2 - this.m12)) / d7);
                return point2D2;
            }
        }
        return point2D2;
    }

    /*
     * Exception decompiling
     */
    public void inverseTransform(double[] var1_1, int var2_2, double[] var3_3, int var4_4, int var5_5) throws NoninvertibleTransformException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: First case is not immediately after switch.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:442)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void invert() throws NoninvertibleTransformException {
        switch (this.fAccelerator) {
            case 2: {
                this.m02 = -this.m02;
                this.m12 = -this.m12;
                break;
            }
            case 3: {
                if (this.m00 == 0.0 || this.m11 == 0.0) {
                    throw new NoninvertibleTransformException("Singular Scale Transform");
                }
                this.m02 /= -this.m00;
                this.m12 /= -this.m11;
                this.m00 = 1.0 / this.m00;
                this.m11 = 1.0 / this.m11;
                break;
            }
            case 1: {
                this.m01 = Math.PI * 2 - this.m01;
                this.m10 = -this.m10;
                if (this.fRotateAccelerator == 1) {
                    this.fRotateAccelerator = 3;
                    break;
                }
                if (this.fRotateAccelerator != 3) break;
                this.fRotateAccelerator = 1;
                break;
            }
            case 4: {
                double d = this.m00 * this.m11;
                double d2 = this.m01 * this.m10;
                if (d == d2) {
                    throw new NoninvertibleTransformException("Singular Affine Transform");
                }
                double d3 = Math.abs(d) > Math.abs(d2) ? d * (1.0 - d2 / d) : d2 * (d / d2 - 1.0);
                double d4 = this.m00 / d3;
                this.m00 = this.m11 / d3;
                this.m11 = d4;
                this.m01 /= -d3;
                this.m10 /= -d3;
                double d5 = this.m02;
                double d6 = this.m12;
                this.m02 = -d5 * this.m00 - d6 * this.m01;
                this.m12 = -d5 * this.m10 - d6 * this.m11;
                break;
            }
        }
    }

    public boolean isIdentity() {
        return this.fAccelerator == 0 || this.fAccelerator == 1 && this.getRotateType() == 0;
    }

    public boolean isRectilinear() {
        if (this.fAccelerator == 0 || this.fAccelerator == 2 || this.fAccelerator == 3 || this.fAccelerator == 1 && this.getRotateType() != 4) {
            return true;
        }
        return this.fAccelerator == 4 && (this.m01 == 0.0 && this.m10 == 0.0 || this.m00 == 0.0 && this.m11 == 0.0);
    }

    public boolean isTranslate() {
        return this.isIdentity() || this.fAccelerator == 2;
    }

    public boolean isTranslateOrScale() {
        return this.fAccelerator == 2 || this.fAccelerator == 3;
    }

    protected void preConcatenate(AffineTransform affineTransform) {
        if (affineTransform.fAccelerator == 0) {
            return;
        }
        if (this.fAccelerator == 0) {
            this.fAccelerator = affineTransform.fAccelerator;
            if (this.fAccelerator == 2) {
                this.m02 = affineTransform.m02;
                this.m12 = affineTransform.m12;
            } else {
                this.m00 = affineTransform.m00;
                this.m10 = affineTransform.m10;
                this.m01 = affineTransform.m01;
                this.m11 = affineTransform.m11;
                this.m02 = affineTransform.m02;
                this.m12 = affineTransform.m12;
            }
            this.fRotateAccelerator = affineTransform.fRotateAccelerator;
            return;
        }
        if (this.fAccelerator == 2 && affineTransform.fAccelerator == 2) {
            this.m02 += affineTransform.m02;
            this.m12 += affineTransform.m12;
            return;
        }
        if (affineTransform.fAccelerator == 1) {
            if (this.fAccelerator == 1) {
                if (this.m02 == affineTransform.m02 && this.m12 == affineTransform.m12) {
                    this.m01 += affineTransform.m01;
                    this.m01 = this.FirstCycle(this.m01);
                    this.fRotateAccelerator = this.GetFastRotate(this.m01);
                    if (this.fRotateAccelerator != 0) {
                        this.ComputeCosAndSin();
                    } else {
                        this.fAccelerator = 0;
                    }
                    return;
                }
                this.RotateToAffine(this.fRotateAccelerator);
            }
            double[] dArray = new double[6];
            affineTransform.getMatrix(dArray);
            this.PostMatrixMult(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
            this.fAccelerator = this.GetAccelerator();
            return;
        }
        if (this.fAccelerator == 1) {
            this.RotateToAffine(this.fRotateAccelerator);
            if (affineTransform.fAccelerator == 2) {
                this.m02 += affineTransform.m02;
                this.m12 += affineTransform.m12;
                this.fAccelerator = 4;
            } else {
                double[] dArray = new double[6];
                affineTransform.getMatrix(dArray);
                this.PostMatrixMult(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                this.fAccelerator = this.GetAccelerator();
            }
            return;
        }
        if (affineTransform.fAccelerator == 2) {
            this.m02 += affineTransform.m02;
            this.m12 += affineTransform.m12;
            if (this.fAccelerator != 2) {
                this.fAccelerator = this.GetAccelerator();
            }
            return;
        }
        this.PostMatrixMult(affineTransform.m00, affineTransform.m10, affineTransform.m01, affineTransform.m11, affineTransform.m02, affineTransform.m12);
        this.fAccelerator = this.GetAccelerator();
    }

    protected void preRotate(double d, double d2, double d3) {
        if ((d = this.FirstCycle(d)) == 0.0 || d == Math.PI * 2) {
            return;
        }
        switch (this.fAccelerator) {
            case 0: {
                this.fAccelerator = 1;
                this.m01 = d;
                this.m02 = d2;
                this.m12 = d3;
                this.fRotateAccelerator = this.GetFastRotate(d);
                this.ComputeCosAndSin();
                return;
            }
            case 1: {
                if (this.m02 == d2 && this.m12 == d3) {
                    this.m01 = this.FirstCycle(this.m01 + d);
                    this.fRotateAccelerator = this.GetFastRotate(this.m01);
                    if (this.fRotateAccelerator != 0) {
                        this.ComputeCosAndSin();
                    } else {
                        this.fAccelerator = 0;
                    }
                    return;
                }
                this.RotateToAffine(this.fRotateAccelerator);
                this.fAccelerator = this.GetAccelerator();
            }
            case 2: 
            case 3: 
            case 4: {
                double d4;
                double d5;
                double d6 = Math.cos(d);
                double d7 = Math.sin(d);
                if (d2 != 0.0 || d3 != 0.0) {
                    d5 = -d2 * (d6 - 1.0) + d3 * d7;
                    d4 = -d2 * d7 - d3 * (d6 - 1.0);
                } else {
                    d5 = 0.0;
                    d4 = 0.0;
                }
                this.PostMatrixMult(d6, d7, -d7, d6, d5, d4);
                this.fAccelerator = this.GetAccelerator();
                return;
            }
        }
    }

    protected void preScale(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = d3;
        if (d6 != 0.0) {
            d6 *= 1.0 - d;
        }
        if ((d5 = d4) != 0.0) {
            d5 *= 1.0 - d2;
        }
        switch (this.fAccelerator) {
            case 2: {
                d6 = d * this.m02;
                d5 = d2 * this.m12;
            }
            case 0: {
                this.InternalSetToIdentity();
                this.fAccelerator = 3;
                this.m00 = d;
                this.m11 = d2;
                this.m02 = d6;
                this.m12 = d5;
                return;
            }
            case 1: {
                this.RotateToAffine(this.fRotateAccelerator);
                this.fAccelerator = 4;
                break;
            }
            default: {
                this.m02 *= d;
                this.m12 *= d2;
            }
        }
        this.m00 *= d;
        this.m11 *= d2;
        if (this.fAccelerator == 3) {
            return;
        }
        this.m01 *= d;
        this.m10 *= d2;
    }

    protected void preTranslate(double d, double d2) {
        if (d != 0.0 || d2 != 0.0) {
            if (this.fAccelerator == 0) {
                this.m02 = d;
                this.m12 = d2;
                this.fAccelerator = 2;
                return;
            }
            if (this.fAccelerator == 1) {
                this.RotateToAffine(this.fRotateAccelerator);
                this.fAccelerator = 4;
            }
            this.m02 += d;
            this.m12 += d2;
        }
    }

    public void prepend(AffineTransform affineTransform) {
        this.preConcatenate(affineTransform);
    }

    public void rotate(double d) {
        this.rotate(d, 0.0, 0.0);
    }

    protected void rotate(double d, double d2, double d3) {
        if ((d = this.FirstCycle(d)) == 0.0 || d == Math.PI * 2) {
            switch (this.fAccelerator) {
                case 0: {
                    this.fAccelerator = 1;
                    this.m01 = this.FirstCycle(d);
                    this.m02 = d2;
                    this.m12 = d3;
                    this.fRotateAccelerator = this.GetFastRotate(this.m01);
                    this.ComputeCosAndSin();
                    return;
                }
                case 1: {
                    if (this.m02 == d2 && this.m12 == d3) {
                        this.m01 = this.FirstCycle(this.m01 + d);
                        this.fRotateAccelerator = this.GetFastRotate(this.m01);
                        if (this.fRotateAccelerator != 0) {
                            this.ComputeCosAndSin();
                        } else {
                            this.fAccelerator = 0;
                        }
                        return;
                    }
                    this.RotateToAffine(this.fRotateAccelerator);
                }
                case 2: 
                case 3: 
                case 4: {
                    double d4;
                    double d5;
                    double d6 = Math.cos(d);
                    double d7 = Math.sin(d);
                    if (d2 != 0.0 || d3 != 0.0) {
                        d5 = -d2 * (d6 - 1.0) + d3 * d7;
                        d4 = -d2 * d7 - d3 * (d6 - 1.0);
                    } else {
                        d5 = 0.0;
                        d4 = 0.0;
                    }
                    this.PreMatrixMult(d6, d7, -d7, d6, d5, d4);
                    this.fAccelerator = this.GetAccelerator();
                    return;
                }
            }
        }
    }

    public void scale(double d, double d2) {
        this.scale(d, d2, 0.0, 0.0);
    }

    protected void scale(double d, double d2, double d3, double d4) {
        double d5;
        double d6 = d3;
        if (d6 != 0.0) {
            d6 *= 1.0 - d;
        }
        if ((d5 = d4) != 0.0) {
            d5 *= 1.0 - d2;
        }
        switch (this.fAccelerator) {
            case 2: {
                d6 += this.m02;
                d5 += this.m12;
            }
            case 0: {
                this.fAccelerator = 3;
                this.InternalSetToIdentity();
                this.m00 = d;
                this.m11 = d2;
                this.m02 = d6;
                this.m12 = d5;
                return;
            }
            case 3: {
                this.m02 += d6 * this.m00;
                this.m12 += d5 * this.m11;
                this.m00 *= d;
                this.m11 *= d2;
                return;
            }
            case 1: {
                this.RotateToAffine(this.fRotateAccelerator);
                this.fAccelerator = 4;
            }
            case 4: {
                this.m02 += d6 * this.m00 + d5 * this.m01;
                this.m12 += d5 * this.m11 + d5 * this.m10;
                this.m00 *= d;
                this.m01 *= d2;
                this.m10 *= d;
                this.m11 *= d2;
                break;
            }
        }
    }

    public void setToIdentity() {
        this.InternalSetToIdentity();
        this.fAccelerator = 0;
    }

    public void setToRotation(double d) {
        this.setToRotation(d, 0.0, 0.0);
    }

    protected void setToRotation(double d, double d2, double d3) {
        this.InternalSetToIdentity();
        this.fAccelerator = 1;
        d = this.FirstCycle(d);
        this.fRotateAccelerator = this.GetFastRotate(d);
        if (this.fRotateAccelerator != 0) {
            this.m01 = d;
            this.m02 = d2;
            this.m12 = d3;
            this.ComputeCosAndSin();
        } else {
            this.fAccelerator = 0;
        }
    }

    public void setToScale(double d, double d2) {
        this.setToScale(d, d2, 0.0, 0.0);
    }

    protected void setToScale(double d, double d2, double d3, double d4) {
        this.InternalSetToIdentity();
        if (d != 1.0 || d2 != 1.0) {
            this.fAccelerator = 3;
            this.m00 = d;
            this.m11 = d2;
            this.m02 = d3 * (1.0 - d);
            this.m12 = d4 * (1.0 - d2);
        } else {
            this.fAccelerator = 0;
        }
    }

    public void setToTranslation(double d, double d2) {
        this.InternalSetToIdentity();
        if (d != 0.0 || d2 != 0.0) {
            this.fAccelerator = 2;
            this.m02 = d;
            this.m12 = d2;
        } else {
            this.fAccelerator = 0;
        }
    }

    public String toString() {
        return "AffineTransform[[" + AffineTransform._matround(this.m00) + ", " + AffineTransform._matround(this.m01) + ", " + AffineTransform._matround(this.m02) + "], [" + AffineTransform._matround(this.m10) + ", " + AffineTransform._matround(this.m11) + ", " + AffineTransform._matround(this.m12) + "]]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Point2D transform(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Float();
        }
        double d = point2D.getX();
        double d2 = point2D.getY();
        switch (this.fAccelerator) {
            case 0: {
                point2D2.setLocation(d, d2);
                return point2D2;
            }
            case 2: {
                point2D2.setLocation(d + this.m02, d2 + this.m12);
                return point2D2;
            }
            case 1: {
                if (this.m02 == 0.0 && this.m12 == 0.0) {
                    switch (this.fRotateAccelerator) {
                        case 0: {
                            point2D2.setLocation(d, d2);
                            return point2D2;
                        }
                        case 1: {
                            point2D2.setLocation(-d2, d);
                            return point2D2;
                        }
                        case 2: {
                            point2D2.setLocation(-d, -d2);
                            return point2D2;
                        }
                        case 3: {
                            point2D2.setLocation(d2, -d);
                            return point2D2;
                        }
                        case 4: {
                            point2D2.setLocation(this.m11 * d - this.m10 * d2, this.m10 * d + this.m11 * d2);
                            return point2D2;
                        }
                        default: {
                            return point2D2;
                        }
                    }
                }
                switch (this.fRotateAccelerator) {
                    case 0: {
                        point2D2.setLocation(d, d2);
                        return point2D2;
                    }
                    case 1: {
                        point2D2.setLocation(-d2 + this.m02 + this.m12, d - this.m02 + this.m12);
                        return point2D2;
                    }
                    case 2: {
                        point2D2.setLocation(-d + 2.0 * this.m02, -d2 + 2.0 * this.m12);
                        return point2D2;
                    }
                    case 3: {
                        point2D2.setLocation(d2 + this.m02 - this.m12, -d + this.m02 + this.m12);
                        return point2D2;
                    }
                    case 4: {
                        point2D2.setLocation(this.m11 * d - this.m10 * d2 + (1.0 - this.m11) * this.m02 + this.m10 * this.m12, this.m10 * d + this.m11 * d2 + (1.0 - this.m11) * this.m12 - this.m10 * this.m02);
                        return point2D2;
                    }
                    default: {
                        return point2D2;
                    }
                }
            }
            case 3: {
                point2D2.setLocation(d * this.m00 + this.m02, d2 * this.m11 + this.m12);
                return point2D2;
            }
            case 4: {
                point2D2.setLocation(this.m00 * d + this.m01 * d2 + this.m02, this.m10 * d + this.m11 * d2 + this.m12);
                return point2D2;
            }
        }
        return point2D2;
    }

    /*
     * Exception decompiling
     */
    public void transform(double[] var1_1, int var2_2, double[] var3_3, int var4_4, int var5_5) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: First case is not immediately after switch.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:442)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void transform(double[] var1_1, int var2_2, float[] var3_3, int var4_4, int var5_5) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: First case is not immediately after switch.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:442)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void transform(float[] var1_1, int var2_2, double[] var3_3, int var4_4, int var5_5) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: First case is not immediately after switch.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:442)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void transform(float[] var1_1, int var2_2, float[] var3_3, int var4_4, int var5_5) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: First case is not immediately after switch.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:442)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public void transform(Point2D[] var1_1, int var2_2, Point2D[] var3_3, int var4_4, int var5_5) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: First case is not immediately after switch.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:442)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void translate(double d, double d2) {
        if (d == 0.0 && d2 == 0.0) {
            return;
        }
        switch (this.fAccelerator) {
            case 0: {
                this.m02 = d;
                this.m12 = d2;
                this.fAccelerator = 2;
                break;
            }
            case 2: {
                this.m02 += d;
                this.m12 += d2;
                break;
            }
            case 1: {
                if (this.m02 == 0.0 && this.m12 == 0.0) {
                    this.m02 = -d;
                    this.m12 = -d2;
                    break;
                }
                this.RotateToAffine(this.fRotateAccelerator);
                this.fAccelerator = 4;
            }
            case 4: {
                this.m02 += d2 * this.m01;
                this.m12 += d * this.m10;
            }
            case 3: {
                this.m02 += d * this.m00;
                this.m12 += d2 * this.m11;
                break;
            }
        }
    }
}

