/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.MAreaGeometry;
import sun.awt.Albert.TCAGExclusiveOr;
import sun.awt.Albert.TCAGNode;
import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGRect;
import sun.awt.Albert.TGrafExtractor;
import sun.awt.Albert.TGrafMatrix;

class TExclusiveOrGeometry
extends MAreaGeometry {
    private MAreaGeometry fLeft;
    private MAreaGeometry fRight;
    private TGRect fBounds;

    public TExclusiveOrGeometry() {
        this.fBounds = null;
    }

    public TExclusiveOrGeometry(MAreaGeometry mAreaGeometry, MAreaGeometry mAreaGeometry2) {
        this.fLeft = mAreaGeometry;
        this.fRight = mAreaGeometry2;
        this.fBounds = null;
        this.updateTimeStamp();
    }

    public TExclusiveOrGeometry(TExclusiveOrGeometry tExclusiveOrGeometry) {
        super(tExclusiveOrGeometry);
        this.fLeft = null;
        this.fRight = null;
        this.fBounds = null;
        if (tExclusiveOrGeometry.fLeft != null) {
            this.fLeft = (MAreaGeometry)tExclusiveOrGeometry.fLeft.clone();
        }
        if (tExclusiveOrGeometry.fRight != null) {
            this.fRight = (MAreaGeometry)tExclusiveOrGeometry.fRight.clone();
        }
        if (tExclusiveOrGeometry.fBounds != null) {
            this.fBounds = (TGRect)tExclusiveOrGeometry.fBounds.clone();
        }
    }

    public Object clone() {
        return new TExclusiveOrGeometry(this);
    }

    public MAreaGeometry cloneAndExclusiveOr(MAreaGeometry mAreaGeometry) {
        TExclusiveOrGeometry tExclusiveOrGeometry = new TExclusiveOrGeometry(this);
        tExclusiveOrGeometry.fLeft = MAreaGeometry.exclusiveOr(tExclusiveOrGeometry.fLeft, mAreaGeometry);
        tExclusiveOrGeometry.fBounds = null;
        tExclusiveOrGeometry.updateTimeStamp();
        return tExclusiveOrGeometry;
    }

    public boolean contains(TGPoint tGPoint) {
        if (this.getBounds().contains(tGPoint)) {
            boolean bl = this.fLeft.contains(tGPoint);
            boolean bl2 = this.fRight.contains(tGPoint);
            return bl ^ bl2;
        }
        return false;
    }

    public boolean contains(TGRect tGRect) {
        return this.fLeft.contains(tGRect) && !this.fRight.intersects(tGRect) || this.fRight.contains(tGRect) && !this.fLeft.intersects(tGRect);
    }

    public final TExclusiveOrGeometry copyFrom(TExclusiveOrGeometry tExclusiveOrGeometry) {
        if (this != tExclusiveOrGeometry) {
            super.copyFrom(tExclusiveOrGeometry);
            this.fLeft = tExclusiveOrGeometry.fLeft;
            this.fRight = tExclusiveOrGeometry.fRight;
            this.fBounds = tExclusiveOrGeometry.fBounds;
        }
        return this;
    }

    public boolean equals(MAreaGeometry mAreaGeometry) {
        if (this.getClass().equals(mAreaGeometry.getClass())) {
            TExclusiveOrGeometry tExclusiveOrGeometry = (TExclusiveOrGeometry)mAreaGeometry;
            return super.equals(mAreaGeometry) || this.fLeft == tExclusiveOrGeometry.fLeft && this.fRight == tExclusiveOrGeometry.fRight;
        }
        return false;
    }

    public void extract(TGrafExtractor tGrafExtractor, TCAGNode tCAGNode, TGrafMatrix tGrafMatrix) {
        TCAGExclusiveOr tCAGExclusiveOr = new TCAGExclusiveOr(tCAGNode);
        tGrafExtractor.adoptCAGNode(tCAGExclusiveOr);
        this.fLeft.extract(tGrafExtractor, tCAGExclusiveOr, tGrafMatrix);
        this.fRight.extract(tGrafExtractor, tCAGExclusiveOr.getRightLink(), tGrafMatrix);
    }

    public TGRect getBounds() {
        if (this.fBounds == null) {
            this.fBounds = new TGRect(this.fLeft.getBounds());
            this.fBounds.extendTo(this.fRight.getBounds());
        }
        return this.fBounds;
    }

    public boolean intersects(TGRect tGRect) {
        return this.fLeft.intersects(tGRect) || this.fRight.intersects(tGRect);
    }

    public boolean isEmpty() {
        return this.fLeft.isEmpty() && this.fRight.isEmpty();
    }

    public boolean isPolygonal() {
        return this.fLeft.isPolygonal() && this.fRight.isPolygonal();
    }

    public boolean isSingular() {
        return false;
    }
}

