/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.TBezierList;
import sun.awt.Albert.TGCurve;
import sun.awt.Albert.TGEllipse;
import sun.awt.Albert.TGParametricArray;
import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGPolygon;
import sun.awt.Albert.TGRPoint;
import sun.awt.Albert.TGRPointArray;
import sun.awt.Albert.TGRect;
import sun.awt.Albert.prStatic;

public class TGLoop
extends TGCurve {
    private static final double kParametricDelta = 1.0E-6;
    private boolean fEOFill;

    public TGLoop() {
        this.fEOFill = true;
    }

    public TGLoop(int n, TGRPointArray tGRPointArray, TGParametricArray tGParametricArray) {
        this(n, tGRPointArray, tGParametricArray, true);
    }

    public TGLoop(int n, TGRPointArray tGRPointArray, TGParametricArray tGParametricArray, boolean bl) {
        super(n, tGRPointArray, tGParametricArray);
        this.fEOFill = bl;
    }

    public TGLoop(TGCurve tGCurve, boolean bl) {
        super(tGCurve);
        this.fEOFill = bl;
    }

    public TGLoop(TGEllipse tGEllipse) {
        super(3, 9);
        this.fEOFill = true;
        this.makeEllipticCurve(tGEllipse);
    }

    public TGLoop(TGLoop tGLoop) {
        super(tGLoop);
        this.fEOFill = tGLoop.fEOFill;
    }

    public TGLoop(TGPolygon tGPolygon) {
        super(2, tGPolygon.getNumberOfPoints());
        this.fEOFill = tGPolygon.getEOFill();
        this.fOrder = 2;
        TGRPoint[] tGRPointArray = this.fPoints.getArray();
        int n = 0;
        while (n < this.fNumPoints) {
            tGRPointArray[n].copyFrom(tGPolygon.getPoint(n));
            ++n;
        }
        this.setKnotScheme(2);
    }

    public TGLoop(TGRect tGRect) {
        super(2, 4);
        this.fEOFill = true;
        this.fPoints.setPoint(0, tGRect.getTopLeft());
        this.fPoints.setPoint(1, tGRect.getTopRight());
        this.fPoints.setPoint(2, tGRect.getBottomRight());
        this.fPoints.setPoint(3, tGRect.getBottomLeft());
        this.fOrder = 2;
        prStatic.SetBezierKnots(this.fOrder, this.fNumPoints, this.fKnots);
    }

    public Object clone() {
        return new TGLoop(this);
    }

    public void closeLoop() {
        if (this.isCloseable()) {
            this.extend();
            super.refineToPinned();
            TGRPoint[] tGRPointArray = this.fPoints.getArray();
            tGRPointArray[this.fNumPoints - 1].copyFrom(tGRPointArray[0]);
        } else {
            if (!this.isPinned()) {
                super.refineToPinned();
            }
            TGRPoint[] tGRPointArray = this.fPoints.getArray();
            int n = 0;
            int n2 = 0;
            int n3 = this.fOrder - 1;
            do {
                double d;
                if (tGRPointArray[n].equals(tGRPointArray[(n2 = this.getNextDiscontinuity(n, 0)) - 1])) {
                    n = n2;
                    continue;
                }
                this.fPoints.resize(this.fNumPoints + n3);
                tGRPointArray = this.fPoints.getArray();
                int n4 = this.fNumPoints - 1;
                while (n4 >= n2) {
                    tGRPointArray[n4 + n3].copyFrom(tGRPointArray[n4]);
                    --n4;
                }
                this.fKnots.resize(this.fNumPoints + 2 * this.fOrder - 1);
                double[] dArray = this.fKnots.getArray();
                n4 = this.fNumPoints + n3;
                while (n4 >= n2) {
                    dArray[n4 + n3] = dArray[n4];
                    --n4;
                }
                n4 = 0;
                while (n4 < n3 - 1) {
                    d = (double)(n4 + 1) / (double)n3;
                    TGRPoint tGRPoint = tGRPointArray[n2 + n4];
                    tGRPoint.copyFrom(tGRPointArray[n2 - 1]);
                    tGRPoint.multiplyBy(1.0 - d);
                    tGRPoint.addBy(TGRPoint.multiply(d, tGRPointArray[n]));
                    ++n4;
                }
                tGRPointArray[n2 + n3 - 1].copyFrom(tGRPointArray[n]);
                d = (dArray[n2] + dArray[n2 - 1]) / 2.0;
                n4 = 0;
                while (n4 < n3) {
                    dArray[n2 + n4] = d;
                    ++n4;
                }
                this.fNumPoints += n3;
                n = n2 + n3;
            } while (n < this.fNumPoints);
        }
    }

    public boolean contains(TGPoint tGPoint) {
        int n;
        if (this.isEmpty()) {
            return false;
        }
        int n2 = 0;
        TGLoop tGLoop = new TGLoop();
        tGLoop.setEOFill(this.fEOFill);
        boolean bl = false;
        int n3 = this.getNumberOfKnots() - 1;
        while ((n = this.getNextDiscontinuity(n2)) != n3) {
            this.getSectionOfCurve(this.getKnot(n2), this.getKnot(n) - 1.0E-6, tGLoop);
            TBezierList tBezierList = new TBezierList(tGLoop);
            bl = tBezierList.contains(tGPoint);
            if (bl) break;
            n2 = n;
        }
        return bl;
    }

    public boolean contains(TGRect tGRect) {
        int n;
        if (this.isEmpty()) {
            return false;
        }
        int n2 = 0;
        TGPoint tGPoint = tGRect.getTopLeft();
        TGLoop tGLoop = new TGLoop();
        tGLoop.setEOFill(this.fEOFill);
        boolean bl = false;
        int n3 = this.getNumberOfKnots() - 1;
        while ((n = this.getNextDiscontinuity(n2)) != n3) {
            this.getSectionOfCurve(this.getKnot(n2), this.getKnot(n) - 1.0E-6, tGLoop);
            TBezierList tBezierList = new TBezierList(tGLoop);
            boolean bl2 = bl = tBezierList.contains(tGPoint) && !tBezierList.intersects(tGRect);
            if (bl) break;
            n2 = n;
        }
        return bl;
    }

    public TGLoop copyFrom(TGLoop tGLoop) {
        if (tGLoop != this) {
            super.copyFrom(tGLoop);
            this.fEOFill = tGLoop.fEOFill;
        }
        return this;
    }

    public boolean equals(TGLoop tGLoop) {
        return this.fEOFill == tGLoop.fEOFill && super.equals(tGLoop);
    }

    public TGPoint evaluate(double d) {
        if (d > this.fKnots.getValue(this.fNumPoints) && this.isCloseable()) {
            this.extend();
            TGPoint tGPoint = super.evaluate(d);
            this.retract();
            return tGPoint;
        }
        return super.evaluate(d);
    }

    public TGRPoint evaluateW(double d) {
        if (d > this.fKnots.getValue(this.fNumPoints) && this.isCloseable()) {
            this.extend();
            TGRPoint tGRPoint = super.evaluateW(d);
            this.retract();
            return tGRPoint;
        }
        return super.evaluateW(d);
    }

    private void extend() {
        double[] dArray = this.fKnots.getArray();
        TGRPoint[] tGRPointArray = this.fPoints.getArray();
        double d = dArray[1] - dArray[0];
        int n = 2 * this.fOrder + this.fNumPoints - 1;
        int n2 = this.fNumPoints + this.fOrder - 1;
        this.fKnots.resize(n);
        this.fPoints.resize(n2);
        int n3 = this.fOrder + this.fNumPoints;
        while (n3 < n) {
            dArray[n3] = dArray[n3 - 1] + d;
            ++n3;
        }
        n3 = this.fNumPoints;
        while (n3 < n2) {
            tGRPointArray[n3].copyFrom(tGRPointArray[n3 - this.fNumPoints]);
            ++n3;
        }
        this.fNumPoints += this.fOrder - 1;
    }

    public TGRect getBounds() {
        if (this.isEmpty()) {
            return new TGRect(0.0, 0.0, 0.0, 0.0);
        }
        return new TBezierList(this).getBounds();
    }

    public boolean getEOFill() {
        return this.fEOFill;
    }

    public boolean intersects(TGRect tGRect) {
        int n;
        if (this.isEmpty()) {
            return false;
        }
        int n2 = 0;
        TGLoop tGLoop = new TGLoop();
        boolean bl = false;
        int n3 = this.getNumberOfKnots() - 1;
        while ((n = this.getNextDiscontinuity(n2)) != n3) {
            this.getSectionOfCurve(this.getKnot(n2), this.getKnot(n) - 1.0E-6, tGLoop);
            TBezierList tBezierList = new TBezierList(tGLoop);
            bl = tBezierList.intersects(tGRect);
            if (bl) break;
            n2 = n;
        }
        return bl;
    }

    boolean isCloseable() {
        double[] dArray = this.fKnots.getArray();
        int n = this.fOrder + this.fNumPoints - 1;
        double d = (dArray[n] - dArray[0]) * 2.220446049250313E-16 * 4.0;
        double d2 = dArray[1] - dArray[0];
        if (d2 == 0.0) {
            return false;
        }
        boolean bl = true;
        int n2 = 1;
        while (n2 < this.fOrder - 2 && bl) {
            bl = prStatic.Compare(dArray[n2 + 1] - dArray[n2], d2, d);
            ++n2;
        }
        n2 = this.fNumPoints + 1;
        while (n2 < n && bl) {
            bl = prStatic.Compare(dArray[n2 + 1] - dArray[n2], d2, d);
            ++n2;
        }
        return bl;
    }

    public void raiseOrder(int n) {
        if (this.isCloseable()) {
            this.closeLoop();
        }
        super.raiseOrder(n);
    }

    public void refineToBeziers() {
        this.closeLoop();
        super.refineToBeziers();
    }

    public void refineToPinned() {
        this.closeLoop();
    }

    private void retract() {
        if (this.isCloseable()) {
            double[] dArray = this.fKnots.getArray();
            double d = dArray[1] - dArray[0];
            double d2 = (dArray[this.fOrder + this.fNumPoints - 1] - dArray[0]) * 2.220446049250313E-16 * 4.0;
            boolean bl = true;
            int n = this.fNumPoints + this.fOrder - 2;
            int n2 = this.fNumPoints - 1;
            while (n2 < n && bl) {
                bl = prStatic.Compare(dArray[n2 + 1] - dArray[n2], d, d2);
                ++n2;
            }
            if (bl) {
                this.fNumPoints -= this.fOrder - 1;
                this.fPoints.resize(this.fNumPoints);
                this.fKnots.resize(this.fNumPoints + this.fOrder);
            }
        }
    }

    public void setEOFill(boolean bl) {
        this.fEOFill = bl;
    }

    public String toString() {
        String string = new String();
        String string2 = new String();
        int n = this.fNumPoints;
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + this.fPoints.getPoint(n2) + "\n";
            ++n2;
        }
        n += this.fOrder;
        int n3 = 0;
        while (n3 < n) {
            string2 = String.valueOf(string2) + this.fKnots.getValue(n3) + "\n";
            ++n3;
        }
        return "{\nEOFill = " + this.fEOFill + "\n" + "order = " + this.fOrder + "\n" + "num points = " + this.fNumPoints + "\n" + "points: " + "\n" + string + "knots: " + "\n" + string2 + "\n}\n";
    }
}

