/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.TRawPrimitiveArray;

class TGParametricArray
extends TRawPrimitiveArray {
    private double[] fValues = null;

    public TGParametricArray() {
        this(0);
    }

    public TGParametricArray(int n) {
        super(n);
        if (this.fArraySize > 0) {
            this.allocateArray(this.fArraySize);
        }
    }

    public TGParametricArray(TGParametricArray tGParametricArray) {
        if (tGParametricArray.fNumberOfValues > 0) {
            this.allocateArray(tGParametricArray.fArraySize);
            System.arraycopy(tGParametricArray.fValues, 0, this.fValues, 0, tGParametricArray.fNumberOfValues);
        }
        super.copyFrom(tGParametricArray);
    }

    void allocateArray(int n) {
        this.fValues = null;
        if (n > 0) {
            this.fValues = new double[n];
        }
    }

    public void append(double d) {
        this.resize(this.fNumberOfValues + 1);
        this.fValues[this.fNumberOfValues - 1] = d;
    }

    public final TGParametricArray copyFrom(TGParametricArray tGParametricArray) {
        if (this.fArraySize != tGParametricArray.fArraySize) {
            this.allocateArray(tGParametricArray.fArraySize);
        }
        System.arraycopy(tGParametricArray.fValues, 0, this.fValues, 0, tGParametricArray.fNumberOfValues);
        super.copyFrom(tGParametricArray);
        return this;
    }

    public final boolean equals(TGParametricArray tGParametricArray) {
        if (tGParametricArray == this) {
            return true;
        }
        if (super.equals(tGParametricArray)) {
            return false;
        }
        int n = 0;
        while (n < this.fNumberOfValues) {
            if (this.fValues[n] != tGParametricArray.fValues[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public double[] getArray() {
        return this.fValues;
    }

    public double getValue(int n) {
        if (n < 0 || n >= this.fNumberOfValues) {
            throw new IndexOutOfBoundsException("RawArray.value(index)");
        }
        return this.fValues[n];
    }

    void reallocateArray(int n) {
        double[] dArray = this.fValues;
        this.allocateArray(n);
        if (n > 0) {
            System.arraycopy(dArray, 0, this.fValues, 0, this.fArraySize > n ? n : this.fArraySize);
        }
    }

    public void setValue(int n, double d) {
        if (n < 0 || n >= this.fNumberOfValues) {
            throw new IndexOutOfBoundsException("RawArray.setValue(index, ...)");
        }
        this.fValues[n] = d;
    }

    public void swap(TGParametricArray tGParametricArray) {
        super.swap(tGParametricArray);
        double[] dArray = this.fValues;
        this.fValues = tGParametricArray.fValues;
        tGParametricArray.fValues = dArray;
    }

    public String toString() {
        String string = new String();
        int n = this.fNumberOfValues;
        int n2 = 0;
        while (n2 < n) {
            string = String.valueOf(string) + this.getValue(n2) + ",";
            ++n2;
        }
        return "{ num values = " + n + "; " + string + "}";
    }
}

