/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.TGLine;
import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGPointArray;
import sun.awt.Albert.TGRect;
import sun.awt.Albert.TGrafMatrix;

public class TGPolyline
implements Cloneable {
    protected TGPointArray fPoints;

    public TGPolyline() {
        this.fPoints = new TGPointArray(0);
    }

    public TGPolyline(int n) {
        this.fPoints = new TGPointArray(n);
    }

    public TGPolyline(TGPointArray tGPointArray) {
        this.fPoints = new TGPointArray(tGPointArray);
    }

    public TGPolyline(TGPolyline tGPolyline) {
        this(tGPolyline.fPoints);
    }

    public void addBefore(int n, TGPoint tGPoint) {
        int n2 = this.fPoints.getNumberOfPoints();
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException("TGPolyline.addBefore(index,...)");
        }
        this.fPoints.resize(n2 + 1);
        TGPoint[] tGPointArray = this.fPoints.getArray();
        TGPoint tGPoint2 = tGPointArray[n2];
        int n3 = n2;
        while (n3 > n) {
            tGPointArray[n3] = tGPointArray[n3 - 1];
            --n3;
        }
        tGPoint2.copyFrom(tGPoint);
        tGPointArray[n] = tGPoint2;
    }

    public void append(TGPoint tGPoint) {
        this.fPoints.append(tGPoint);
    }

    public TGPolyline copyFrom(TGPolyline tGPolyline) {
        if (tGPolyline != this) {
            this.fPoints.copyFrom(tGPolyline.fPoints);
        }
        return this;
    }

    public boolean equals(TGPolyline tGPolyline) {
        return tGPolyline == this || this.fPoints.equals(tGPolyline.fPoints);
    }

    public TGPoint evaluate(double d) {
        int n = this.fPoints.getNumberOfPoints() - 1;
        if (d < 0.0 || d > (double)n) {
            throw new IndexOutOfBoundsException("TGPolyline.evaluate(parametric)");
        }
        int n2 = (int)d;
        if (n2 == n) {
            return (TGPoint)this.fPoints.getPoint(n).clone();
        }
        TGLine tGLine = new TGLine(this.fPoints.getPoint(n2), this.fPoints.getPoint(n2 + 1));
        return tGLine.evaluate(d - (double)n2);
    }

    public TGRect getBounds() {
        TGRect tGRect = new TGRect();
        TGPoint[] tGPointArray = this.fPoints.getArray();
        TGPoint tGPoint = tGPointArray[0];
        tGRect.setToPoint(tGPoint);
        int n = this.fPoints.getNumberOfPoints();
        int n2 = 1;
        while (n2 < n) {
            tGRect.extendTo(tGPointArray[n2]);
            ++n2;
        }
        return tGRect;
    }

    public int getNumberOfPoints() {
        return this.fPoints.getNumberOfPoints();
    }

    public TGPoint getPoint(int n) {
        if ((double)n < 0.0 || n >= this.fPoints.getNumberOfPoints()) {
            throw new IndexOutOfBoundsException("TGPolyline.getPoint(index)");
        }
        return this.fPoints.getPoint(n);
    }

    TGPoint[] getPoints() {
        return this.fPoints.getArray();
    }

    public void getPoints(TGPointArray tGPointArray) {
        tGPointArray.copyFrom(this.fPoints);
    }

    public boolean intersects(TGRect tGRect) {
        TGRect tGRect2 = this.getBounds();
        if (tGRect.intersects(tGRect2)) {
            int n = this.fPoints.getNumberOfPoints();
            TGPoint[] tGPointArray = this.fPoints.getArray();
            int n2 = 1;
            while (n2 < n) {
                TGLine tGLine = new TGLine(tGPointArray[n2 - 1], tGPointArray[n2]);
                if (tGLine.intersects(tGRect)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean isDegenerateToAPoint() {
        boolean bl = true;
        int n = this.fPoints.getNumberOfPoints();
        if (n > 0) {
            TGPoint tGPoint = this.fPoints.getPoint(0);
            int n2 = 1;
            while (n2 < n) {
                TGPoint tGPoint2 = this.fPoints.getPoint(n2);
                if (!tGPoint.equals(tGPoint2)) {
                    bl = false;
                    break;
                }
                ++n2;
            }
        }
        return bl;
    }

    public boolean isRectilinear() {
        TGPoint[] tGPointArray = this.fPoints.getArray();
        int n = this.fPoints.getNumberOfPoints() - 1;
        int n2 = 0;
        while (n2 < n) {
            TGPoint tGPoint = tGPointArray[n2 + 1];
            TGPoint tGPoint2 = tGPointArray[n2];
            if (tGPoint.x != tGPoint2.x && tGPoint.y != tGPoint2.y) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void removePoint(int n) {
        int n2 = this.fPoints.getNumberOfPoints();
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException("TGPolyline.removePoint(index)");
        }
        --n2;
        TGPoint[] tGPointArray = this.fPoints.getArray();
        int n3 = n;
        while (n3 < n2) {
            tGPointArray[n3] = tGPointArray[n3 + 1];
            ++n3;
        }
        this.fPoints.resize(n2);
    }

    void resizePointArray(int n) {
        this.fPoints.resize(n);
    }

    public void reverseDirection() {
        int n = this.fPoints.getNumberOfPoints();
        if (n > 0) {
            TGPoint[] tGPointArray = this.fPoints.getArray();
            int n2 = 0;
            int n3 = n - 1;
            while (n2 < n3) {
                TGPoint tGPoint = tGPointArray[n2];
                tGPointArray[n2] = tGPointArray[n3];
                tGPointArray[n3] = tGPoint;
                ++n2;
                --n3;
            }
        }
    }

    void setPoint(int n, double d, double d2) {
        if (n < this.fPoints.getNumberOfPoints()) {
            this.fPoints.setPoint(n, d, d2);
        }
    }

    public void setPoint(int n, TGPoint tGPoint) {
        if (n < this.fPoints.getNumberOfPoints()) {
            this.fPoints.setPoint(n, tGPoint);
        }
    }

    public void transformBy(TGrafMatrix tGrafMatrix) {
        tGrafMatrix.transformPoints(this.fPoints);
    }
}

