/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.TGPoint;

final class TGRPoint
implements Cloneable {
    public double fX;
    public double fY;
    public double fW;

    public TGRPoint() {
    }

    public TGRPoint(double d, double d2) {
        this(d, d2, 1.0);
    }

    public TGRPoint(double d, double d2, double d3) {
        this.fX = d;
        this.fY = d2;
        this.fW = d3;
    }

    public TGRPoint(TGPoint tGPoint) {
        this(tGPoint.x, tGPoint.y);
    }

    public TGRPoint(TGRPoint tGRPoint) {
        this(tGRPoint.fX, tGRPoint.fY, tGRPoint.fW);
    }

    static void SetToZero(TGRPoint tGRPoint) {
        tGRPoint.fX = 0.0;
        tGRPoint.fY = 0.0;
        tGRPoint.fW = 0.0;
    }

    TGRPoint addBy(TGRPoint tGRPoint) {
        this.fX += tGRPoint.fX;
        this.fY += tGRPoint.fY;
        this.fW += tGRPoint.fW;
        return this;
    }

    public Object clone() {
        return new TGRPoint(this);
    }

    public final TGRPoint copyFrom(TGPoint tGPoint) {
        this.fX = tGPoint.x;
        this.fY = tGPoint.y;
        this.fW = 1.0;
        return this;
    }

    public final TGRPoint copyFrom(TGRPoint tGRPoint) {
        this.fX = tGRPoint.fX;
        this.fY = tGRPoint.fY;
        this.fW = tGRPoint.fW;
        return this;
    }

    public TGPoint divW() {
        return new TGPoint(this.fX / this.fW, this.fY / this.fW);
    }

    static TGRPoint divide(TGRPoint tGRPoint, double d) {
        return new TGRPoint(tGRPoint.fX / d, tGRPoint.fY / d, tGRPoint.fW / d);
    }

    TGRPoint divideBy(double d) {
        this.fX /= d;
        this.fY /= d;
        this.fW /= d;
        return this;
    }

    public TGPoint dropW() {
        return new TGPoint(this.fX, this.fY);
    }

    public boolean equals(TGRPoint tGRPoint) {
        return this.fX == tGRPoint.fX && this.fY == tGRPoint.fY && this.fW == tGRPoint.fW;
    }

    static TGRPoint multiply(double d, TGRPoint tGRPoint) {
        return new TGRPoint(tGRPoint.fX * d, tGRPoint.fY * d, tGRPoint.fW * d);
    }

    static TGRPoint multiply(TGRPoint tGRPoint, double d) {
        return new TGRPoint(tGRPoint.fX * d, tGRPoint.fY * d, tGRPoint.fW * d);
    }

    TGRPoint multiplyBy(double d) {
        this.fX *= d;
        this.fY *= d;
        this.fW *= d;
        return this;
    }

    public String toString() {
        return "(" + this.fX + "," + this.fY + "," + this.fW + ")";
    }
}

