/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGPointArray;
import sun.awt.Albert.TGRPoint;
import sun.awt.Albert.TGRect;
import sun.awt.Albert.TRawArray;

class TGRPointArray
extends TRawArray {
    private TGRPoint[] fValues = null;

    public TGRPointArray() {
        this(0);
    }

    public TGRPointArray(int n) {
        super(n);
        if (this.fArraySize > 0) {
            this.allocateArray(this.fArraySize);
            this.newAllocation(0, this.fArraySize);
        }
    }

    public TGRPointArray(TGPointArray tGPointArray) {
        this(tGPointArray.getNumberOfPoints());
        int n = 0;
        while (n < tGPointArray.getNumberOfPoints()) {
            TGPoint tGPoint = tGPointArray.getValue(n);
            TGRPoint tGRPoint = this.getValue(n);
            tGRPoint.fX = tGPoint.x;
            tGRPoint.fY = tGPoint.y;
            tGRPoint.fW = 1.0;
            ++n;
        }
    }

    public TGRPointArray(TGRPointArray tGRPointArray) {
        if (tGRPointArray.fNumberOfValues > 0) {
            this.allocateArray(tGRPointArray.fArraySize);
            this.cloneFromArray(0, tGRPointArray.fNumberOfValues, tGRPointArray.fValues);
            int n = tGRPointArray.fArraySize - tGRPointArray.fNumberOfValues;
            if (n > 0) {
                this.newAllocation(tGRPointArray.fNumberOfValues, n);
            }
        }
        super.copyFrom(tGRPointArray);
    }

    void allocateArray(int n) {
        this.fValues = null;
        if (n > 0) {
            this.fValues = new TGRPoint[n];
        }
    }

    public void append(TGPoint tGPoint) {
        int n = this.fNumberOfValues;
        this.resize(n + 1);
        this.fValues[n].fX = tGPoint.x;
        this.fValues[n].fY = tGPoint.y;
        this.fValues[n].fW = 1.0;
    }

    public void append(TGRPoint tGRPoint) {
        int n = this.fNumberOfValues;
        this.resize(n + 1);
        this.fValues[n].copyFrom(tGRPoint);
    }

    private void cloneFromArray(int n, int n2, TGRPoint[] tGRPointArray) {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            this.fValues[n4] = (TGRPoint)tGRPointArray[n4].clone();
            ++n4;
        }
    }

    public final TGRPointArray copyFrom(TGRPointArray tGRPointArray) {
        if (this.fArraySize != tGRPointArray.fArraySize) {
            TGRPoint[] tGRPointArray2 = this.fValues;
            this.allocateArray(tGRPointArray.fArraySize);
            if (this.fArraySize > tGRPointArray.fArraySize) {
                this.fArraySize = tGRPointArray.fArraySize;
            } else {
                this.newAllocation(this.fArraySize, tGRPointArray.fArraySize - this.fArraySize);
            }
            if (this.fArraySize > 0) {
                System.arraycopy(tGRPointArray2, 0, this.fValues, 0, this.fArraySize);
            }
        }
        int n = 0;
        while (n < tGRPointArray.fNumberOfValues) {
            this.fValues[n].copyFrom(tGRPointArray.fValues[n]);
            ++n;
        }
        super.copyFrom(tGRPointArray);
        return this;
    }

    public final boolean equals(TGRPointArray tGRPointArray) {
        if (tGRPointArray == this) {
            return true;
        }
        if (super.equals(tGRPointArray)) {
            return false;
        }
        int n = 0;
        while (n < this.fNumberOfValues) {
            if (!this.fValues[n].equals(tGRPointArray.fValues[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public TGRPoint[] getArray() {
        return this.fValues;
    }

    public TGRect getBounds() {
        int n = this.getNumberOfValues();
        if (n == 0) {
            return new TGRect(0.0, 0.0, 0.0, 0.0);
        }
        TGRect tGRect = new TGRect();
        TGRPoint[] tGRPointArray = this.getArray();
        tGRect.setToPoint(tGRPointArray[0].divW());
        int n2 = 1;
        while (n2 < n) {
            tGRect.extendTo(tGRPointArray[n2].divW());
            ++n2;
        }
        return tGRect;
    }

    public int getNumberOfPoints() {
        return this.getNumberOfValues();
    }

    public TGRPoint getPoint(int n) {
        return this.getValue(n);
    }

    public TGRPoint getValue(int n) {
        if (n < 0 || n >= this.fNumberOfValues) {
            throw new IndexOutOfBoundsException("RawArray.value(index)");
        }
        return this.fValues[n];
    }

    void newAllocation(int n, int n2) {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            this.fValues[n4] = new TGRPoint();
            ++n4;
        }
    }

    void reallocateArray(int n) {
        TGRPoint[] tGRPointArray = this.fValues;
        this.allocateArray(n);
        if (n > 0) {
            System.arraycopy(tGRPointArray, 0, this.fValues, 0, this.fArraySize > n ? n : this.fArraySize);
        }
    }

    public void setPoint(int n, double d, double d2, double d3) {
        if (n < 0 || n >= this.fNumberOfValues) {
            throw new IndexOutOfBoundsException("RawArray.setValue(index, ...)");
        }
        TGRPoint tGRPoint = this.fValues[n];
        tGRPoint.fX = d;
        tGRPoint.fY = d2;
        tGRPoint.fW = d3;
    }

    public void setPoint(int n, TGPoint tGPoint) {
        this.setPoint(n, tGPoint.x, tGPoint.y, 1.0);
    }

    public void setPoint(int n, TGRPoint tGRPoint) {
        this.setValue(n, tGRPoint);
    }

    public void setValue(int n, TGRPoint tGRPoint) {
        if (n < 0 || n >= this.fNumberOfValues) {
            throw new IndexOutOfBoundsException("RawArray.setValue(index, ...)");
        }
        this.fValues[n].copyFrom(tGRPoint);
    }

    public void swap(TGRPointArray tGRPointArray) {
        super.swap(tGRPointArray);
        TGRPoint[] tGRPointArray2 = this.fValues;
        this.fValues = tGRPointArray.fValues;
        tGRPointArray.fValues = tGRPointArray2;
    }
}

