/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.Albert;

import sun.awt.Albert.MAreaGeometry;
import sun.awt.Albert.TCAGEvenOdd;
import sun.awt.Albert.TCAGNode;
import sun.awt.Albert.TCAGUnary;
import sun.awt.Albert.TCAGWindNum;
import sun.awt.Albert.TGPoint;
import sun.awt.Albert.TGPolygon;
import sun.awt.Albert.TGRect;
import sun.awt.Albert.TGrafExtractor;
import sun.awt.Albert.TGrafMatrix;

public class TPolygonGeometry
extends MAreaGeometry {
    public TGPolygon fPolygon;
    private TGRect fBounds;
    private static final int kLargePolygon = 16;

    public TPolygonGeometry() {
        this.fBounds = null;
    }

    public TPolygonGeometry(TGPolygon tGPolygon) {
        this.fPolygon = new TGPolygon(tGPolygon);
        this.fBounds = null;
        this.updateTimeStamp();
    }

    public TPolygonGeometry(TPolygonGeometry tPolygonGeometry) {
        super(tPolygonGeometry);
        this.fPolygon = new TGPolygon(tPolygonGeometry.fPolygon);
        this.fBounds = null;
        if (tPolygonGeometry.fBounds != null) {
            this.fBounds = (TGRect)tPolygonGeometry.fBounds.clone();
        }
    }

    public Object clone() {
        return new TPolygonGeometry(this);
    }

    public MAreaGeometry cloneAndTransform(TGrafMatrix tGrafMatrix) {
        if (this.fPolygon.getNumberOfPoints() > 16) {
            return super.cloneAndTransform(tGrafMatrix);
        }
        TPolygonGeometry tPolygonGeometry = new TPolygonGeometry(this);
        tPolygonGeometry.fPolygon.transformBy(tGrafMatrix);
        tPolygonGeometry.fBounds = null;
        tPolygonGeometry.updateTimeStamp();
        return tPolygonGeometry;
    }

    public boolean contains(TGPoint tGPoint) {
        return this.fPolygon.contains(tGPoint);
    }

    public boolean contains(TGRect tGRect) {
        return !this.fPolygon.intersects(tGRect) && this.fPolygon.contains(tGRect.getTopLeft());
    }

    public final TPolygonGeometry copyFrom(TPolygonGeometry tPolygonGeometry) {
        if (this != tPolygonGeometry) {
            super.copyFrom(tPolygonGeometry);
            this.fPolygon = tPolygonGeometry.fPolygon;
            this.fBounds = tPolygonGeometry.fBounds;
        }
        return this;
    }

    public boolean equals(MAreaGeometry mAreaGeometry) {
        if (this.getClass().equals(mAreaGeometry.getClass())) {
            TPolygonGeometry tPolygonGeometry = (TPolygonGeometry)mAreaGeometry;
            return super.equals(mAreaGeometry) && this.fPolygon.equals(tPolygonGeometry.fPolygon);
        }
        return false;
    }

    public void extract(TGrafExtractor tGrafExtractor, TCAGNode tCAGNode, TGrafMatrix tGrafMatrix) {
        boolean bl = this.fPolygon.getEOFill();
        TCAGUnary tCAGUnary = bl ? new TCAGEvenOdd(tCAGNode) : new TCAGWindNum(tCAGNode);
        tGrafExtractor.adoptCAGNode(tCAGUnary);
        tGrafExtractor.extractPolygon(this.fPolygon, tCAGUnary, tGrafMatrix);
    }

    public TGRect getBounds() {
        if (this.fBounds == null) {
            this.fBounds = this.fPolygon.getBounds();
        }
        return this.fBounds;
    }

    public boolean intersects(TGRect tGRect) {
        return this.fPolygon.intersects(tGRect);
    }

    public boolean isEmpty() {
        return this.fPolygon.getNumberOfPoints() < 3;
    }

    public boolean isPolygonal() {
        return true;
    }

    public boolean isRectangular() {
        return this.fPolygon.getNumberOfPoints() <= 2;
    }
}

