/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.Canvas;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.awt.image.PixelGrabber;
import java.awt.image.RGBImageFilter;

public abstract class CustomCursor
extends Cursor {
    protected Image image;

    public CustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException {
        super(string);
        this.image = image;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Canvas canvas = new Canvas();
        MediaTracker mediaTracker = new MediaTracker(canvas);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {}
        int n = image.getWidth(canvas);
        int n2 = image.getHeight(canvas);
        Dimension dimension = toolkit.getBestCursorSize(n, n2);
        if (dimension.width != n || dimension.height != n2) {
            image = image.getScaledInstance(dimension.width, dimension.height, 1);
            n = dimension.width;
            n2 = dimension.height;
        }
        if (point.x >= n || point.y >= n2) {
            throw new IndexOutOfBoundsException("invalid hotSpot");
        }
        int[] nArray = new int[n * n2];
        ImageProducer imageProducer = image.getSource();
        imageProducer = new FilteredImageSource(imageProducer, this.getImageFilter());
        PixelGrabber pixelGrabber = new PixelGrabber(imageProducer, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
            this.createNativeCursor(nArray, n, n2, point.x, point.y);
        }
        catch (InterruptedException interruptedException) {}
    }

    protected abstract void createNativeCursor(int[] var1, int var2, int var3, int var4, int var5);

    protected ImageFilter getImageFilter() {
        return new DefaultImageFilter();
    }

    private static class DefaultImageFilter
    extends RGBImageFilter {
        DefaultImageFilter() {
            this.canFilterIndexColorModel = true;
        }

        public int filterRGB(int n, int n2, int n3) {
            if ((n3 & 0xFF000000) == 0) {
                return 0;
            }
            double d = 0.3 * (double)(n3 >> 16 & 0xFF) + 0.59 * (double)(n3 >> 8 & 0xFF) + 0.11 * (double)(n3 & 0xFF);
            return d > 128.0 ? -1 : -16777216;
        }
    }
}

