/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.font;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import sun.awt.font.ExtendedTextLabel;
import sun.awt.font.NativeFontWrapper;
import sun.awt.font.Segment;
import sun.awt.font.Shaping;
import sun.awt.font.TextSource;

public class ExtendedTextSourceLabel
extends ExtendedTextLabel {
    TextSource source;
    Rectangle2D lb;
    Rectangle2D ab;
    Rectangle2D vb;
    GlyphVector gv;
    String str;
    Segment shapedSeg;
    float[] charinfo;
    private static final int posx = 0;
    private static final int posy = 1;
    private static final int advx = 2;
    private static final int advy = 3;
    private static final int visx = 4;
    private static final int visy = 5;
    private static final int visw = 6;
    private static final int vish = 7;
    private static final int numvals = 8;

    public ExtendedTextSourceLabel(TextSource textSource) {
        this.source = textSource;
    }

    public ExtendedTextSourceLabel(TextSource textSource, ExtendedTextSourceLabel extendedTextSourceLabel, int n) {
        this.source = textSource;
    }

    public static ExtendedTextLabel create(TextSource textSource) {
        return new ExtendedTextSourceLabel(textSource);
    }

    protected Rectangle2D createAlignBounds() {
        LineMetrics lineMetrics = this.source.getLineMetrics();
        float[] fArray = this.getCharinfo();
        float f = 0.0f;
        float f2 = -lineMetrics.getAscent();
        float f3 = 0.0f;
        float f4 = lineMetrics.getAscent() + lineMetrics.getDescent();
        boolean bl = this.source.lineIsLTR();
        int n = fArray.length - 8;
        while (n > 0 && (fArray[n + 2] == 0.0f || bl && fArray[n + 6] == 0.0f)) {
            n -= 8;
        }
        if (n >= 0) {
            int n2 = 0;
            while (n2 < n && (fArray[n2 + 2] == 0.0f || !bl && fArray[n2 + 6] == 0.0f)) {
                n2 += 8;
            }
            f = Math.max(0.0f, fArray[n2]);
            f3 = fArray[n] + fArray[n + 2] - f;
        }
        return new Rectangle2D.Float(f, f2, f3, f4);
    }

    protected float[] createCharinfo() {
        Segment segment = this.getShapedSegment();
        Font font = this.source.getFont();
        FontRenderContext fontRenderContext = this.source.getFRC();
        AffineTransform affineTransform = (AffineTransform)fontRenderContext.getTransform().clone();
        affineTransform.scale(font.getSize2D(), font.getSize2D());
        affineTransform.preConcatenate(font.getTransform());
        double[] dArray = new double[6];
        affineTransform.getMatrix(dArray);
        float[] fArray = new float[segment.length * 8];
        fArray[0] = (float)dArray[4];
        fArray[1] = (float)dArray[5];
        NativeFontWrapper.getGlyphInfo(font, segment.text, segment.start, segment.length, dArray, fontRenderContext.usesFractionalMetrics(), fontRenderContext.isAntiAliased(), fArray);
        return fArray;
    }

    protected GlyphVector createGV() {
        Font font = this.source.getFont();
        FontRenderContext fontRenderContext = this.source.getFRC();
        return font.createGlyphVector(fontRenderContext, this.getString());
    }

    protected Rectangle2D createLogicalBounds() {
        LineMetrics lineMetrics = this.source.getLineMetrics();
        float[] fArray = this.getCharinfo();
        float f = 0.0f;
        float f2 = -lineMetrics.getAscent();
        float f3 = 0.0f;
        float f4 = lineMetrics.getAscent() + lineMetrics.getDescent() + lineMetrics.getLeading();
        int n = fArray.length - 8;
        while (n > 0) {
            if (fArray[n + 2] != 0.0f) break;
            n -= 8;
        }
        if (n >= 0) {
            int n2 = 0;
            while (n2 < n) {
                if (fArray[n2 + 2] != 0.0f) break;
                n2 += 8;
            }
            f = Math.min(0.0f, fArray[n2]);
            f3 = fArray[n] + fArray[n + 2] - f;
        }
        return new Rectangle2D.Float(f, f2, f3, f4);
    }

    protected Segment createShapedSegment() {
        Segment segment = new Segment();
        Shaping.getShapedSegment(this.source, segment);
        return segment;
    }

    protected String createString() {
        Segment segment = new Segment(this.getShapedSegment());
        Shaping.compressSegment(segment, null);
        return new String(segment.text, segment.start, segment.length);
    }

    protected Rectangle2D createVisualBounds() {
        return this.getGV().getVisualBounds();
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        if (this.gv != null) {
            graphics2D.drawGlyphVector(this.gv, f, f2);
        } else {
            graphics2D.drawGlyphVector(this.getGV(), f, f2);
        }
    }

    public Rectangle2D getAlignBounds(float f, float f2) {
        if (this.ab == null) {
            this.ab = this.createAlignBounds();
        }
        return new Rectangle2D.Float((float)(this.ab.getX() + (double)f), (float)(this.ab.getY() + (double)f2), (float)this.ab.getWidth(), (float)this.ab.getHeight());
    }

    public float getCharAdvance(int n) {
        this.validate(n);
        return this.getCharinfo()[this.l2v(n) * 8 + 2];
    }

    public float getCharAdvanceBetween(int n, int n2) {
        float f = 0.0f;
        float[] fArray = this.getCharinfo();
        --n;
        while (++n < n2) {
            f += fArray[this.l2v(n) * 8 + 2];
        }
        return f;
    }

    public Rectangle2D getCharVisualBounds(int n, float f, float f2) {
        this.validate(n);
        float[] fArray = this.getCharinfo();
        n = this.l2v(n) * 8;
        return new Rectangle2D.Float(fArray[n + 4] + f, fArray[n + 5] + f2, fArray[n + 6], fArray[n + 7]);
    }

    public float getCharX(int n) {
        this.validate(n);
        return this.getCharinfo()[this.l2v(n) * 8];
    }

    public float getCharY(int n) {
        this.validate(n);
        return this.getCharinfo()[this.l2v(n) * 8 + 1];
    }

    private final float[] getCharinfo() {
        if (this.charinfo == null) {
            this.charinfo = this.createCharinfo();
        }
        return this.charinfo;
    }

    private final GlyphVector getGV() {
        if (this.gv == null) {
            this.gv = this.createGV();
        }
        return this.gv;
    }

    public float getItalicAngle() {
        return this.source.getFont().getItalicAngle();
    }

    public int getLineBreakIndex(int n, float f) {
        float[] fArray = this.getCharinfo();
        int n2 = this.source.getLength();
        --n;
        while (f >= 0.0f && ++n < n2) {
            f -= fArray[this.l2v(n) * 8 + 2];
        }
        return n;
    }

    public LineMetrics getLineMetrics() {
        return this.source.getLineMetrics();
    }

    public Rectangle2D getLogicalBounds(float f, float f2) {
        if (this.lb == null) {
            this.lb = this.createLogicalBounds();
        }
        return new Rectangle2D.Float((float)(this.lb.getX() + (double)f), (float)(this.lb.getY() + (double)f2), (float)this.lb.getWidth(), (float)this.lb.getHeight());
    }

    public int getNumCharacters() {
        return this.source.getLength();
    }

    public Shape getOutline(float f, float f2) {
        return this.getGV().getOutline(f, f2);
    }

    private final Segment getShapedSegment() {
        if (this.shapedSeg == null) {
            this.shapedSeg = this.createShapedSegment();
        }
        return this.shapedSeg;
    }

    private final String getString() {
        if (this.str == null) {
            this.str = this.createString();
        }
        return this.str;
    }

    public Rectangle2D getVisualBounds(float f, float f2) {
        if (this.vb == null) {
            this.vb = this.createVisualBounds();
        }
        return new Rectangle2D.Float((float)(this.vb.getX() + (double)f), (float)(this.vb.getY() + (double)f2), (float)this.vb.getWidth(), (float)this.vb.getHeight());
    }

    protected int l2v(int n) {
        return this.source.dataIsLTR() ? n : this.source.getLength() - 1 - n;
    }

    public int logicalToVisual(int n) {
        this.validate(n);
        return this.l2v(n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("[source:");
        stringBuffer.append(this.source);
        stringBuffer.append(", lb:");
        stringBuffer.append(this.lb);
        stringBuffer.append(", ab:");
        stringBuffer.append(this.ab);
        stringBuffer.append(", vb:");
        stringBuffer.append(this.vb);
        stringBuffer.append(", gv:");
        stringBuffer.append(this.gv);
        stringBuffer.append(", str:");
        if (this.str == null) {
            stringBuffer.append(this.str);
        } else {
            stringBuffer.append("\"");
            int n = this.str.length();
            int n2 = 0;
            while (n2 < n) {
                if (n2 > 0) {
                    stringBuffer.append(" ");
                }
                stringBuffer.append(Integer.toHexString(this.str.charAt(n2)));
                ++n2;
            }
            stringBuffer.append("\"");
        }
        stringBuffer.append(", seg:");
        stringBuffer.append(this.shapedSeg);
        stringBuffer.append(", ci:");
        stringBuffer.append(this.charinfo == null ? "null" : Integer.toString(this.charinfo.length));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    protected int v2l(int n) {
        return this.source.dataIsLTR() ? n : this.source.getLength() - 1 - n;
    }

    private void validate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("index " + n + " < 0");
        }
        if (n >= this.source.getLength()) {
            throw new IllegalArgumentException("index " + n + " < " + this.source.getLength());
        }
    }

    public int visualToLogical(int n) {
        this.validate(n);
        return this.v2l(n);
    }
}

