/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.SystemColor;
import java.awt.peer.DialogPeer;
import sun.awt.SunToolkit;
import sun.awt.im.InputMethodManager;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WWindowPeer;

class WDialogPeer
extends WWindowPeer
implements DialogPeer {
    ModalLock modalLock = new ModalLock();

    WDialogPeer(Dialog dialog) {
        super(dialog);
        InputMethodManager inputMethodManager = InputMethodManager.getInstance();
        String string = inputMethodManager.getTriggerMenuString();
        if (string != null) {
            this.pSetIMMOption(string);
        }
    }

    native void create(WComponentPeer var1);

    native void endModal();

    public void hide() {
        if (((Dialog)this.target).isModal()) {
            this.endModal();
            this.modalLock.endModal();
        } else {
            super.hide();
        }
    }

    void initialize() {
        super.initialize();
        Dialog dialog = (Dialog)this.target;
        if (dialog.getTitle() != null) {
            this.setTitle(dialog.getTitle());
        }
        this.setResizable(dialog.isResizable());
    }

    void notifyIMMOptionChange() {
        InputMethodManager.getInstance().notifyChangeRequest((Component)this.target);
    }

    native void pSetIMMOption(String var1);

    private void setDefaultColor(boolean bl) {
        final SystemColor systemColor = bl ? SystemColor.control : SystemColor.window;
        SunToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            public void run() {
                ((Dialog)target).setBackground(systemColor);
            }
        });
    }

    public void show() {
        if (((Dialog)this.target).isModal()) {
            this.showModal();
            this.modalLock.waitModal();
        } else {
            super.show();
        }
    }

    native void showModal();

    class ModalLock {
        ModalLock() {
        }

        synchronized void endModal() {
            this.notifyAll();
        }

        synchronized void waitModal() {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

