/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.InputMethodEvent;
import java.awt.font.TextAttribute;
import java.awt.font.TextHitInfo;
import java.awt.im.InputMethodHighlight;
import java.awt.im.InputSubset;
import java.awt.peer.LightweightPeer;
import java.text.Annotation;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import sun.awt.SunToolkit;
import sun.awt.im.InputMethodAdapter;
import sun.awt.im.InputMethodHighlightMapping;
import sun.awt.windows.WComponentPeer;

public class WInputMethod
extends InputMethodAdapter {
    private Component target;
    private int context = this.createNativeContext();
    private boolean open;
    private int cmode = this.getConversionStatus(this.context);
    private boolean disposed = false;
    public static final byte ATTR_INPUT = 0;
    public static final byte ATTR_TARGET_CONVERTED = 1;
    public static final byte ATTR_CONVERTED = 2;
    public static final byte ATTR_TARGET_NOTCONVERTED = 3;
    public static final byte ATTR_INPUT_ERROR = 4;
    public static final int IME_CMODE_ALPHANUMERIC = 0;
    public static final int IME_CMODE_NATIVE = 1;
    public static final int IME_CMODE_KATAKANA = 2;
    public static final int IME_CMODE_LANGUAGE = 3;
    public static final int IME_CMODE_FULLSHAPE = 8;
    public static final int IME_CMODE_HANJACONVERT = 64;
    public static final int IME_CMODE_ROMAN = 16;
    public static final int LANG_CHINESE = 4;
    public static final int LANG_JAPANESE = 17;
    public static final int LANG_KOREAN = 18;
    private static final boolean COMMIT_INPUT = true;
    private static final boolean DISCARD_INPUT = false;
    private static WHighlightMapping highlightMapping = new WHighlightMapping();
    private static HashMap mappingTable;

    static {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        hashMap2.put(InputMethodHighlightMapping.InputMethodHighlightAttribute.INPUT_METHOD_UNDERLINE, InputMethodHighlightMapping.InputMethodHighlightAttribute.UNDERLINE_LOW_DOTTED);
        hashMap.put(InputMethodHighlight.UNSELECTED_RAW_TEXT_HIGHLIGHT, hashMap2);
        hashMap2 = new HashMap();
        hashMap2.put(InputMethodHighlightMapping.InputMethodHighlightAttribute.INPUT_METHOD_UNDERLINE, InputMethodHighlightMapping.InputMethodHighlightAttribute.UNDERLINE_LOW_DOTTED);
        hashMap.put(InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT, hashMap2);
        hashMap2 = new HashMap();
        Color color = new Color(0, 0, 128);
        hashMap2.put(TextAttribute.FOREGROUND, color);
        hashMap2.put(TextAttribute.BACKGROUND, Color.white);
        hashMap2.put(TextAttribute.SWAP_COLORS, TextAttribute.SWAP_COLORS_ON);
        hashMap2.put(InputMethodHighlightMapping.InputMethodHighlightAttribute.INPUT_METHOD_UNDERLINE, InputMethodHighlightMapping.InputMethodHighlightAttribute.UNDERLINE_LOW_ONE_PIXEL);
        hashMap.put(InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT, hashMap2);
        hashMap2 = new HashMap();
        hashMap2.put(InputMethodHighlightMapping.InputMethodHighlightAttribute.INPUT_METHOD_UNDERLINE, InputMethodHighlightMapping.InputMethodHighlightAttribute.UNDERLINE_LOW_GRAY);
        hashMap.put(InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT, hashMap2);
        mappingTable = hashMap;
    }

    public WInputMethod() {
        this.open = this.getOpenStatus(this.context);
    }

    public static final int PRIMARYLANGID(int n) {
        return n & 0x3FF;
    }

    public void activate() {
        this.target = this.getClientComponent();
        WComponentPeer wComponentPeer = this.getNearestNativePeer(this.target);
        if (wComponentPeer == null) {
            return;
        }
        this.enableNativeIME(wComponentPeer, this.context, this.haveActiveClient() ^ true);
    }

    private native int createNativeContext();

    public void deactivate(boolean bl) {
        WComponentPeer wComponentPeer = this.getNearestNativePeer(this.target);
        this.target = null;
        if (wComponentPeer == null) {
            return;
        }
        this.disableNativeIME(wComponentPeer);
    }

    private native void destroyNativeContext(int var1);

    private native void disableNativeIME(WComponentPeer var1);

    public void dispatchEvent(AWTEvent aWTEvent) {
        Component component;
        if (aWTEvent instanceof ComponentEvent && (component = ((ComponentEvent)aWTEvent).getComponent()) == this.target) {
            WComponentPeer wComponentPeer = this.getNearestNativePeer(this.target);
            if (wComponentPeer == null) {
                return;
            }
            this.handleNativeIMEEvent(wComponentPeer, aWTEvent);
        }
    }

    public final void dispose() {
        boolean bl = false;
        if (!this.disposed) {
            WInputMethod wInputMethod = this;
            synchronized (wInputMethod) {
                if (!this.disposed) {
                    bl = true;
                    this.disposed = true;
                }
            }
        }
        if (bl) {
            this.disposeImpl();
        }
    }

    protected void disposeImpl() {
        if (this.context != 0) {
            this.destroyNativeContext(this.context);
            this.context = 0;
        }
    }

    private native void enableNativeIME(WComponentPeer var1, int var2, boolean var3);

    public void endComposition() {
        this.endCompositionNative(this.context, true);
    }

    private native void endCompositionNative(int var1, boolean var2);

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public Object getControlObject() {
        return null;
    }

    private native int getConversionStatus(int var1);

    public static InputMethodHighlightMapping getInputMethodHighlightMapping() {
        return highlightMapping;
    }

    private native int getNativeIMELanguage();

    /*
     * Unable to fully structure code
     */
    private WComponentPeer getNearestNativePeer(Component var1_1) {
        if (var1_1 == null) {
            return null;
        }
        var2_2 = var1_1.getPeer();
        if (var2_2 != null) ** GOTO lbl11
        return null;
lbl-1000:
        // 1 sources

        {
            if ((var1_1 = var1_1.getParent()) == null) {
                return null;
            }
            var2_2 = var1_1.getPeer();
            if (var2_2 != null) continue;
            return null;
lbl11:
            // 2 sources

            ** while (var2_2 instanceof LightweightPeer)
        }
lbl12:
        // 1 sources

        if (var2_2 instanceof WComponentPeer) {
            return (WComponentPeer)var2_2;
        }
        return null;
    }

    private native boolean getOpenStatus(int var1);

    private native void handleNativeIMEEvent(WComponentPeer var1, AWTEvent var2);

    public Point inquireCandidatePosition() {
        Component component = this.getClientComponent();
        if (component == null) {
            return new Point(0, 0);
        }
        if (this.haveActiveClient()) {
            Rectangle rectangle = this.inputContext.getTextLocation(TextHitInfo.leading(0));
            return new Point(rectangle.x, rectangle.y + rectangle.height);
        }
        Point point = component.getLocationOnScreen();
        Dimension dimension = component.getSize();
        return new Point(point.x, point.y + dimension.height);
    }

    public void removeNotify() {
        this.endCompositionNative(this.context, false);
    }

    public void sendInputMethodEvent(int n, String string, int[] nArray, String[] stringArray, int[] nArray2, byte[] byArray, int n2, int n3, int n4) {
        Object object;
        AttributedCharacterIterator attributedCharacterIterator = null;
        if (string != null) {
            int n5;
            object = new AttributedString(string);
            ((AttributedString)object).addAttribute(AttributedCharacterIterator.Attribute.LANGUAGE, Locale.getDefault(), 0, string.length());
            if (nArray != null && stringArray != null && stringArray.length != 0 && nArray.length == stringArray.length + 1 && nArray[0] == 0 && nArray[stringArray.length] == string.length()) {
                n5 = 0;
                while (n5 < nArray.length - 1) {
                    ((AttributedString)object).addAttribute(AttributedCharacterIterator.Attribute.INPUT_METHOD_SEGMENT, new Annotation(null), nArray[n5], nArray[n5 + 1]);
                    ((AttributedString)object).addAttribute(AttributedCharacterIterator.Attribute.READING, new Annotation(stringArray[n5]), nArray[n5], nArray[n5 + 1]);
                    ++n5;
                }
            } else {
                ((AttributedString)object).addAttribute(AttributedCharacterIterator.Attribute.INPUT_METHOD_SEGMENT, new Annotation(null), 0, string.length());
                ((AttributedString)object).addAttribute(AttributedCharacterIterator.Attribute.READING, new Annotation(new String("")), 0, string.length());
            }
            if (nArray2 != null && byArray != null && byArray.length != 0 && nArray2.length == byArray.length + 1 && nArray2[0] == 0 && nArray2[byArray.length] == string.length()) {
                n5 = 0;
                while (n5 < nArray2.length - 1) {
                    InputMethodHighlight inputMethodHighlight;
                    switch (byArray[n5]) {
                        default: {
                            inputMethodHighlight = InputMethodHighlight.UNSELECTED_RAW_TEXT_HIGHLIGHT;
                            break;
                        }
                        case 1: {
                            inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED_TEXT_HIGHLIGHT;
                            break;
                        }
                        case 2: {
                            inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT;
                            break;
                        }
                        case 3: {
                            inputMethodHighlight = InputMethodHighlight.SELECTED_RAW_TEXT_HIGHLIGHT;
                        }
                    }
                    ((AttributedString)object).addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, inputMethodHighlight, nArray2[n5], nArray2[n5 + 1]);
                    ++n5;
                }
            } else {
                ((AttributedString)object).addAttribute(TextAttribute.INPUT_METHOD_HIGHLIGHT, InputMethodHighlight.UNSELECTED_CONVERTED_TEXT_HIGHLIGHT, 0, string.length());
            }
            attributedCharacterIterator = ((AttributedString)object).getIterator();
        }
        if ((object = this.getClientComponent()) == null) {
            return;
        }
        InputMethodEvent inputMethodEvent = new InputMethodEvent((Component)object, n, attributedCharacterIterator, n2, TextHitInfo.leading(n3), TextHitInfo.leading(n4));
        SunToolkit.postEvent(SunToolkit.targetToAppContext(object), inputMethodEvent);
    }

    public void setCharacterSubsets(Character.Subset[] subsetArray) {
        if (subsetArray == null) {
            this.setConversionStatus(this.context, this.cmode);
            this.setOpenStatus(this.context, this.open);
            return;
        }
        Character.Subset subset = subsetArray[0];
        int n = WInputMethod.PRIMARYLANGID(this.getNativeIMELanguage());
        if (n == 17) {
            if (subset == Character.UnicodeBlock.BASIC_LATIN || subset == InputSubset.LATIN_DIGITS) {
                this.setOpenStatus(this.context, false);
            } else {
                int n2;
                if (subset == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || subset == InputSubset.KANJI || subset == Character.UnicodeBlock.HIRAGANA) {
                    n2 = 9;
                } else if (subset == Character.UnicodeBlock.KATAKANA) {
                    n2 = 11;
                } else if (subset == InputSubset.HALFWIDTH_KATAKANA) {
                    n2 = 3;
                } else {
                    return;
                }
                this.setOpenStatus(this.context, true);
                this.setConversionStatus(this.context, n2 |= this.getConversionStatus(this.context) & 0x10);
            }
        } else if (n == 18) {
            if (subset == Character.UnicodeBlock.BASIC_LATIN || subset == InputSubset.LATIN_DIGITS) {
                this.setOpenStatus(this.context, false);
            } else if (subset == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || subset == InputSubset.HANJA || subset == Character.UnicodeBlock.HANGUL_SYLLABLES || subset == Character.UnicodeBlock.HANGUL_JAMO || subset == Character.UnicodeBlock.HANGUL_COMPATIBILITY_JAMO) {
                this.setOpenStatus(this.context, true);
                this.setConversionStatus(this.context, 1);
            }
        } else if (n == 4) {
            if (subset == Character.UnicodeBlock.BASIC_LATIN || subset == InputSubset.LATIN_DIGITS) {
                this.setOpenStatus(this.context, false);
            } else if (subset == Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS || subset == InputSubset.TRADITIONAL_HANZI || subset == InputSubset.SIMPLIFIED_HANZI) {
                this.setOpenStatus(this.context, true);
                this.setConversionStatus(this.context, 1);
            }
        }
    }

    private native void setConversionStatus(int var1, int var2);

    public boolean setLocale(Locale locale) {
        return true;
    }

    private native void setOpenStatus(int var1, boolean var2);

    private static final class WHighlightMapping
    implements InputMethodHighlightMapping {
        WHighlightMapping() {
        }

        public Map mapHighlight(InputMethodHighlight inputMethodHighlight) {
            HashMap hashMap = (HashMap)mappingTable.get(inputMethodHighlight);
            return (Map)hashMap.clone();
        }
    }
}

