/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.io.IOException;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.Properties;
import sun.awt.SunToolkit;
import sun.awt.im.InputMethod;
import sun.awt.im.InputMethodHighlightMapping;
import sun.awt.image.ImageRepresentation;
import sun.awt.windows.WButtonPeer;
import sun.awt.windows.WCanvasPeer;
import sun.awt.windows.WCheckboxMenuItemPeer;
import sun.awt.windows.WCheckboxPeer;
import sun.awt.windows.WChoicePeer;
import sun.awt.windows.WClipboard;
import sun.awt.windows.WCustomCursor;
import sun.awt.windows.WDialogPeer;
import sun.awt.windows.WDragSourceContextPeer;
import sun.awt.windows.WDropTargetContextPeer;
import sun.awt.windows.WEmbeddedFrame;
import sun.awt.windows.WEmbeddedFramePeer;
import sun.awt.windows.WFileDialogPeer;
import sun.awt.windows.WFontMetrics;
import sun.awt.windows.WFontPeer;
import sun.awt.windows.WFramePeer;
import sun.awt.windows.WImage;
import sun.awt.windows.WInputMethod;
import sun.awt.windows.WLabelPeer;
import sun.awt.windows.WListPeer;
import sun.awt.windows.WMenuBarPeer;
import sun.awt.windows.WMenuItemPeer;
import sun.awt.windows.WMenuPeer;
import sun.awt.windows.WMouseDragGestureRecognizer;
import sun.awt.windows.WPanelPeer;
import sun.awt.windows.WPopupMenuPeer;
import sun.awt.windows.WPrintJob;
import sun.awt.windows.WScrollPanePeer;
import sun.awt.windows.WScrollbarPeer;
import sun.awt.windows.WTextAreaPeer;
import sun.awt.windows.WTextFieldPeer;
import sun.awt.windows.WWindowPeer;
import sun.java2d.loops.RasterOutputManager;
import sun.security.action.LoadLibraryAction;

public class WToolkit
extends SunToolkit
implements Runnable {
    static final boolean enableDebug = true;
    static GraphicsConfiguration config = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    boolean dbgTrace = false;
    private static final String propTrace = "WINAWT.Trace";
    boolean dbgVerify = false;
    private static final String propVerify = "WINAWT.VerifyComponents";
    boolean dbgBreak = false;
    private static final String propBreak = "WINAWT.BreakOnFailure";
    boolean dbgHeapCheck = false;
    private static final String propHeapCheck = "WINAWT.HeapCheck";
    WClipboard clipboard;
    private Hashtable cacheFontPeer;
    static ColorModel screenmodel;
    private static final String prefix = "DnD.Cursor.";
    private static final String postfix = ".32x32";
    static /* synthetic */ Class class$java$awt$dnd$MouseDragGestureRecognizer;

    static {
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        WToolkit.initIDs();
    }

    public WToolkit() {
        this.InitializeDebuggingOptions();
        WToolkit wToolkit = this;
        synchronized (wToolkit) {
            new Thread(this, "AWT-Windows").start();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        WDropTargetContextPeer.Initialize();
        WDragSourceContextPeer.Initialize();
    }

    private void InitializeDebuggingOptions() {
        String string = Toolkit.getProperty(propTrace, "false");
        this.dbgTrace = Boolean.valueOf(string);
        string = Toolkit.getProperty(propVerify, "false");
        this.dbgVerify = Boolean.valueOf(string);
        string = Toolkit.getProperty(propBreak, "false");
        this.dbgBreak = Boolean.valueOf(string);
        string = Toolkit.getProperty(propHeapCheck, "false");
        this.dbgHeapCheck = Boolean.valueOf(string);
    }

    public native void beep();

    public int checkImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return WToolkit.checkScrImage(image, n, n2, imageObserver);
    }

    static int checkScrImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (!(image instanceof WImage)) {
            return 32;
        }
        WImage wImage = (WImage)image;
        int n3 = n == 0 || n2 == 0 ? 32 : wImage.getImageRep().check(imageObserver);
        return wImage.check(imageObserver) | n3;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public ButtonPeer createButton(Button button) {
        WButtonPeer wButtonPeer = new WButtonPeer(button);
        SunToolkit.peerMap.put(button, wButtonPeer);
        return wButtonPeer;
    }

    public CanvasPeer createCanvas(Canvas canvas) {
        WCanvasPeer wCanvasPeer = new WCanvasPeer(canvas);
        SunToolkit.peerMap.put(canvas, wCanvasPeer);
        return wCanvasPeer;
    }

    public CheckboxPeer createCheckbox(Checkbox checkbox) {
        WCheckboxPeer wCheckboxPeer = new WCheckboxPeer(checkbox);
        SunToolkit.peerMap.put(checkbox, wCheckboxPeer);
        return wCheckboxPeer;
    }

    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        WCheckboxMenuItemPeer wCheckboxMenuItemPeer = new WCheckboxMenuItemPeer(checkboxMenuItem);
        SunToolkit.peerMap.put(checkboxMenuItem, wCheckboxMenuItemPeer);
        return wCheckboxMenuItemPeer;
    }

    public ChoicePeer createChoice(Choice choice) {
        WChoicePeer wChoicePeer = new WChoicePeer(choice);
        SunToolkit.peerMap.put(choice, wChoicePeer);
        return wChoicePeer;
    }

    public Cursor createCustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException {
        return new WCustomCursor(image, point, string);
    }

    public DialogPeer createDialog(Dialog dialog) {
        WDialogPeer wDialogPeer = new WDialogPeer(dialog);
        SunToolkit.peerMap.put(dialog, wDialogPeer);
        return wDialogPeer;
    }

    public DragGestureRecognizer createDragGestureRecognizer(Class clazz, DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        if ((class$java$awt$dnd$MouseDragGestureRecognizer != null ? class$java$awt$dnd$MouseDragGestureRecognizer : (class$java$awt$dnd$MouseDragGestureRecognizer = WToolkit.class$("java.awt.dnd.MouseDragGestureRecognizer"))).equals(clazz)) {
            return new WMouseDragGestureRecognizer(dragSource, component, n, dragGestureListener);
        }
        return null;
    }

    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        return WDragSourceContextPeer.getDragSourceContextPeer(dragGestureEvent);
    }

    public WEmbeddedFramePeer createEmbeddedFrame(WEmbeddedFrame wEmbeddedFrame) {
        WEmbeddedFramePeer wEmbeddedFramePeer = new WEmbeddedFramePeer(wEmbeddedFrame);
        SunToolkit.peerMap.put(wEmbeddedFrame, wEmbeddedFramePeer);
        return wEmbeddedFramePeer;
    }

    public FileDialogPeer createFileDialog(FileDialog fileDialog) {
        WFileDialogPeer wFileDialogPeer = new WFileDialogPeer(fileDialog);
        SunToolkit.peerMap.put(fileDialog, wFileDialogPeer);
        return wFileDialogPeer;
    }

    public FramePeer createFrame(Frame frame) {
        WFramePeer wFramePeer = new WFramePeer(frame);
        SunToolkit.peerMap.put(frame, wFramePeer);
        return wFramePeer;
    }

    public Image createImage(ImageProducer imageProducer) {
        return new WImage(imageProducer);
    }

    public LabelPeer createLabel(Label label) {
        WLabelPeer wLabelPeer = new WLabelPeer(label);
        SunToolkit.peerMap.put(label, wLabelPeer);
        return wLabelPeer;
    }

    public ListPeer createList(List list) {
        WListPeer wListPeer = new WListPeer(list);
        SunToolkit.peerMap.put(list, wListPeer);
        return wListPeer;
    }

    public MenuPeer createMenu(Menu menu) {
        WMenuPeer wMenuPeer = new WMenuPeer(menu);
        SunToolkit.peerMap.put(menu, wMenuPeer);
        return wMenuPeer;
    }

    public MenuBarPeer createMenuBar(MenuBar menuBar) {
        WMenuBarPeer wMenuBarPeer = new WMenuBarPeer(menuBar);
        SunToolkit.peerMap.put(menuBar, wMenuBarPeer);
        return wMenuBarPeer;
    }

    public MenuItemPeer createMenuItem(MenuItem menuItem) {
        WMenuItemPeer wMenuItemPeer = new WMenuItemPeer(menuItem);
        SunToolkit.peerMap.put(menuItem, wMenuItemPeer);
        return wMenuItemPeer;
    }

    public PanelPeer createPanel(Panel panel) {
        WPanelPeer wPanelPeer = new WPanelPeer(panel);
        SunToolkit.peerMap.put(panel, wPanelPeer);
        return wPanelPeer;
    }

    public PopupMenuPeer createPopupMenu(PopupMenu popupMenu) {
        WPopupMenuPeer wPopupMenuPeer = new WPopupMenuPeer(popupMenu);
        SunToolkit.peerMap.put(popupMenu, wPopupMenuPeer);
        return wPopupMenuPeer;
    }

    public ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        WScrollPanePeer wScrollPanePeer = new WScrollPanePeer(scrollPane);
        SunToolkit.peerMap.put(scrollPane, wScrollPanePeer);
        return wScrollPanePeer;
    }

    public ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        WScrollbarPeer wScrollbarPeer = new WScrollbarPeer(scrollbar);
        SunToolkit.peerMap.put(scrollbar, wScrollbarPeer);
        return wScrollbarPeer;
    }

    public TextAreaPeer createTextArea(TextArea textArea) {
        WTextAreaPeer wTextAreaPeer = new WTextAreaPeer(textArea);
        SunToolkit.peerMap.put(textArea, wTextAreaPeer);
        return wTextAreaPeer;
    }

    public TextFieldPeer createTextField(TextField textField) {
        WTextFieldPeer wTextFieldPeer = new WTextFieldPeer(textField);
        SunToolkit.peerMap.put(textField, wTextFieldPeer);
        return wTextFieldPeer;
    }

    public WindowPeer createWindow(Window window) {
        WWindowPeer wWindowPeer = new WWindowPeer(window);
        SunToolkit.peerMap.put(window, wWindowPeer);
        return wWindowPeer;
    }

    public boolean enableInputMethodsForTextComponent() {
        return true;
    }

    native void eventLoop();

    public Dimension getBestCursorSize(int n, int n2) {
        return new Dimension(WCustomCursor.getCursorWidth(), WCustomCursor.getCursorHeight());
    }

    public ColorModel getColorModel() {
        return WToolkit.getStaticColorModel();
    }

    public FontMetrics getFontMetrics(Font font) {
        if (!RasterOutputManager.usesPlatformFont()) {
            return super.getFontMetrics(font);
        }
        return WFontMetrics.getFontMetrics(font);
    }

    public FontPeer getFontPeer(String string, int n) {
        FontPeer fontPeer = null;
        String string2 = string.toLowerCase();
        if (this.cacheFontPeer != null && (fontPeer = (FontPeer)this.cacheFontPeer.get(String.valueOf(string2) + n)) != null) {
            return fontPeer;
        }
        fontPeer = new WFontPeer(string, n);
        if (fontPeer != null) {
            if (this.cacheFontPeer == null) {
                this.cacheFontPeer = new Hashtable(5, 0.9f);
            }
            if (this.cacheFontPeer != null) {
                this.cacheFontPeer.put(String.valueOf(string2) + n, fontPeer);
            }
        }
        return fontPeer;
    }

    public InputMethod getInputMethodAdapter() {
        return new WInputMethod();
    }

    public InputMethodHighlightMapping getInputMethodHighlightMapping() {
        return WInputMethod.getInputMethodHighlightMapping();
    }

    public int getMaximumCursorColors() {
        return 2;
    }

    public PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        WPrintJob wPrintJob = null;
        try {
            wPrintJob = new WPrintJob(string);
        }
        catch (IOException iOException) {}
        return wPrintJob.initJob();
    }

    protected native int getScreenHeight();

    public native int getScreenResolution();

    protected native int getScreenWidth();

    static ColorModel getStaticColorModel() {
        if (screenmodel == null) {
            screenmodel = WToolkit.makeColorModel();
        }
        return screenmodel;
    }

    public Clipboard getSystemClipboard() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSystemClipboardAccess();
        }
        if (this.clipboard == null) {
            this.clipboard = new WClipboard();
        }
        return this.clipboard;
    }

    public native void init(Thread var1);

    private static native void initIDs();

    protected void initializeDesktopProperties() {
        this.desktopProperties.put("DnD.Autoscroll.initialDelay", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.interval", new Integer(50));
        this.desktopProperties.put("DnD.Autoscroll.cursorHysteresis", new Integer(5));
    }

    protected Object lazilyLoadDesktopProperty(String string) {
        if (string.startsWith(prefix)) {
            String string2 = String.valueOf(string.substring(prefix.length(), string.length())) + postfix;
            try {
                return Cursor.getSystemCustomCursor(string2);
            }
            catch (AWTException aWTException) {
                throw new RuntimeException("cannot load system cursor: " + string2);
            }
        }
        return super.lazilyLoadDesktopProperty(string);
    }

    protected native void loadSystemColors(int[] var1);

    static native ColorModel makeColorModel();

    public boolean prepareImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return WToolkit.prepareScrImage(image, n, n2, imageObserver);
    }

    static boolean prepareScrImage(Image image, int n, int n2, ImageObserver imageObserver) {
        if (n == 0 || n2 == 0) {
            return true;
        }
        if (!(image instanceof WImage)) {
            return true;
        }
        WImage wImage = (WImage)image;
        if (wImage.hasError()) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        ImageRepresentation imageRepresentation = wImage.getImageRep();
        return imageRepresentation.prepare(imageObserver);
    }

    public void run() {
        Thread thread = Thread.currentThread();
        this.init(thread);
        WToolkit wToolkit = this;
        synchronized (wToolkit) {
            this.notifyAll();
        }
        this.eventLoop();
    }

    public native void sync();

    public static final void targetDisposedPeer(Object object, Object object2) {
        SunToolkit.targetDisposedPeer(object, object2);
    }

    public static final Object targetToPeer(Object object) {
        return SunToolkit.targetToPeer(object);
    }
}

