/*
 * Decompiled with CFR 0.152.
 */
package sun.jdbc.odbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import sun.jdbc.odbc.JdbcOdbc;
import sun.jdbc.odbc.JdbcOdbcBoundParam;
import sun.jdbc.odbc.JdbcOdbcConnectionInterface;
import sun.jdbc.odbc.JdbcOdbcLimits;
import sun.jdbc.odbc.JdbcOdbcObject;
import sun.jdbc.odbc.JdbcOdbcSQLWarning;
import sun.jdbc.odbc.JdbcOdbcStatement;

public class JdbcOdbcPreparedStatement
extends JdbcOdbcStatement
implements PreparedStatement {
    protected int numParams;
    protected JdbcOdbcBoundParam[] boundParams;

    public JdbcOdbcPreparedStatement(JdbcOdbcConnectionInterface jdbcOdbcConnectionInterface) {
        super(jdbcOdbcConnectionInterface);
    }

    public synchronized void FreeParams() throws NullPointerException {
        try {
            int n = 1;
            while (n <= this.boundParams.length) {
                if (this.boundParams[n - 1].pA1 != 0) {
                    this.OdbcApi.ReleaseStoredBytes(this.boundParams[n - 1].pA1, this.boundParams[n - 1].pA2);
                }
                if (this.boundParams[n - 1].pB1 != 0) {
                    this.OdbcApi.ReleaseStoredBytes(this.boundParams[n - 1].pB1, this.boundParams[n - 1].pB2);
                }
                if (this.boundParams[n - 1].pC1 != 0) {
                    this.OdbcApi.ReleaseStoredBytes(this.boundParams[n - 1].pC1, this.boundParams[n - 1].pC2);
                }
                if (this.boundParams[n - 1].pS1 != 0) {
                    this.OdbcApi.ReleaseStoredChars(this.boundParams[n - 1].pS1, this.boundParams[n - 1].pS2);
                }
                ++n;
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    public void addBatch() {
        throw new UnsupportedOperationException();
    }

    protected byte[] allocBindBuf(int n, int n2) {
        byte[] byArray = null;
        if (n >= 1 && n <= this.numParams) {
            byArray = this.boundParams[n - 1].allocBindDataBuffer(n2);
        }
        return byArray;
    }

    public void clearParameters() throws SQLException {
        this.OdbcApi.SQLFreeStmt(this.hStmt, 3);
    }

    public synchronized void close() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*Statement.close");
        }
        this.clearMyResultSet();
        try {
            this.clearWarnings();
            if (this.hStmt != 0) {
                this.OdbcApi.SQLFreeStmt(this.hStmt, 1);
                this.hStmt = 0;
                this.FreeParams();
            }
        }
        catch (SQLException sQLException) {}
        this.myConnection.deregisterStatement(this);
    }

    public synchronized boolean execute() throws SQLException {
        int n;
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*PreparedStatement.execute");
        }
        boolean bl = false;
        SQLWarning sQLWarning = null;
        boolean bl2 = false;
        this.clearWarnings();
        try {
            bl2 = this.OdbcApi.SQLExecute(this.hStmt);
            while (bl2) {
                n = this.OdbcApi.SQLParamData(this.hStmt);
                if (n == -1) {
                    bl2 = false;
                    continue;
                }
                this.putParamData(n);
            }
        }
        catch (SQLWarning sQLWarning2) {
            sQLWarning = sQLWarning2;
        }
        while (bl2) {
            n = this.OdbcApi.SQLParamData(this.hStmt);
            if (n == -1) {
                bl2 = false;
                continue;
            }
            this.putParamData(n);
        }
        if (this.getColumnCount() > 0) {
            bl = true;
        }
        return bl;
    }

    public ResultSet executeQuery() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*PreparedStatement.executeQuery");
        }
        ResultSet resultSet = null;
        if (!this.execute()) {
            throw new SQLException("No ResultSet was produced");
        }
        resultSet = this.getResultSet(false);
        return resultSet;
    }

    public ResultSet executeQuery(String string) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*PreparedStatement.executeQuery (" + string + ")");
        }
        throw new SQLException("Driver does not support this function", "IM001");
    }

    public int executeUpdate() throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*PreparedStatement.executeUpdate");
        }
        int n = -1;
        if (this.execute()) {
            throw new SQLException("No row count was produced");
        }
        n = this.getUpdateCount();
        return n;
    }

    public int executeUpdate(String string) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*PreparedStatement.executeUpdate (" + string + ")");
        }
        throw new SQLException("Driver does not support this function", "IM001");
    }

    protected byte[] getDataBuf(int n) {
        byte[] byArray = null;
        if (n >= 1 && n <= this.numParams) {
            byArray = this.boundParams[n - 1].getBindDataBuffer();
        }
        return byArray;
    }

    protected byte[] getLengthBuf(int n) {
        byte[] byArray = null;
        if (n >= 1 && n <= this.numParams) {
            byArray = this.boundParams[n - 1].getBindLengthBuffer();
        }
        return byArray;
    }

    public ResultSetMetaData getMetaData() {
        throw new UnsupportedOperationException();
    }

    public int getParamLength(int n) {
        int n2 = -1;
        if (n >= 1 && n <= this.numParams) {
            n2 = this.OdbcApi.bufferToInt(this.boundParams[n - 1].getBindLengthBuffer());
        }
        return n2;
    }

    public static int getTypeFromObject(Object object) {
        if (object == null) {
            return 0;
        }
        try {
            if ((String)object != null) {
                return 12;
            }
        }
        catch (Exception exception) {}
        try {
            if ((BigDecimal)object != null) {
                return 2;
            }
        }
        catch (Exception exception) {}
        try {
            if ((Boolean)object != null) {
                return -7;
            }
        }
        catch (Exception exception) {}
        try {
            if ((Integer)object != null) {
                return 4;
            }
        }
        catch (Exception exception) {}
        try {
            if ((Long)object != null) {
                return -5;
            }
        }
        catch (Exception exception) {}
        try {
            if ((Float)object != null) {
                return 6;
            }
        }
        catch (Exception exception) {}
        try {
            if ((Double)object != null) {
                return 8;
            }
        }
        catch (Exception exception) {}
        try {
            if ((byte[])object != null) {
                return -3;
            }
        }
        catch (Exception exception) {}
        try {
            if ((Date)object != null) {
                return 91;
            }
        }
        catch (Exception exception) {}
        try {
            if ((Time)object != null) {
                return 92;
            }
        }
        catch (Exception exception) {}
        try {
            if ((Timestamp)object != null) {
                return 93;
            }
        }
        catch (Exception exception) {}
        return 1111;
    }

    protected void initBoundParam() throws SQLException {
        this.numParams = this.OdbcApi.SQLNumParams(this.hStmt);
        if (this.numParams > 0) {
            this.boundParams = new JdbcOdbcBoundParam[this.numParams];
            int n = 0;
            while (n < this.numParams) {
                this.boundParams[n] = new JdbcOdbcBoundParam();
                this.boundParams[n].initialize();
                ++n;
            }
        }
    }

    public void initialize(JdbcOdbc jdbcOdbc, int n) throws SQLException {
        super.initialize(jdbcOdbc, n);
        this.initBoundParam();
    }

    public void initialize(JdbcOdbc jdbcOdbc, int n, int n2, Hashtable hashtable) throws SQLException {
        super.initialize(jdbcOdbc, n, n2, hashtable);
        this.initBoundParam();
    }

    protected void putParamData(int n) throws SQLException, JdbcOdbcSQLWarning {
        int n2 = JdbcOdbcLimits.MAX_PUT_DATA_LENGTH;
        byte[] byArray = new byte[n2];
        boolean bl = false;
        if (n < 1 || n > this.numParams) {
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace("Invalid index for putParamData()");
            }
            return;
        }
        InputStream inputStream = this.boundParams[n - 1].getInputStream();
        int n3 = this.boundParams[n - 1].getInputStreamLen();
        int n4 = this.boundParams[n - 1].getStreamType();
        while (!bl) {
            int n5;
            try {
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("Reading from input stream");
                }
                n5 = inputStream.read(byArray);
                if (JdbcOdbcObject.isTracing()) {
                    JdbcOdbcObject.trace("Bytes read: " + n5);
                }
            }
            catch (IOException iOException) {
                throw new SQLException(iOException.getMessage());
            }
            if (n5 == -1) {
                if (n3 != 0) {
                    throw new SQLException("End of InputStream reached before satisfying length specified when InputStream was set");
                }
                bl = true;
                break;
            }
            if (n5 > n3) {
                n5 = n3;
                bl = true;
            }
            int n6 = n5;
            if (n4 == 2) {
                n6 = n5 / 2;
                int n7 = 0;
                while (n7 < n6) {
                    byArray[n7] = byArray[n7 * 2 + 1];
                    ++n7;
                }
            }
            this.OdbcApi.SQLPutData(this.hStmt, byArray, n6);
            n3 -= n5;
            if (JdbcOdbcObject.isTracing()) {
                JdbcOdbcObject.trace(n3 + " bytes remaining");
            }
            if (n3 != 0) continue;
            bl = true;
        }
    }

    public void setArray(int n, Array array) {
        throw new UnsupportedOperationException();
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setStream(n, inputStream, n2, -1, 1);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setChar(n, 2, bigDecimal.scale(), bigDecimal.toString());
    }

    protected void setBinary(int n, int n2, byte[] byArray) throws SQLException {
        byte[] byArray2 = this.allocBindBuf(n, byArray.length);
        byte[] byArray3 = this.getLengthBuf(n);
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0};
        this.OdbcApi.SQLBindInParameterBinary(this.hStmt, n, n2, byArray, byArray2, byArray3, nArray);
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].pB1 = nArray[2];
        this.boundParams[n - 1].pB2 = nArray[3];
        this.boundParams[n - 1].pC1 = nArray[4];
        this.boundParams[n - 1].pC2 = nArray[5];
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setStream(n, inputStream, n2, -4, 3);
    }

    public void setBlob(int n, Blob blob) {
        throw new UnsupportedOperationException();
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        this.setInt(n, n2);
    }

    public void setByte(int n, byte by) throws SQLException {
        byte[] byArray = this.allocBindBuf(n, 4);
        int[] nArray = new int[]{0, 0};
        this.OdbcApi.SQLBindInParameterInteger(this.hStmt, n, -6, by, byArray, nArray);
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.setBinary(n, -2, byArray);
    }

    protected void setChar(int n, int n2, int n3, String string) throws SQLException {
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[]{};
        try {
            byArray = this.CharsToBytes(this.OdbcApi.charSet, cArray);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        byte[] byArray2 = this.allocBindBuf(n, byArray.length + 1);
        int n4 = this.getPrecision(n2);
        if (n4 < 0 || n4 > JdbcOdbcLimits.DEFAULT_IN_PRECISION) {
            n4 = JdbcOdbcLimits.DEFAULT_IN_PRECISION;
        }
        int[] nArray = new int[]{0, 0, 0, 0};
        this.OdbcApi.SQLBindInParameterString(this.hStmt, n, n2, n4, n3, byArray, byArray2, nArray);
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].pB1 = nArray[2];
        this.boundParams[n - 1].pB2 = nArray[3];
    }

    public void setCharacterStream(int n, Reader reader, int n2) {
        throw new UnsupportedOperationException();
    }

    public void setClob(int n, Clob clob) {
        throw new UnsupportedOperationException();
    }

    public void setDate(int n, Date date) throws SQLException {
        byte[] byArray = this.allocBindBuf(n, 32);
        int[] nArray = new int[]{0, 0};
        this.OdbcApi.SQLBindInParameterDate(this.hStmt, n, date, byArray, nArray);
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
    }

    public void setDate(int n, Date date, Calendar calendar) {
        throw new UnsupportedOperationException();
    }

    public void setDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.setChar(n, 1, 0, bigDecimal.toString());
    }

    public void setDouble(int n, double d) throws SQLException {
        byte[] byArray = this.allocBindBuf(n, 8);
        int[] nArray = new int[]{0, 0};
        this.OdbcApi.SQLBindInParameterDouble(this.hStmt, n, 8, 0, d, byArray, nArray);
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
    }

    public void setFloat(int n, float f) throws SQLException {
        byte[] byArray = this.allocBindBuf(n, 8);
        int[] nArray = new int[]{0, 0};
        this.OdbcApi.SQLBindInParameterFloat(this.hStmt, n, 6, 0, f, byArray, nArray);
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
    }

    public void setInt(int n, int n2) throws SQLException {
        byte[] byArray = this.allocBindBuf(n, 4);
        int[] nArray = new int[]{0, 0};
        this.OdbcApi.SQLBindInParameterInteger(this.hStmt, n, 4, n2, byArray, nArray);
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
    }

    public void setLong(int n, long l) throws SQLException {
        byte[] byArray = this.allocBindBuf(n, 8);
        int[] nArray = new int[]{0, 0};
        this.OdbcApi.SQLBindInParameterFloat(this.hStmt, n, -5, 0, l, byArray, nArray);
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
    }

    public void setNull(int n, int n2) throws SQLException {
        if (JdbcOdbcObject.isTracing()) {
            JdbcOdbcObject.trace("*PreparedStatement.setNull (" + n + "," + n2 + ")");
        }
        byte[] byArray = this.getLengthBuf(n);
        int[] nArray = new int[]{0, 0};
        this.OdbcApi.SQLBindInParameterNull(this.hStmt, n, n2, byArray, nArray);
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public void setObject(int n, Object object) throws SQLException {
        this.setObject(n, object, JdbcOdbcPreparedStatement.getTypeFromObject(object));
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        switch (n2) {
            case 1: {
                this.setString(n, (String)object);
                break;
            }
            case 12: {
                this.setChar(n, n2, 0, (String)object);
                break;
            }
            case -1: {
                this.setChar(n, n2, 0, (String)object);
                break;
            }
            case 2: {
                this.setBigDecimal(n, (BigDecimal)object);
                break;
            }
            case 3: {
                this.setDecimal(n, (BigDecimal)object);
                break;
            }
            case -7: {
                this.setBoolean(n, (Boolean)object);
                break;
            }
            case -6: {
                this.setByte(n, (byte)((Integer)object).intValue());
                break;
            }
            case 5: {
                this.setShort(n, (short)((Integer)object).intValue());
                break;
            }
            case 4: {
                this.setInt(n, (Integer)object);
                break;
            }
            case -5: {
                this.setLong(n, ((Integer)object).longValue());
                break;
            }
            case 7: {
                this.setReal(n, ((Float)object).floatValue());
                break;
            }
            case 6: {
                this.setFloat(n, ((Float)object).floatValue());
                break;
            }
            case 8: {
                this.setDouble(n, (Double)object);
                break;
            }
            case -2: {
                this.setBytes(n, (byte[])object);
                break;
            }
            case -3: {
                this.setBinary(n, n2, (byte[])object);
                break;
            }
            case -4: {
                this.setBinary(n, n2, (byte[])object);
                break;
            }
            case 91: {
                this.setDate(n, (Date)object);
                break;
            }
            case 92: {
                this.setTime(n, (Time)object);
                break;
            }
            case 93: {
                this.setTimestamp(n, (Timestamp)object);
                break;
            }
            default: {
                throw new SQLException("Unknown SQL Type for PreparedStatement.setObject (SQL Type=" + n2);
            }
        }
    }

    public void setReal(int n, float f) throws SQLException {
        byte[] byArray = this.allocBindBuf(n, 8);
        int[] nArray = new int[]{0, 0};
        this.OdbcApi.SQLBindInParameterFloat(this.hStmt, n, 7, 0, f, byArray, nArray);
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
    }

    public void setRef(int n, Ref ref) {
        throw new UnsupportedOperationException();
    }

    public void setShort(int n, short s) throws SQLException {
        byte[] byArray = this.allocBindBuf(n, 4);
        int[] nArray = new int[]{0, 0};
        this.OdbcApi.SQLBindInParameterInteger(this.hStmt, n, 5, s, byArray, nArray);
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
    }

    public void setStream(int n, InputStream inputStream, int n2, int n3, int n4) throws SQLException {
        byte[] byArray = this.getLengthBuf(n);
        byte[] byArray2 = this.allocBindBuf(n, 4);
        int[] nArray = new int[]{0, 0, 0, 0};
        this.OdbcApi.SQLBindInParameterAtExec(this.hStmt, n, n3, n2, byArray2, byArray, nArray);
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
        this.boundParams[n - 1].pB1 = nArray[2];
        this.boundParams[n - 1].pB2 = nArray[3];
        this.boundParams[n - 1].setInputStream(inputStream, n2);
        this.boundParams[n - 1].setStreamType(n4);
    }

    public void setString(int n, String string) throws SQLException {
        this.setChar(n, 1, 0, string);
    }

    public void setTime(int n, Time time) throws SQLException {
        byte[] byArray = this.allocBindBuf(n, 32);
        int[] nArray = new int[]{0, 0};
        this.OdbcApi.SQLBindInParameterTime(this.hStmt, n, time, byArray, nArray);
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
    }

    public void setTime(int n, Time time, Calendar calendar) {
        throw new UnsupportedOperationException();
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        byte[] byArray = this.allocBindBuf(n, 32);
        int[] nArray = new int[]{0, 0};
        this.OdbcApi.SQLBindInParameterTimestamp(this.hStmt, n, timestamp, byArray, nArray);
        this.boundParams[n - 1].pA1 = nArray[0];
        this.boundParams[n - 1].pA2 = nArray[1];
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) {
        throw new UnsupportedOperationException();
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setStream(n, inputStream, n2, -1, 2);
    }
}

