/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.rmi.server.LogStream;
import java.security.PrivilegedAction;
import sun.rmi.transport.Transport;

public class RMIThreadAction
implements PrivilegedAction {
    private Runnable runnable;
    private String name;
    private boolean daemon;
    private static ThreadGroup group;

    public RMIThreadAction(Runnable runnable, String string, boolean bl) {
        this.runnable = runnable;
        this.name = string;
        this.daemon = bl;
    }

    private static synchronized ThreadGroup getThreadGroup() {
        if (group == null) {
            ThreadGroup threadGroup;
            ThreadGroup threadGroup2 = Thread.currentThread().getThreadGroup();
            while ((threadGroup = threadGroup2.getParent()) != null) {
                if (Transport.logLevel >= 20) {
                    LogStream.log("transport").println("RMIThread.getThreadGroup: searching up from ThreadGroup: " + threadGroup2);
                }
                threadGroup2 = threadGroup;
            }
            if (Transport.logLevel >= 20) {
                LogStream.log("transport").println("RMIThread.getThreadGroup: found root ThreadGroup: " + threadGroup2);
            }
            group = threadGroup2;
        }
        return group;
    }

    public Object run() {
        Thread thread = new Thread(RMIThreadAction.getThreadGroup(), this.runnable, "RMI " + this.name);
        thread.setDaemon(this.daemon);
        return thread;
    }
}

