/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.PropertyPermission;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.security.provider.IdentityDatabase;
import sun.security.provider.PolicyParser;
import sun.security.provider.PolicyPermissions;
import sun.security.provider.SystemIdentity;
import sun.security.provider.SystemSigner;
import sun.security.util.Debug;
import sun.security.util.PropertyExpander;

public class PolicyFile
extends Policy {
    private static final Debug debug = Debug.getInstance("policy");
    private Vector policyEntries;
    private Hashtable aliasMapping;
    private boolean initialized = false;
    private boolean expandProperties = true;
    private boolean ignoreIdentityScope = false;
    private static final Class[] PARAMS = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = PolicyFile.class$("java.lang.String")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = PolicyFile.class$("java.lang.String"))};
    private static IdentityScope scope = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$sun$security$provider$PolicyFile;

    static /* synthetic */ boolean access$1(PolicyFile policyFile) {
        return policyFile.initialized;
    }

    private void addGrantEntry(PolicyParser.GrantEntry grantEntry, KeyStore keyStore) {
        if (debug != null) {
            debug.println("Adding policy entry: ");
            debug.println("  signedBy " + grantEntry.signedBy);
            debug.println("  codeBase " + grantEntry.codeBase);
            debug.println();
        }
        try {
            CodeSource codeSource = this.getCodeSource(grantEntry, keyStore);
            if (codeSource == null) {
                return;
            }
            PolicyEntry policyEntry = new PolicyEntry(codeSource);
            Enumeration enumeration = grantEntry.permissionElements();
            while (enumeration.hasMoreElements()) {
                Certificate[] certificateArray;
                PolicyParser.PermissionEntry permissionEntry = (PolicyParser.PermissionEntry)enumeration.nextElement();
                try {
                    certificateArray = PolicyFile.getInstance(permissionEntry.permission, permissionEntry.name, permissionEntry.action);
                    policyEntry.add((Permission)certificateArray);
                    if (debug == null) continue;
                    debug.println("  " + certificateArray);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    certificateArray = permissionEntry.signedBy != null ? this.getCertificates(keyStore, permissionEntry.signedBy) : null;
                    if (certificateArray == null && permissionEntry.signedBy != null) continue;
                    UnresolvedPermission unresolvedPermission = new UnresolvedPermission(permissionEntry.permission, permissionEntry.name, permissionEntry.action, certificateArray);
                    policyEntry.add(unresolvedPermission);
                    if (debug == null) continue;
                    debug.println("  " + unresolvedPermission);
                }
                catch (InvocationTargetException invocationTargetException) {
                    System.err.println("java.security.Policy: error adding Permission " + permissionEntry.permission + " " + invocationTargetException.getTargetException());
                }
                catch (Exception exception) {
                    System.err.println("java.security.Policy: error adding Permission " + permissionEntry.permission + " " + exception);
                }
            }
            this.policyEntries.addElement(policyEntry);
        }
        catch (Exception exception) {
            System.err.println("java.security.Policy: error adding Entry " + grantEntry + " " + exception);
        }
        if (debug != null) {
            debug.println();
        }
    }

    private CodeSource canonicalizeCodebase(CodeSource codeSource, boolean bl) {
        CodeSource codeSource2;
        block6: {
            codeSource2 = codeSource;
            if (codeSource.getLocation() != null && codeSource.getLocation().getProtocol().equalsIgnoreCase("file")) {
                try {
                    File file = new File(codeSource.getLocation().getFile().replace('/', File.separatorChar));
                    if (bl) {
                        codeSource2 = new CodeSource(new File(file.getCanonicalPath()).toURL(), this.getSignerCertificates(codeSource));
                        break block6;
                    }
                    codeSource2 = new CodeSource(new File(file.getCanonicalPath()).toURL(), codeSource.getCertificates());
                }
                catch (IOException iOException) {
                    if (bl) {
                        codeSource2 = new CodeSource(codeSource.getLocation(), this.getSignerCertificates(codeSource));
                    }
                    break block6;
                }
            }
            if (bl) {
                codeSource2 = new CodeSource(codeSource.getLocation(), this.getSignerCertificates(codeSource));
            }
        }
        return codeSource2;
    }

    private boolean checkForTrustedIdentity(final Certificate certificate) {
        Object object;
        Serializable serializable;
        if (certificate == null) {
            return false;
        }
        if (this.ignoreIdentityScope) {
            return false;
        }
        if (scope == null) {
            serializable = class$sun$security$provider$PolicyFile != null ? class$sun$security$provider$PolicyFile : (class$sun$security$provider$PolicyFile = PolicyFile.class$("sun.security.provider.PolicyFile"));
            synchronized (serializable) {
                if (scope == null && (object = (IdentityScope)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return IdentityScope.getSystemScope();
                    }
                })) instanceof IdentityDatabase) {
                    scope = object;
                }
            }
        }
        if (scope == null) {
            this.ignoreIdentityScope = true;
            return false;
        }
        serializable = (Identity)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return scope.getIdentity(certificate.getPublicKey());
            }
        });
        if (this.isTrusted((Identity)serializable)) {
            if (debug != null) {
                debug.println("Adding policy entry for trusted Identity: ");
                AccessController.doPrivileged(new PrivilegedAction((Identity)serializable){
                    private final /* synthetic */ Identity val$id;
                    {
                        this.val$id = identity;
                    }

                    public Object run() {
                        debug.println("  identity = " + this.val$id);
                        return null;
                    }
                });
                debug.println("");
            }
            Certificate[] certificateArray = new Certificate[]{certificate};
            object = new PolicyEntry(new CodeSource(null, certificateArray));
            ((PolicyEntry)object).add(new AllPermission());
            this.policyEntries.addElement(object);
            this.aliasMapping.put(certificate, ((Identity)serializable).getName());
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final synchronized Enumeration elements() {
        return this.policyEntries.elements();
    }

    Certificate[] getCertificates(KeyStore keyStore, String string) {
        Object[] objectArray;
        Vector vector = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken().trim();
            ++n;
            Certificate certificate = null;
            certificate = (Certificate)this.aliasMapping.get(objectArray);
            if (certificate == null && keyStore != null) {
                try {
                    certificate = keyStore.getCertificate((String)objectArray);
                }
                catch (KeyStoreException keyStoreException) {}
                if (certificate != null) {
                    this.aliasMapping.put(objectArray, certificate);
                    this.aliasMapping.put(certificate, objectArray);
                }
            }
            if (certificate == null) continue;
            if (vector == null) {
                vector = new Vector();
            }
            vector.addElement(certificate);
        }
        if (vector != null && n == vector.size()) {
            objectArray = new Certificate[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    CodeSource getCodeSource(PolicyParser.GrantEntry grantEntry, KeyStore keyStore) throws MalformedURLException {
        Certificate[] certificateArray = null;
        if (grantEntry.signedBy != null && (certificateArray = this.getCertificates(keyStore, grantEntry.signedBy)) == null) {
            if (debug != null) {
                debug.println(" no certs for alias " + grantEntry.signedBy + ", ignoring.");
            }
            return null;
        }
        URL uRL = grantEntry.codeBase != null ? new URL(grantEntry.codeBase) : null;
        return this.canonicalizeCodebase(new CodeSource(uRL, certificateArray), false);
    }

    private InputStream getInputStream(URL uRL) throws IOException {
        if ("file".equals(uRL.getProtocol())) {
            String string = uRL.getFile().replace('/', File.separatorChar);
            return new FileInputStream(string);
        }
        return uRL.openStream();
    }

    private static final Permission getInstance(String string, String string2, String string3) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class clazz = Class.forName(string);
        Constructor constructor = clazz.getConstructor(PARAMS);
        return (Permission)constructor.newInstance(new Object[]{string2, string3});
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        return new PolicyPermissions(this, codeSource);
    }

    public void getPermissions(final Permissions permissions, final CodeSource codeSource) {
        Certificate[] certificateArray;
        if (!this.initialized) {
            this.init();
        }
        final CodeSource[] codeSourceArray = new CodeSource[]{null};
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                codeSourceArray[0] = this.canonicalizeCodebase(codeSource, true);
                if (debug != null) {
                    debug.println("evaluate(" + codeSourceArray[0] + ")");
                }
                int n = 0;
                while (n < policyEntries.size()) {
                    PolicyEntry policyEntry = (PolicyEntry)policyEntries.elementAt(n);
                    if (policyEntry.codesource.implies(codeSourceArray[0])) {
                        int n2 = 0;
                        while (n2 < policyEntry.permissions.size()) {
                            Permission permission = (Permission)policyEntry.permissions.elementAt(n2);
                            if (debug != null) {
                                debug.println("  granting " + permission);
                            }
                            permissions.add(permission);
                            ++n2;
                        }
                    }
                    ++n;
                }
                return null;
            }
        });
        if (!this.ignoreIdentityScope && (certificateArray = codeSourceArray[0].getCertificates()) != null) {
            int n = 0;
            while (n < certificateArray.length) {
                if (this.aliasMapping.get(certificateArray[n]) == null && this.checkForTrustedIdentity(certificateArray[n])) {
                    permissions.add(new AllPermission());
                }
                ++n;
            }
        }
    }

    protected Certificate[] getSignerCertificates(CodeSource codeSource) {
        Certificate[] certificateArray = null;
        certificateArray = codeSource.getCertificates();
        if (certificateArray == null) {
            return null;
        }
        int n = 0;
        while (n < certificateArray.length) {
            if (!(certificateArray[n] instanceof X509Certificate)) {
                return codeSource.getCertificates();
            }
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        while (n2 < certificateArray.length) {
            ++n3;
            while (n2 + 1 < certificateArray.length && ((X509Certificate)certificateArray[n2]).getIssuerDN().equals(((X509Certificate)certificateArray[n2 + 1]).getSubjectDN())) {
                ++n2;
            }
            ++n2;
        }
        if (n3 == certificateArray.length) {
            return certificateArray;
        }
        ArrayList arrayList = new ArrayList();
        n2 = 0;
        while (n2 < certificateArray.length) {
            arrayList.add(certificateArray[n2]);
            while (n2 + 1 < certificateArray.length && ((X509Certificate)certificateArray[n2]).getIssuerDN().equals(((X509Certificate)certificateArray[n2 + 1]).getSubjectDN())) {
                ++n2;
            }
            ++n2;
        }
        Object[] objectArray = new Certificate[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    private synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.policyEntries = new Vector();
        this.aliasMapping = new Hashtable(11);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PolicyFile.this.initPolicyFile();
                PolicyFile.this.initialized = true;
                return null;
            }
        });
    }

    private void init(URL uRL) {
        block5: {
            PolicyParser policyParser = new PolicyParser(this.expandProperties);
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.getInputStream(uRL));
                policyParser.read(inputStreamReader);
                inputStreamReader.close();
                KeyStore keyStore = this.initKeyStore(uRL, policyParser.getKeyStoreUrl(), policyParser.getKeyStoreType());
                Enumeration enumeration = policyParser.grantElements();
                while (enumeration.hasMoreElements()) {
                    PolicyParser.GrantEntry grantEntry = (PolicyParser.GrantEntry)enumeration.nextElement();
                    this.addGrantEntry(grantEntry, keyStore);
                }
            }
            catch (PolicyParser.ParsingException parsingException) {
                System.err.println("java.security.Policy: error parsing " + uRL);
                System.err.println("java.security.Policy: " + parsingException.getMessage());
                if (debug != null) {
                    parsingException.printStackTrace();
                }
            }
            catch (Exception exception) {
                if (debug == null) break block5;
                debug.println("error parsing " + uRL);
                debug.println(exception.toString());
                exception.printStackTrace();
            }
        }
    }

    private KeyStore initKeyStore(URL uRL, String string, String string2) {
        if (string != null) {
            try {
                URL uRL2 = null;
                try {
                    uRL2 = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL2 = new URL(uRL, string);
                }
                if (debug != null) {
                    debug.println("reading keystore" + uRL2);
                }
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.getInputStream(uRL2));
                KeyStore keyStore = string2 != null ? KeyStore.getInstance(string2) : KeyStore.getInstance(KeyStore.getDefaultType());
                keyStore.load(bufferedInputStream, null);
                ((InputStream)bufferedInputStream).close();
                return keyStore;
            }
            catch (Exception exception) {
                if (debug != null) {
                    exception.printStackTrace();
                }
                return null;
            }
        }
        return null;
    }

    private void initPolicyFile() {
        Object object;
        boolean bl;
        String string;
        String string2;
        String string3;
        String string4 = Security.getProperty("policy.expandProperties");
        if (string4 != null) {
            this.expandProperties = string4.equalsIgnoreCase("true");
        }
        if ((string3 = Security.getProperty("policy.ignoreIdentityScope")) != null) {
            this.ignoreIdentityScope = string3.equalsIgnoreCase("true");
        }
        if ((string2 = Security.getProperty("policy.allowSystemProperty")) != null && string2.equalsIgnoreCase("true") && (string = System.getProperty("java.security.policy")) != null) {
            block14: {
                bl = false;
                if (string.startsWith("=")) {
                    bl = true;
                    string = string.substring(1);
                }
                try {
                    string = PropertyExpander.expand(string);
                    File file = new File(string);
                    object = file.exists() ? new URL("file:" + file.getCanonicalPath()) : new URL(string);
                    if (debug != null) {
                        debug.println("reading " + object);
                    }
                    this.init((URL)object);
                }
                catch (Exception exception) {
                    if (debug == null) break block14;
                    debug.println("caught exception: " + exception);
                }
            }
            if (bl) {
                if (debug != null) {
                    debug.println("overriding other policies!");
                }
                return;
            }
        }
        int n = 1;
        bl = false;
        while ((object = Security.getProperty("policy.url." + n)) != null) {
            block15: {
                try {
                    object = PropertyExpander.expand((String)object).replace(File.separatorChar, '/');
                    if (debug != null) {
                        debug.println("reading " + (String)object);
                    }
                    this.init(new URL((String)object));
                    bl = true;
                }
                catch (Exception exception) {
                    if (debug == null) break block15;
                    debug.println("error reading policy " + exception);
                    exception.printStackTrace();
                }
            }
            ++n;
        }
        if (!bl) {
            this.initStaticPolicy();
        }
    }

    private void initStaticPolicy() {
        PolicyEntry policyEntry = new PolicyEntry(new CodeSource(null, null));
        policyEntry.add(new SocketPermission("localhost:1024-", "listen"));
        policyEntry.add(new PropertyPermission("java.version", "read"));
        policyEntry.add(new PropertyPermission("java.vendor", "read"));
        policyEntry.add(new PropertyPermission("java.vendor.url", "read"));
        policyEntry.add(new PropertyPermission("java.class.version", "read"));
        policyEntry.add(new PropertyPermission("os.name", "read"));
        policyEntry.add(new PropertyPermission("os.version", "read"));
        policyEntry.add(new PropertyPermission("os.arch", "read"));
        policyEntry.add(new PropertyPermission("file.separator", "read"));
        policyEntry.add(new PropertyPermission("path.separator", "read"));
        policyEntry.add(new PropertyPermission("line.separator", "read"));
        policyEntry.add(new PropertyPermission("java.specification.version", "read"));
        policyEntry.add(new PropertyPermission("java.specification.vendor", "read"));
        policyEntry.add(new PropertyPermission("java.specification.name", "read"));
        policyEntry.add(new PropertyPermission("java.vm.specification.version", "read"));
        policyEntry.add(new PropertyPermission("java.vm.specification.vendor", "read"));
        policyEntry.add(new PropertyPermission("java.vm.specification.name", "read"));
        policyEntry.add(new PropertyPermission("java.vm.version", "read"));
        policyEntry.add(new PropertyPermission("java.vm.vendor", "read"));
        policyEntry.add(new PropertyPermission("java.vm.name", "read"));
        this.policyEntries.addElement(policyEntry);
        try {
            String string = PropertyExpander.expand("file:${java.home}/lib/ext/");
            policyEntry = new PolicyEntry(new CodeSource(new URL(string), null));
            policyEntry.add(new AllPermission());
        }
        catch (Exception exception) {}
    }

    private boolean isTrusted(Identity identity) {
        SystemSigner systemSigner;
        SystemIdentity systemIdentity;
        return identity instanceof SystemIdentity ? (systemIdentity = (SystemIdentity)identity).isTrusted() : identity instanceof SystemSigner && (systemSigner = (SystemSigner)identity).isTrusted();
    }

    public synchronized void refresh() {
        this.initialized = false;
        this.init();
    }

    private static class PolicyEntry {
        CodeSource codesource;
        Vector permissions;

        PolicyEntry(CodeSource codeSource) {
            this.codesource = codeSource;
            this.permissions = new Vector();
        }

        void add(Permission permission) {
            this.permissions.addElement(permission);
        }

        CodeSource getCodeSource() {
            return this.codesource;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(");
            stringBuffer.append(this.getCodeSource());
            stringBuffer.append("\n");
            int n = 0;
            while (n < this.permissions.size()) {
                Permission permission = (Permission)this.permissions.elementAt(n);
                stringBuffer.append("  ");
                stringBuffer.append(permission);
                stringBuffer.append("\n");
                ++n;
            }
            stringBuffer.append(")\n");
            return stringBuffer.toString();
        }
    }
}

