/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.util.Vector;

class DerIndefLenConverter {
    private static final int TAG_MASK = 31;
    private static final int FORM_MASK = 32;
    private static final int CLASS_MASK = 192;
    private static final int LEN_LONG = 128;
    private static final int LEN_MASK = 127;
    private static final int SKIP_EOC_BYTES = 2;
    private byte[] data;
    private byte[] newData;
    private int newDataPos;
    private int dataPos;
    private int dataSize;
    private int index;
    private Vector ndefsList = new Vector();
    private Vector eocList = new Vector();

    DerIndefLenConverter() {
    }

    private void calcLens(int n) {
        int n2;
        int n3;
        int n4 = n / 2;
        boolean bl = true;
        block0: while (bl) {
            n3 = 0;
            while (n3 < n) {
                n2 = (Integer)this.ndefsList.get(n3);
                if (n2 == 0) {
                    this.eocList.set(n3 - 1, this.eocList.get(n3));
                    this.eocList.remove(n3);
                    this.ndefsList.remove(n3);
                    if (n3 == n4) {
                        bl = false;
                        continue block0;
                    }
                }
                ++n3;
            }
        }
        bl = true;
        block2: while (bl) {
            n3 = 0;
            while (n3 < n4) {
                n2 = (Integer)this.ndefsList.get(n3);
                int n5 = (Integer)this.eocList.get(n3);
                if (n2 != 0 && n5 != 0) {
                    Integer n6 = new Integer((Integer)this.eocList.get(n4) - 2);
                    this.eocList.remove(n4);
                    this.ndefsList.remove(n4);
                    int n7 = n3 - 1;
                    this.eocList.set(n7, n6);
                    if (n7 != 0) continue block2;
                    bl = false;
                    continue block2;
                }
                ++n3;
            }
        }
    }

    byte[] convert(byte[] byArray) throws IOException {
        this.data = byArray;
        this.dataPos = 0;
        this.index = 0;
        this.dataSize = this.data.length;
        int n = 0;
        while (this.dataPos < this.dataSize) {
            this.parseTag();
            n = this.parseLength();
            this.parseValue(n);
        }
        this.calcLens(this.index);
        this.newData = new byte[this.dataSize + this.index];
        this.dataPos = 0;
        this.newDataPos = 0;
        this.index = 0;
        while (this.dataPos < this.dataSize) {
            this.writeTag();
            this.writeLengthAndValue();
        }
        int n2 = 1;
        int n3 = 0;
        int n4 = this.newData[n2] & 0xFF;
        if (DerIndefLenConverter.isLongForm(n4)) {
            n4 &= 0x7F;
            while (n4 > 0) {
                n3 = (n3 << 8) + (this.newData[++n2] & 0xFF);
                --n4;
            }
        } else {
            n3 = n4 & 0x7F;
        }
        byte[] byArray2 = new byte[1 + n2 + n3];
        System.arraycopy(this.newData, 0, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private boolean isEOC(int n) {
        return (n & 0x1F) == 0 && (n & 0x20) == 0 && (n & 0xC0) == 0;
    }

    static boolean isIndefinite(int n) {
        return DerIndefLenConverter.isLongForm(n) && (n & 0x7F) == 0;
    }

    static boolean isLongForm(int n) {
        return (n & 0x80) == 128;
    }

    private int parseLength() throws IOException {
        int n;
        int n2 = 0;
        if (this.dataPos == this.dataSize) {
            return n2;
        }
        if (DerIndefLenConverter.isIndefinite(n = this.data[this.dataPos++] & 0xFF)) {
            this.ndefsList.add(this.index, new Integer(this.dataPos));
            this.eocList.add(this.index++, new Integer(0));
            return n2;
        }
        if (DerIndefLenConverter.isLongForm(n)) {
            if ((n &= 0x7F) > 4) {
                throw new IOException("Too much data");
            }
            if (this.dataSize - this.dataPos < n + 1) {
                throw new IOException("Too little data");
            }
            int n3 = 0;
            while (n3 < n) {
                n2 = (n2 << 8) + (this.data[this.dataPos++] & 0xFF);
                ++n3;
            }
        } else {
            n2 = n & 0x7F;
        }
        return n2;
    }

    private void parseTag() {
        if (this.dataPos == this.dataSize) {
            return;
        }
        if (this.isEOC(this.data[this.dataPos]) && this.data[this.dataPos + 1] == 0) {
            this.eocList.add(this.index, new Integer(this.dataPos));
            this.ndefsList.add(this.index++, new Integer(0));
        }
        ++this.dataPos;
    }

    private void parseValue(int n) {
        this.dataPos += n;
    }

    private void writeLength(int n) {
        if (n < 128) {
            this.newData[this.newDataPos++] = (byte)n;
        } else if (n < 256) {
            this.newData[this.newDataPos++] = -127;
            this.newData[this.newDataPos++] = (byte)n;
        } else if (n < 65536) {
            this.newData[this.newDataPos++] = -126;
            this.newData[this.newDataPos++] = (byte)(n >> 8);
            this.newData[this.newDataPos++] = (byte)n;
        } else if (n < 0x1000000) {
            this.newData[this.newDataPos++] = -125;
            this.newData[this.newDataPos++] = (byte)(n >> 16);
            this.newData[this.newDataPos++] = (byte)(n >> 8);
            this.newData[this.newDataPos++] = (byte)n;
        } else {
            this.newData[this.newDataPos++] = -124;
            this.newData[this.newDataPos++] = (byte)(n >> 24);
            this.newData[this.newDataPos++] = (byte)(n >> 16);
            this.newData[this.newDataPos++] = (byte)(n >> 8);
            this.newData[this.newDataPos++] = (byte)n;
        }
    }

    private void writeLengthAndValue() throws IOException {
        int n;
        if (this.dataPos == this.dataSize) {
            return;
        }
        int n2 = 0;
        if (DerIndefLenConverter.isIndefinite(n = this.data[this.dataPos++] & 0xFF)) {
            int n3 = (Integer)this.ndefsList.get(this.index);
            if (n3 == this.dataPos) {
                n2 = (Integer)this.eocList.get(this.index) - n3;
                ++this.index;
                this.writeLength(n2);
                return;
            }
            throw new IOException("Internal corruption, cannot convert to definite length encoding");
        }
        if (DerIndefLenConverter.isLongForm(n)) {
            n &= 0x7F;
            int n4 = 0;
            while (n4 < n) {
                n2 = (n2 << 8) + (this.data[this.dataPos++] & 0xFF);
                ++n4;
            }
        } else {
            n2 = n & 0x7F;
        }
        this.writeLength(n2);
        this.writeValue(n2);
    }

    private void writeTag() {
        byte by;
        if (this.dataPos == this.dataSize) {
            return;
        }
        if (this.isEOC(by = this.data[this.dataPos++]) && this.data[this.dataPos] == 0) {
            ++this.dataPos;
            this.writeTag();
        } else {
            this.newData[this.newDataPos++] = by;
        }
    }

    private void writeValue(int n) {
        int n2 = 0;
        while (n2 < n) {
            this.newData[this.newDataPos++] = this.data[this.dataPos++];
            ++n2;
        }
    }
}

