/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sun.tools.jar.CRC32OutputStream;
import sun.tools.jar.JarException;
import sun.tools.util.CommandLine;

public class Main {
    String program;
    PrintStream out;
    PrintStream err;
    String fname;
    String mname;
    String zname = "";
    String[] files;
    Hashtable filesTable = new Hashtable();
    Vector paths = new Vector();
    Vector v;
    CRC32 crc32 = new CRC32();
    boolean cflag;
    boolean uflag;
    boolean xflag;
    boolean tflag;
    boolean vflag;
    boolean flag0;
    boolean Mflag;
    static final String MANIFEST = "META-INF/MANIFEST.MF";
    static final String MANIFEST_DIR = "META-INF/";
    static final String VERSION = "1.0";
    static final char SEPARATOR = File.separatorChar;

    public Main(PrintStream printStream, PrintStream printStream2, String string) {
        this.out = printStream;
        this.err = printStream2;
        this.program = string;
    }

    private void addCreatedBy(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        if (attributes.getValue(new Attributes.Name("Created-By")) == null) {
            String string = System.getProperty("java.vendor");
            String string2 = System.getProperty("java.version");
            attributes.put(new Attributes.Name("Created-By"), String.valueOf(string2) + " (" + string + ")");
        }
    }

    void addFile(ZipOutputStream zipOutputStream, File file) throws IOException {
        long l;
        String string = file.getPath();
        boolean bl = file.isDirectory();
        if (bl) {
            String string2 = string = string.endsWith(File.separator) ? string : String.valueOf(string) + File.separator;
        }
        if ((string = this.entryName(string)).equals("") || string.equals(".") || string.equals(this.zname)) {
            return;
        }
        if ((string.equals(MANIFEST_DIR) || string.equals(MANIFEST)) && !this.Mflag) {
            if (this.vflag) {
                this.output("ignoring entry " + string);
            }
            return;
        }
        long l2 = l = bl ? 0L : file.length();
        if (this.vflag) {
            this.out.print("adding: " + string + " ");
        }
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(file.lastModified());
        if (l == 0L) {
            zipEntry.setMethod(0);
            zipEntry.setSize(0L);
            zipEntry.setCrc(0L);
        } else if (this.flag0) {
            zipEntry.setSize(l);
            zipEntry.setMethod(0);
            this.crc32File(zipEntry, file);
        }
        zipOutputStream.putNextEntry(zipEntry);
        if (!bl) {
            int n;
            byte[] byArray = new byte[1024];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            while ((n = ((InputStream)bufferedInputStream).read(byArray, 0, byArray.length)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            ((InputStream)bufferedInputStream).close();
        }
        zipOutputStream.closeEntry();
        if (this.vflag) {
            l = zipEntry.getSize();
            long l3 = zipEntry.getCompressedSize();
            this.out.print("(in=" + l + ") (out=" + l3 + ") ");
            if (zipEntry.getMethod() == 8) {
                long l4 = 0L;
                if (l != 0L) {
                    l4 = (l - l3) * 100L / l;
                }
                this.output("(deflated " + l4 + "%)");
            } else {
                this.output("(stored 0%)");
            }
        }
    }

    private void addVersion(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        if (attributes.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
            attributes.put(Attributes.Name.MANIFEST_VERSION, VERSION);
        }
    }

    private void crc32File(ZipEntry zipEntry, File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        byte[] byArray = new byte[1024];
        this.crc32.reset();
        int n = 0;
        int n2 = 0;
        long l = file.length();
        while ((n = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
            n2 += n;
            this.crc32.update(byArray, 0, n);
        }
        ((InputStream)bufferedInputStream).close();
        if (n2 != (int)l) {
            throw new JarException("incorrect length while processing: " + file.getPath());
        }
        zipEntry.setCrc(this.crc32.getValue());
    }

    private void crc32Manifest(ZipEntry zipEntry, Manifest manifest) throws IOException {
        this.crc32.reset();
        CRC32OutputStream cRC32OutputStream = new CRC32OutputStream(this.crc32);
        manifest.write(cRC32OutputStream);
        zipEntry.setSize(cRC32OutputStream.n);
        zipEntry.setCrc(this.crc32.getValue());
    }

    void create(OutputStream outputStream, String[] stringArray, Manifest manifest) throws IOException {
        JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
        if (this.flag0) {
            jarOutputStream.setMethod(0);
        }
        if (manifest != null) {
            if (this.vflag) {
                this.output("added manifest");
            }
            ZipEntry zipEntry = new ZipEntry(MANIFEST_DIR);
            zipEntry.setTime(System.currentTimeMillis());
            zipEntry.setSize(0L);
            zipEntry.setCrc(0L);
            ((ZipOutputStream)jarOutputStream).putNextEntry(zipEntry);
            zipEntry = new ZipEntry(MANIFEST);
            zipEntry.setTime(System.currentTimeMillis());
            if (this.flag0) {
                this.crc32Manifest(zipEntry, manifest);
            }
            ((ZipOutputStream)jarOutputStream).putNextEntry(zipEntry);
            manifest.write(jarOutputStream);
            jarOutputStream.closeEntry();
        }
        int n = 0;
        while (n < stringArray.length) {
            this.addFile(jarOutputStream, new File(stringArray[n]));
            ++n;
        }
        jarOutputStream.close();
    }

    private String entryName(String string) {
        string = string.replace(File.separatorChar, '/');
        String string2 = "";
        int n = 0;
        while (n < this.paths.size()) {
            String string3 = (String)this.paths.elementAt(n);
            if (string.startsWith(string3) && string3.length() > string2.length()) {
                string2 = string3;
            }
            ++n;
        }
        if ((string = string.substring(string2.length())).startsWith("/")) {
            string = string.substring(1);
        } else if (string.startsWith("./")) {
            string = string.substring(2);
        }
        return string;
    }

    protected void error(String string) {
        this.err.println(string);
    }

    void expand(File file, String[] stringArray, Vector vector, Hashtable hashtable) {
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            File file2 = file == null ? new File(stringArray[n]) : new File(file, stringArray[n]);
            if (file2.isFile()) {
                if (!hashtable.contains(file2)) {
                    hashtable.put(this.entryName(file2.getPath()), file2);
                    vector.addElement(file2);
                }
            } else if (file2.isDirectory()) {
                String string = file2.getPath();
                string = string.endsWith(File.separator) ? string : String.valueOf(string) + File.separator;
                hashtable.put(this.entryName(string), file2);
                vector.addElement(file2);
                this.expand(file2, file2.list(), vector, hashtable);
            } else {
                this.error(String.valueOf(String.valueOf(file2)) + ": no such file or directory");
            }
            ++n;
        }
    }

    String[] expand(String[] stringArray) {
        this.v = new Vector();
        this.expand(null, stringArray, this.v, this.filesTable);
        stringArray = new String[this.v.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = ((File)this.v.elementAt(n)).getPath();
            ++n;
        }
        return stringArray;
    }

    void extract(InputStream inputStream, String[] stringArray) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        block0: while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (stringArray == null) {
                this.extractFile(zipInputStream, zipEntry);
                continue;
            }
            String string = zipEntry.getName();
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n].replace(File.separatorChar, '/');
                if (string.startsWith(string2)) {
                    this.extractFile(zipInputStream, zipEntry);
                    continue block0;
                }
                ++n;
            }
        }
    }

    void extractFile(ZipInputStream zipInputStream, ZipEntry zipEntry) throws IOException {
        String string = zipEntry.getName();
        File file = new File(zipEntry.getName().replace('/', File.separatorChar));
        if (zipEntry.isDirectory()) {
            if (!file.exists() && !file.mkdirs() || !file.isDirectory()) {
                throw new IOException(String.valueOf(String.valueOf(file)) + ": could not create directory");
            }
            if (this.vflag) {
                this.output("   created: " + string);
            }
        } else {
            int n;
            Object object;
            if (!(file.getParent() == null || (((File)(object = new File(file.getParent()))).exists() || ((File)object).mkdirs()) && ((File)object).isDirectory())) {
                throw new IOException(String.valueOf(String.valueOf(object)) + ": could not create directory");
            }
            object = new FileOutputStream(file);
            byte[] byArray = new byte[512];
            while ((n = zipInputStream.read(byArray, 0, byArray.length)) != -1) {
                ((OutputStream)object).write(byArray, 0, n);
            }
            zipInputStream.closeEntry();
            ((OutputStream)object).close();
            if (this.vflag) {
                if (zipEntry.getMethod() == 8) {
                    this.output(" extracted: " + string);
                } else {
                    this.output("  inflated: " + string);
                }
            }
        }
    }

    void fatalError(Exception exception) {
        exception.printStackTrace();
    }

    void fatalError(String string) {
        this.error(String.valueOf(this.program) + ": " + string);
    }

    void list(InputStream inputStream, String[] stringArray) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        block0: while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            zipInputStream.closeEntry();
            if (stringArray == null) {
                this.printEntry(zipEntry);
                continue;
            }
            int n = 0;
            while (n < stringArray.length) {
                String string2 = stringArray[n].replace(File.separatorChar, '/');
                if (string.startsWith(string2)) {
                    this.printEntry(zipEntry);
                    continue block0;
                }
                ++n;
            }
        }
    }

    public static void main(String[] stringArray) {
        Main main = new Main(System.out, System.err, "jar");
        System.exit(main.run(stringArray) ? 0 : 1);
    }

    protected void output(String string) {
        this.out.println(string);
    }

    boolean parseArgs(String[] stringArray) {
        int n;
        try {
            stringArray = CommandLine.parse(stringArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.fatalError("can't open: " + fileNotFoundException.getMessage());
            return false;
        }
        catch (IOException iOException) {
            this.fatalError(iOException);
            return false;
        }
        int n2 = 1;
        try {
            String string = stringArray[0];
            if (string.startsWith("-")) {
                string = string.substring(1);
            }
            n = 0;
            while (n < string.length()) {
                switch (string.charAt(n)) {
                    case 'c': {
                        if (this.xflag || this.tflag || this.uflag) {
                            this.usageError();
                            return false;
                        }
                        this.cflag = true;
                        break;
                    }
                    case 'u': {
                        if (this.cflag || this.xflag || this.tflag) {
                            this.usageError();
                            return false;
                        }
                        this.uflag = true;
                        break;
                    }
                    case 'x': {
                        if (this.cflag || this.uflag || this.tflag) {
                            this.usageError();
                            return false;
                        }
                        this.xflag = true;
                        break;
                    }
                    case 't': {
                        if (this.cflag || this.uflag || this.xflag) {
                            this.usageError();
                            return false;
                        }
                        this.tflag = true;
                        break;
                    }
                    case 'M': {
                        this.Mflag = true;
                        break;
                    }
                    case 'v': {
                        this.vflag = true;
                        break;
                    }
                    case 'f': {
                        this.fname = stringArray[n2++];
                        break;
                    }
                    case 'm': {
                        this.mname = stringArray[n2++];
                        break;
                    }
                    case '0': {
                        this.flag0 = true;
                        break;
                    }
                    default: {
                        this.error("Illegal option: " + string.charAt(n));
                        this.usageError();
                        return false;
                    }
                }
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.usageError();
            return false;
        }
        if (!(this.cflag || this.tflag || this.xflag || this.uflag)) {
            this.error("One of options -{ctxu} must be specified.");
            this.usageError();
            return false;
        }
        int n3 = stringArray.length - n2;
        if (n3 > 0) {
            n = 0;
            String[] stringArray2 = new String[n3];
            try {
                int n4 = n2;
                while (n4 < stringArray.length) {
                    if (stringArray[n4].equals("-C")) {
                        String string;
                        string = (string = stringArray[++n4]).endsWith(File.separator) ? string : String.valueOf(string) + File.separator;
                        this.paths.addElement(string.replace(File.separatorChar, '/'));
                        stringArray2[n++] = String.valueOf(string) + stringArray[++n4];
                    } else {
                        stringArray2[n++] = stringArray[n4];
                    }
                    ++n4;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.usageError();
                return false;
            }
            this.files = new String[n];
            System.arraycopy(stringArray2, 0, this.files, 0, n);
        } else {
            if (this.cflag) {
                this.error("'c' flag requires that input files be specified!");
                this.usageError();
                return false;
            }
            if (this.uflag) {
                if (this.mname != null) {
                    return true;
                }
                this.error("'u' flag requires manifest or input files be specified!");
                this.usageError();
                return false;
            }
        }
        return true;
    }

    void printEntry(ZipEntry zipEntry) throws IOException {
        if (this.vflag) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = Long.toString(zipEntry.getSize());
            int n = 6 - string.length();
            while (n > 0) {
                stringBuffer.append(' ');
                --n;
            }
            stringBuffer.append(string).append(' ').append(new Date(zipEntry.getTime()).toString());
            stringBuffer.append(' ').append(zipEntry.getName());
            this.output(stringBuffer.toString());
        } else {
            this.output(zipEntry.getName());
        }
    }

    public synchronized boolean run(String[] stringArray) {
        boolean bl = true;
        if (!this.parseArgs(stringArray)) {
            return false;
        }
        try {
            if ((this.cflag || this.uflag) && this.fname != null) {
                this.zname = this.fname.replace(File.separatorChar, '/');
                if (this.zname.startsWith("./")) {
                    this.zname = this.zname.substring(2);
                }
            }
            if (this.cflag) {
                FileOutputStream fileOutputStream;
                Manifest manifest = null;
                FileInputStream fileInputStream = null;
                if (!this.Mflag) {
                    if (this.mname != null) {
                        fileInputStream = new FileInputStream(this.mname);
                        manifest = new Manifest(new BufferedInputStream(fileInputStream));
                    } else {
                        manifest = new Manifest();
                    }
                    this.addVersion(manifest);
                    this.addCreatedBy(manifest);
                }
                if (this.fname != null) {
                    fileOutputStream = new FileOutputStream(this.fname);
                } else {
                    fileOutputStream = new FileOutputStream(FileDescriptor.out);
                    if (this.vflag) {
                        this.vflag = false;
                    }
                }
                this.create(new BufferedOutputStream(fileOutputStream), this.expand(this.files), manifest);
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
                ((OutputStream)fileOutputStream).close();
            } else if (this.uflag) {
                FileOutputStream fileOutputStream;
                FileInputStream fileInputStream;
                String string;
                File file = null;
                File file2 = null;
                if (this.fname != null) {
                    file = new File(this.fname);
                    string = file.getParent();
                    file2 = File.createTempFile("tmp", null, new File(string == null ? "." : string));
                    fileInputStream = new FileInputStream(file);
                    fileOutputStream = new FileOutputStream(file2);
                } else {
                    fileInputStream = new FileInputStream(FileDescriptor.in);
                    fileOutputStream = new FileOutputStream(FileDescriptor.out);
                    this.vflag = false;
                }
                string = !this.Mflag && this.mname != null ? new FileInputStream(this.mname) : null;
                this.expand(this.files);
                this.update(fileInputStream, new BufferedOutputStream(fileOutputStream), (InputStream)((Object)string));
                fileInputStream.close();
                fileOutputStream.close();
                if (string != null) {
                    ((InputStream)((Object)string)).close();
                }
                if (this.fname != null) {
                    file.delete();
                    if (!file2.renameTo(file)) {
                        file2.delete();
                        throw new IOException("Error in writing existing jar file");
                    }
                    file2.delete();
                }
            } else if (this.xflag || this.tflag) {
                FileInputStream fileInputStream = this.fname != null ? new FileInputStream(this.fname) : new FileInputStream(FileDescriptor.in);
                if (this.xflag) {
                    this.extract(new BufferedInputStream(fileInputStream), this.files);
                } else {
                    this.list(new BufferedInputStream(fileInputStream), this.files);
                }
                ((InputStream)fileInputStream).close();
            }
        }
        catch (IOException iOException) {
            this.fatalError(iOException);
            bl = false;
        }
        catch (Error error) {
            error.printStackTrace();
            bl = false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            bl = false;
        }
        this.out.flush();
        this.err.flush();
        return bl;
    }

    void update(InputStream inputStream, OutputStream outputStream, InputStream inputStream2) throws IOException {
        Object object;
        Hashtable hashtable = this.filesTable;
        Vector vector = this.v;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
        ZipEntry zipEntry = null;
        boolean bl = false;
        byte[] byArray = new byte[1024];
        int n = 0;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            if (this.Mflag && string.toUpperCase().equals(MANIFEST)) continue;
            if (inputStream2 != null && string.toUpperCase().equals(MANIFEST)) {
                bl = true;
                object = new Manifest(zipInputStream);
                ((Manifest)object).read(inputStream2);
                this.updateManifest((Manifest)object, jarOutputStream);
                continue;
            }
            if (!hashtable.containsKey(string)) {
                object = new ZipEntry(string);
                ((ZipEntry)object).setMethod(zipEntry.getMethod());
                ((ZipEntry)object).setTime(zipEntry.getTime());
                ((ZipEntry)object).setComment(zipEntry.getComment());
                ((ZipEntry)object).setExtra(zipEntry.getExtra());
                if (zipEntry.getMethod() == 0) {
                    ((ZipEntry)object).setSize(zipEntry.getSize());
                    ((ZipEntry)object).setCrc(zipEntry.getCrc());
                }
                ((ZipOutputStream)jarOutputStream).putNextEntry((ZipEntry)object);
                while ((n = zipInputStream.read(byArray, 0, byArray.length)) != -1) {
                    jarOutputStream.write(byArray, 0, n);
                }
                continue;
            }
            this.addFile(jarOutputStream, (File)hashtable.get(string));
            hashtable.remove(string);
        }
        if (!hashtable.isEmpty()) {
            int n2 = 0;
            while (n2 < vector.size()) {
                object = (File)vector.elementAt(n2);
                if (hashtable.containsValue(object)) {
                    this.addFile(jarOutputStream, (File)object);
                }
                ++n2;
            }
        }
        if (!bl && inputStream2 != null) {
            this.updateManifest(new Manifest(inputStream2), jarOutputStream);
        }
        jarOutputStream.close();
    }

    private void updateManifest(Manifest manifest, ZipOutputStream zipOutputStream) throws IOException {
        this.addVersion(manifest);
        this.addCreatedBy(manifest);
        ZipEntry zipEntry = new ZipEntry(MANIFEST);
        zipEntry.setTime(System.currentTimeMillis());
        if (this.flag0) {
            zipEntry.setMethod(0);
            this.crc32Manifest(zipEntry, manifest);
        }
        zipOutputStream.putNextEntry(zipEntry);
        manifest.write(zipOutputStream);
        if (this.vflag) {
            this.output("updated manifest");
        }
    }

    void usageError() {
        this.error("Usage: jar {ctxu}[vfm0M] [jar-file] [manifest-file] [-C dir] files ...");
        this.error("Options:");
        this.error("  -c  create new archive");
        this.error("  -t  list table of contents for archive");
        this.error("  -x  extract named (or all) files from archive");
        this.error("  -u  update existing archive");
        this.error("  -v  generate verbose output on standard output");
        this.error("  -f  specify archive file name");
        this.error("  -m  include manifest information from specified manifest file");
        this.error("  -0  store only; use no ZIP compression");
        this.error("  -M  Do not create a manifest file for the entries");
        this.error("  -C  change to the specified directory and include the following file");
        this.error("If any file is a directory then it is processed recursively.");
        this.error("The manifest file name and the archive file name needs to be specified");
        this.error("in the same order the 'm' and 'f' flags are specified.\n");
        this.error("Example 1: to archive two class files into an archive called classes.jar: ");
        this.error("     jar cvf classes.jar Foo.class Bar.class ");
        this.error("Example 2: use an existing manifest file 'mymanifest' and archive all the");
        this.error("         files in the foo/ directory into 'classes.jar': ");
        this.error("     jar cvfm classes.jar mymanifest -C foo/ .");
    }
}

