/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.InputMethodEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.swing.JTextArea;

class CTextArea
extends JTextArea
implements MouseListener,
KeyListener {
    static boolean m_bHebrew = false;
    public static final Font HebrewFont = new Font("Courier", 0, 14);
    public static final Font SystemFont = new Font("SansSerif", 0, 12);
    String m_oldText;
    private boolean m_bNumeric = false;
    private boolean m_bDirty = false;
    private int m_nLastCaretPos;
    private int m_nMaxChar;
    private boolean m_bNum;
    private boolean m_bSwitched;
    private String m_strLabel = "";
    public boolean m_highLighted = false;
    char[] chartab = new char[]{'\u00f9', '\u00a3', '\u00e1', '\u00e2', '\u00a2', '\u00eb', '\u00f2', '\u00e9', '\u00ef', '\u00e7', '\u00ec', '\u00ea', '\u00a4', '\u00ee', '\u00ed', '\u00f4', '\\', '\u00f8', '\u00e3', '\u00e0', '\u00e5', '\u00a1', '\'', '\u00f1', '\u00e6', '\u00e8', '\u0000', '\u0000', '\u0000'};

    public void setNumeric(boolean bl) {
        this.m_bNumeric = bl;
    }

    public void setText(String string) {
        super.setText(string);
        this.m_oldText = string;
        this.m_bDirty = false;
    }

    public void setMaxChar(int n) {
        this.m_nMaxChar = n;
    }

    public void setLabel(String string) {
        this.m_strLabel = string;
    }

    public String getSQLText() {
        String string = "";
        String string2 = super.getText();
        int n = 0;
        while (n < string2.length()) {
            char c = string2.charAt(n);
            string = c == '\'' ? string + "''" : string + c;
            ++n;
        }
        if (this.m_nMaxChar > 0 && string.length() > this.m_nMaxChar) {
            string = string.substring(0, this.m_nMaxChar);
        }
        return string;
    }

    public boolean isDirty() {
        return this.m_bDirty;
    }

    public void setDirty(boolean bl) {
        this.m_bDirty = bl;
    }

    public boolean allowedHebrewChar(char[] cArray) {
        char[] cArray2 = new char[]{'-', '\u00e4', ',', '.', '\u00df', '\u00f6', '\u0000'};
        char[] cArray3 = new char[]{'.', ',', '\u00fa', '\u00f5', '-', '\u00f3', '\u0000'};
        String string = " <>_~^\u00b0{[]}\\!\"\u00a7$%&/()=?`\u00b4+*#';:";
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < string.length()) {
            if (cArray[0] != string.charAt(n++)) continue;
            bl = true;
            return true;
        }
        n = 0;
        while (cArray2[n] != '\u0000') {
            if (!bl2 && cArray2[n] == cArray[0]) {
                bl = true;
                bl2 = true;
                cArray[0] = cArray3[n];
            }
            ++n;
        }
        if (!bl) {
            boolean bl3 = bl = cArray[0] >= 'a' && cArray[0] <= 'z';
        }
        if (!bl2 && bl) {
            cArray[0] = this.chartab[cArray[0] - 97];
        }
        return bl;
    }

    public boolean isNumber(char c) {
        return c >= '0' && c <= '9' || c == '.';
    }

    protected void showEditWnd() {
        editWnd editWnd2 = new editWnd(this.getText(), this.m_strLabel);
        editWnd2.setNumeric(this.m_bNumeric);
        editWnd2.setMaxChar(this.m_nMaxChar);
        this.m_highLighted = true;
        this.setSelectionStart(0);
        this.setSelectionEnd(this.getText().length());
        this.repaint();
        editWnd2.setDirty(this.m_bDirty);
        editWnd2.show();
        this.m_highLighted = false;
        this.setText(editWnd2.getText());
        this.m_bDirty = editWnd2.isDirty();
        this.setSelectionStart(0);
        this.setCaretPosition(0);
        this.repaint();
        editWnd.setActive(false);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (!editWnd.isActive() && this.getText().indexOf(10) > 0) {
            this.showEditWnd();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!editWnd.isActive() && this.isEnabled() && this.m_strLabel.length() > 0 && (mouseEvent.getModifiers() == 17 || mouseEvent.getModifiers() == 4) && mouseEvent.getClickCount() == 1) {
            this.showEditWnd();
        }
    }

    protected void processInputMethodEvent(InputMethodEvent inputMethodEvent) {
        String string;
        AttributedCharacterIterator attributedCharacterIterator = inputMethodEvent.getText();
        int n = inputMethodEvent.getCommittedCharacterCount();
        this.m_oldText = this.getText();
        if (this.m_nMaxChar > 0 && this.m_oldText.length() >= this.m_nMaxChar) {
            return;
        }
        char c = attributedCharacterIterator.current();
        if (c == ' ' && this.m_bSwitched) {
            this.m_bSwitched = false;
            return;
        }
        char[] cArray = new char[]{c};
        if (!this.m_bNumeric && m_bHebrew) {
            attributedCharacterIterator.setIndex(n - 1);
            if (this.allowedHebrewChar(cArray)) {
                if (this.m_bNum) {
                    this.setCaretPosition(this.m_nLastCaretPos);
                    this.m_bNum = false;
                }
                string = new String(cArray);
                AttributedString attributedString = new AttributedString(string);
                InputMethodEvent inputMethodEvent2 = new InputMethodEvent((Component)inputMethodEvent.getSource(), inputMethodEvent.getID(), attributedString.getIterator(), inputMethodEvent.getCommittedCharacterCount(), inputMethodEvent.getCaret(), inputMethodEvent.getVisiblePosition());
                super.processInputMethodEvent(inputMethodEvent2);
                this.m_bDirty = true;
                int n2 = this.getCaretPosition();
                if (n2 > 0) {
                    --n2;
                }
                this.setCaretPosition(n2);
            }
            if (this.isNumber(cArray[0])) {
                if (!this.m_bNum) {
                    this.m_nLastCaretPos = this.getCaretPosition();
                    this.m_bNum = true;
                }
                super.processInputMethodEvent(inputMethodEvent);
                this.m_bDirty = true;
            }
        } else {
            if (this.m_bNumeric && this.isNumber(cArray[0])) {
                super.processInputMethodEvent(inputMethodEvent);
            }
            this.m_bDirty = true;
        }
        string = this.getText();
        if (this.m_oldText != null && string.compareTo(this.m_oldText) != 0) {
            this.m_bDirty = true;
            this.m_oldText = string;
            MainPanel.m_btnUndo.setEnabled(this.isDirty());
            MainPanel.m_btnSave.setEnabled(this.isDirty());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isShiftDown() && keyEvent.getKeyChar() == ' ') {
            m_bHebrew = !m_bHebrew;
            this.setCaretPosition(this.getText().length());
            this.m_bSwitched = true;
            MainPanel.setEditColor(m_bHebrew);
        }
    }

    public void setEditColor(boolean bl) {
        if (!this.m_bNumeric) {
            this.setCaretColor(bl ? Color.red : Color.black);
        }
    }

    public CTextArea() {
        this.setFont(HebrewFont);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.m_bSwitched = false;
        this.m_nMaxChar = 0;
    }
}

