/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;

public class PhotographiePanel
extends CMyPanel {
    private static char[] chFieldTypes = new char[]{'s', 's', 's', 's', 's', 's', 's', 's', 'n', 'n', 'n', 'n', 'n', 's', 's', 's', 's'};
    private static int[] nMaxLength = new int[]{255, 255, 10, 50, 100, 100, 10, 50, -1, -1, -1, -1, -1, 100, 255, 255, 4000};
    JScrollPane m_scrollPane;
    JLabel m_imageLabel;
    JButton btnZoom;
    JPanel m_thisPanel;
    JPanel leftPanel;
    JPanel rightPanel;
    private long m_lPictureThumb;
    private long m_lPictureLow;
    private long m_lPictureHigh;
    private long m_lSizeM;
    private long m_lSizeH;
    private String[][] strLabels = new String[][]{{"Name", "Weitere Namensangaben", "Aufnahme-Datum", "Photograph", "Objektrecht", "Bildrecht", "Bearbeitungsdatum", "Bildformat/Aufl\u00f6sung (dpi)", "Satzspiegelbreite (mm)", "Satzspiegelh\u00f6he (mm)", "Columnenanzahl", "Lettern pro Zeile(min)", "Lettern pro Zeile(max)", "Rohdaten", "Besonderheiten", "Weitere Hinweise", "Anmerkungen"}, {"Name", "Weitere Namensangaben", "Aufnahme-Datum", "Photograph", "Objektrecht", "Bildrecht", "Bearbeitungsdatum", "Bildformat/Aufl\u00f6sung", "Satzspiegelbreite", "Satzspiegelh\u00f6he", "Columnenanzahl", "Lettern pro Zeile(min)", "Lettern pro Zeile(max)", "Rohdaten", "Besonderheiten", "Weitere Hinweise", "Anmerkungen"}, {"\u00ed\u00f9", "\u00ed\u00e9\u00f4\u00f1\u00e5\u00f0 \u00fa\u00e5\u00ee\u00f9", "\u00ed\u00e5\u00ec\u00e9\u00dd\u00de \u00ea\u00e9\u00f8\u00e0\u00fa", "\u00ed\u00ec\u00dd", "Objektrecht", "Bildrecht", "\u00e3\u00e5\u00e1\u00e9\u00f2\u00de \u00ea\u00e9\u00f8\u00e0\u00fa", "Bildformat/Aufl\u00f6sung", "\u00f8\u00e3\u00f1\u00de \u00fa\u00e5\u00e0\u00f8 \u00e1\u00e7\u00e5\u00f8", "\u00f8\u00e3\u00f1\u00de \u00fa\u00e5\u00e0\u00f8 \u00de\u00e1\u00e5\u00e2", "\u00ed\u00e9\u00f8\u00e5\u00e8\u00de \u00f8\u00f4\u00f1\u00ee", "(.\u00f0\u00e9\u00ee)\u00de\u00f8\u00e5\u00f9\u00ec \u00fa\u00e5\u00e9\u00fa\u00e5\u00e0 \u00f8\u00f4\u00f1\u00ee", "(.\u00f1\u00f7\u00ee)\u00de\u00f8\u00e5\u00f9\u00ec \u00fa\u00e5\u00e9\u00fa\u00e5\u00e0 \u00f8\u00f4\u00f1\u00ee", "\u00e9\u00f0\u00e5\u00f9\u00e0\u00f8 \u00f5\u00e1\u00e5\u00f7", "\u00ed\u00e9\u00e3\u00e7\u00e5\u00e9\u00ee \u00ed\u00e9\u00f0\u00ee\u00e9\u00f1", "\u00fa\u00e5\u00f4\u00f1\u00e5\u00f0 \u00fa\u00e5\u00f8\u00f2\u00de", "\u00fa\u00e5\u00f8\u00f2\u00de"}};
    private String[] strFields = new String[]{"NAME", "NAME2", "AUFNAHME_DATUM", "PHOTOGRAPH", "OBJEKTRECHT", "BILDRECHT", "BEARB_DATUM", "BILDFRMT", "SATZSPIEGLBR_B", "SATZSPIEGLBR_H", "COLUMNANZ", "LETTERANZ_MIN", "LETTERANZ_MAX", "ROHDATEN", "BESHEIT", "WEITEREHINW", "ANMERKUNGEN"};

    public JPanel buildAllPanels() {
        GridLayout gridLayout = new GridLayout(1, 0);
        this.leftPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.m_thisPanel = new JPanel();
        this.m_thisPanel.setLayout(gridLayout);
        this.rightPanel = this.buildPicturePanel();
        this.leftPanel = this.buildEditPanel();
        this.m_thisPanel.add(this.leftPanel);
        this.m_thisPanel.add(this.rightPanel);
        return this.m_thisPanel;
    }

    public JPanel buildEditPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        jPanel.setBorder(new TitledBorder("Photographie"));
        int n = this.getEditLength();
        int n2 = 0;
        while (n2 < this.TEXTFIELDS) {
            this.m_textField[n2] = new CTextArea();
            this.m_label[n2] = new myLabel(this.m_strLabels[MainPanel.m_nLanguage][n2], 4);
            this.m_textField[n2].setLabel(this.m_label[n2].getText());
            this.m_label[n2].setBounds(0, 21 + 21 * n2, 150, 16);
            this.m_label[n2].setFont(CTextArea.SystemFont);
            this.m_label[n2].setOwner(this);
            jPanel.add(this.m_label[n2]);
            this.m_editPane[n2] = new JScrollPane(this.m_textField[n2], 20, 31);
            if (n2 != this.TEXTFIELDS - 1) {
                this.m_editPane[n2].setBounds(160, 21 + 21 * n2, n, 24);
            } else {
                this.m_editPane[n2].setBounds(160, 21 + n2 * 21, n, 80);
            }
            jPanel.add(this.m_editPane[n2]);
            if (this.m_chFieldTypes[n2] == 'n') {
                this.m_label[n2].setNumeric(true);
                this.m_textField[n2].setNumeric(true);
            }
            this.m_textField[n2].setMaxChar(nMaxLength[n2]);
            this.m_label[n2].setDBField(this.m_strFields[n2]);
            this.m_label[n2].setName(this.m_label[n2].getText());
            this.m_label[n2].setTextArea(this.m_textField[n2]);
            ++n2;
        }
        return jPanel;
    }

    public JPanel buildPicturePanel() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        TitledBorder titledBorder = new TitledBorder("Photographie");
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BorderLayout());
        this.m_scrollPane = new JScrollPane();
        JPanel jPanel3 = this.buildControlPanel();
        jPanel.add((Component)this.m_scrollPane, "Center");
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    public JPanel buildControlPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(MainPanel.lightLoweredBorder);
        jPanel.setAlignmentY(0.0f);
        jPanel.setLayout(new FlowLayout(1));
        this.btnZoom = new JButton("Zoom");
        PhotographiePanel photographiePanel = this;
        if (photographiePanel == null) {
            throw null;
        }
        this.btnZoom.addActionListener(new ActionListener(photographiePanel){
            private final /* synthetic */ PhotographiePanel this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.zoomPressed();
            }
            {
                this.this$0 = photographiePanel;
                this.constructor$0(photographiePanel);
            }

            public void constructor$0(PhotographiePanel photographiePanel) {
            }
        });
        jPanel.add(this.btnZoom);
        JButton jButton = new JButton("Replace");
        PhotographiePanel photographiePanel2 = this;
        if (photographiePanel2 == null) {
            throw null;
        }
        jButton.addActionListener(new ActionListener(photographiePanel2){
            private final /* synthetic */ PhotographiePanel this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.replacePressed();
            }
            {
                this.this$0 = photographiePanel;
                this.constructor$0(photographiePanel);
            }

            public void constructor$0(PhotographiePanel photographiePanel) {
            }
        });
        if (!MainPanel.m_bReadMode) {
            jPanel.add(jButton);
        }
        return jPanel;
    }

    public void loadImages() {
        ImageLoaderThread imageLoaderThread = new ImageLoaderThread(this.m_lPictureLow, 2, 0, this.m_lBuchID, 1);
        imageLoaderThread.setSize(this.m_lSizeM);
        imageLoaderThread.run();
        if (ImageLoader.m_imgLow != null) {
            this.m_imageLabel = new JLabel(ImageLoader.m_imgLow);
            this.m_scrollPane.setViewportView(this.m_imageLabel);
            this.revalidate();
        } else {
            this.m_scrollPane.setViewportView(null);
        }
    }

    public void zoomPressed() {
        this.btnZoom.setCursor(MainPanel.cursorWait);
        ImageLoader.m_imgHigh = null;
        ImageLoader imageLoader = new ImageLoader(this.m_lPictureHigh, 3, 0, 3, this.m_lBuchID);
        imageLoader.setType(1);
        imageLoader.setSize(this.m_lSizeH);
        imageLoader.start();
        imageLoader.end();
        this.setCursor(MainPanel.cursorDefault);
        PictureDialog pictureDialog = new PictureDialog(ImageLoader.m_imgHigh);
        this.btnZoom.setCursor(MainPanel.cursorDefault);
        pictureDialog.show();
    }

    public void replacePressed() {
        ReplaceDialog replaceDialog = new ReplaceDialog(this.m_mainPanel);
        replaceDialog.setThumbInfo(this.m_lPictureThumb, this.m_lPictureLow, this.m_lPictureHigh, this.m_lID, 1);
        replaceDialog.show();
    }

    public String getExtraFilter() {
        if (MainPanel.m_cbxSearch.isSelected()) {
            return "";
        }
        return "BUCH_ID = " + MainPanel.getCurrentID();
    }

    public void doAfterSelect() {
        this.loadImages();
    }

    public void clearFields() {
        ImageLoader.clearImages();
        this.m_lPictureHigh = -1L;
        this.m_lPictureLow = -1L;
        this.m_scrollPane.setViewportView(null);
        this.revalidate();
        super.clearFields();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void DB2Fields() {
        this.m_bFieldsReady = false;
        if (this.m_ResultSet == null) {
            return;
        }
        this.clearFields();
        try {
            this.m_lID = this.m_ResultSet.getInt("ID");
            this.m_lNR = this.m_ResultSet.getInt("NR");
            int n = 0;
            while (true) {
                if (n >= this.TEXTFIELDS) {
                    this.m_lBuchID = this.m_ResultSet.getLong("BUCH_ID");
                    this.m_lPictureThumb = this.m_ResultSet.getLong("THUMB_L");
                    this.m_lPictureLow = this.m_ResultSet.getLong("THUMB_M");
                    this.m_lPictureHigh = this.m_ResultSet.getLong("THUMB_H");
                    this.m_lSizeM = this.m_ResultSet.getLong("SIZE2");
                    this.m_lSizeH = this.m_ResultSet.getLong("SIZE3");
                    break;
                }
                String string = this.m_ResultSet.getString(this.m_strFields[n]);
                if (string != null) {
                    this.m_textField[n].setText(string.trim());
                }
                ++n;
            }
        }
        catch (Exception exception) {
            Utils.displayException(exception);
        }
        super.DB2Fields();
        this.m_strBookName = this.getBookName();
        this.showStatus();
        this.btnZoom.setEnabled(this.m_lSizeH > 0L);
        this.m_bFieldsReady = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateSet() {
        if (MainPanel.m_bReadMode) {
            return;
        }
        String string = this.buildUpdateString();
        string = string + " WHERE ID = " + this.m_lID + " AND BUCH_ID = " + this.m_lBuchID;
        try {
            this.m_statement.execute(string);
            MainPanel.m_connection.commit();
        }
        catch (Exception exception) {
            Utils.displayException(exception);
        }
        this.setDirty(false);
    }

    public void insertSet() {
        if (MainPanel.m_bReadMode) {
            return;
        }
        String string = "BUCH_ID, ";
        String string2 = "" + this.m_lBuchID;
        int n = 0;
        while (n < this.TEXTFIELDS) {
            String string3 = this.m_textField[n].getText();
            if (this.m_chFieldTypes[n] == 's') {
                string3 = "'" + string3 + "'";
            }
            string = string + this.m_strFields[n];
            string2 = string2 + string3;
            if (n != this.TEXTFIELDS - 1) {
                string = string + ", ";
                string2 = string2 + ", ";
            }
            ++n;
        }
        this.insertSet(string, string2);
    }

    public void panelActivated() {
        super.panelActivated();
        if (this.m_lID == -1L) {
            this.moveSet(0);
        }
        MainPanel.m_cmbSet.setVisible(false);
        MainPanel.m_cbxSearch.setVisible(true);
        MainPanel.m_btnRenameSet.setVisible(false);
    }

    public void deleteRecord() {
        boolean bl = true;
        String string = "DELETE FROM " + MainPanel.m_strTableOwner + this.m_strTable + " WHERE ID = " + this.m_lID;
        bl = Utils.executeString(string, false);
        if (bl) {
            Utils.messageBox("delete succeeded!");
            if (this.m_lCurrent == 1L) {
                this.moveSet(2);
            } else {
                this.moveSet(1);
            }
            this.refreshCount(this.m_strTable, true);
        }
    }

    public PhotographiePanel(MainPanel mainPanel) {
        this.m_mainPanel = mainPanel;
        this.TEXTFIELDS = 17;
        this.m_strTable = "PHOTO";
        this.m_strFields = this.strFields;
        this.m_chFieldTypes = chFieldTypes;
        this.m_strLabels = this.strLabels;
        this.m_thisPanel = this.buildAllPanels();
        this.add(this.m_thisPanel);
    }
}

