/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.TitledBorder;

public class TypographiePanel
extends CMyPanel {
    public static int m_nCurrSet;
    public static long m_nSchrType;
    public static long m_nSetID;
    JScrollPane m_scrollPane;
    JLabel m_imageLabel;
    protected FileDialog fileDialog;
    private JComboBox m_box = null;
    private int m_nBoxIndex;
    private long m_lPictureThumb;
    private long m_lPictureLow;
    private long m_lPictureHigh;
    private long m_lVektor;
    private long m_lVekCount;
    private long m_lSizeM;
    private long m_lSizeH;
    private long m_nSetType;
    public CComboListener m_cmbActionListener;
    private TitledBorder stdBorder;
    JPanel m_thisPanel;
    JPanel leftPanel;
    JPanel rightPanel;
    JButton btnZoom;
    JButton btnReplace;
    JButton btnThis;
    JButton btnAll;
    private String stdTxt;
    private String[][] strLabels;
    private final String[] strFields;
    private final char[] chFieldTypes;

    public JPanel buildAllPanels() {
        GridLayout gridLayout = new GridLayout(1, 0);
        this.leftPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.m_thisPanel = new JPanel();
        this.m_thisPanel.setLayout(gridLayout);
        this.rightPanel = this.buildPicturePanel();
        this.leftPanel = this.buildEditPanel();
        this.m_thisPanel.add(this.leftPanel);
        this.m_thisPanel.add(this.rightPanel);
        return this.m_thisPanel;
    }

    public JPanel buildEditPanel() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        int n = this.getEditLength();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(null);
        jPanel2.setBorder(new TitledBorder("Typographie"));
        this.m_box = new JComboBox();
        TypographiePanel typographiePanel = this;
        if (typographiePanel == null) {
            throw null;
        }
        this.m_box.setRenderer(typographiePanel.new MyCellRenderer());
        this.m_box.setOpaque(true);
        int n2 = 0;
        while (n2 < 6) {
            this.m_box.addItem(MainPanel.m_strLabelsTypo[MainPanel.m_nLanguage][n2]);
            ++n2;
        }
        this.m_box.reshape(160, 22, n, 22);
        this.m_box.setFont(CTextArea.SystemFont);
        jPanel2.add(this.m_box);
        n2 = 0;
        while (n2 < this.TEXTFIELDS) {
            this.m_textField[n2] = new CTextArea();
            this.m_label[n2] = new myLabel(this.m_strLabels[MainPanel.m_nLanguage][n2], 4);
            this.m_label[n2].reshape(0, 21 + 21 * n2, 150, 16);
            this.m_label[n2].setText(this.m_strLabels[MainPanel.m_nLanguage][n2]);
            this.m_label[n2].setFont(CTextArea.SystemFont);
            this.m_label[n2].setOwner(this);
            this.m_textField[n2].setLabel(this.m_label[n2].getText());
            this.m_editPane[n2] = new JScrollPane(this.m_textField[n2], 20, 31);
            if (n2 != this.TEXTFIELDS - 1) {
                this.m_editPane[n2].reshape(160, 21 + 21 * n2, n, 24);
            } else {
                this.m_editPane[n2].setBounds(160, 21 + n2 * 21, n, 80);
            }
            jPanel2.add(this.m_label[n2]);
            if (this.m_chFieldTypes[n2] == 'n') {
                this.m_label[n2].setNumeric(true);
                this.m_textField[n2].setNumeric(true);
            }
            if (n2 != 0) {
                jPanel2.add(this.m_editPane[n2]);
            }
            this.m_label[n2].setDBField(this.m_strFields[n2]);
            this.m_label[n2].setName(this.m_label[n2].getText());
            this.m_label[n2].setTextArea(this.m_textField[n2]);
            ++n2;
        }
        this.m_textField[this.TEXTFIELDS - 1].setMaxChar(4000);
        this.m_box.setEnabled(false);
        this.m_textField[1].setEnabled(false);
        JPanel jPanel3 = this.buildVektorPanel();
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    public JPanel buildPicturePanel() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.stdBorder = new TitledBorder(this.stdTxt);
        jPanel.setBorder(this.stdBorder);
        jPanel.setLayout(new BorderLayout());
        this.m_scrollPane = new JScrollPane();
        JPanel jPanel3 = this.buildControlPanel();
        jPanel.add((Component)this.m_scrollPane, "Center");
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    public JPanel buildControlPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(MainPanel.lightLoweredBorder);
        jPanel.setAlignmentY(0.0f);
        jPanel.setLayout(new FlowLayout(1));
        this.btnZoom = new JButton("Zoom");
        TypographiePanel typographiePanel = this;
        if (typographiePanel == null) {
            throw null;
        }
        this.btnZoom.addActionListener(new ActionListener(typographiePanel){
            private final /* synthetic */ TypographiePanel this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.zoomPressed();
            }
            {
                this.this$0 = typographiePanel;
                this.constructor$0(typographiePanel);
            }

            public void constructor$0(TypographiePanel typographiePanel) {
            }
        });
        jPanel.add(this.btnZoom);
        this.btnReplace = new JButton("Replace");
        TypographiePanel typographiePanel2 = this;
        if (typographiePanel2 == null) {
            throw null;
        }
        this.btnReplace.addActionListener(new ActionListener(typographiePanel2){
            private final /* synthetic */ TypographiePanel this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.replacePressed();
            }
            {
                this.this$0 = typographiePanel;
                this.constructor$0(typographiePanel);
            }

            public void constructor$0(TypographiePanel typographiePanel) {
            }
        });
        if (!MainPanel.m_bReadMode) {
            jPanel.add(this.btnReplace);
        }
        return jPanel;
    }

    public JPanel buildVektorPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder("download vector"));
        jPanel.setAlignmentY(0.0f);
        jPanel.setLayout(new FlowLayout(1));
        this.btnThis = new JButton("this");
        TypographiePanel typographiePanel = this;
        if (typographiePanel == null) {
            throw null;
        }
        this.btnThis.addActionListener(new ActionListener(typographiePanel){
            private final /* synthetic */ TypographiePanel this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.thisPressed();
            }
            {
                this.this$0 = typographiePanel;
                this.constructor$0(typographiePanel);
            }

            public void constructor$0(TypographiePanel typographiePanel) {
            }
        });
        jPanel.add(this.btnThis);
        this.btnAll = new JButton("All");
        TypographiePanel typographiePanel2 = this;
        if (typographiePanel2 == null) {
            throw null;
        }
        this.btnAll.addActionListener(new ActionListener(typographiePanel2){
            private final /* synthetic */ TypographiePanel this$0;

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.allPressed();
            }
            {
                this.this$0 = typographiePanel;
                this.constructor$0(typographiePanel);
            }

            public void constructor$0(TypographiePanel typographiePanel) {
            }
        });
        jPanel.add(this.btnAll);
        return jPanel;
    }

    public void changeLanguage() {
        int n = this.m_box.getSelectedIndex();
        this.m_box.removeAllItems();
        int n2 = 0;
        while (n2 < 6) {
            this.m_box.addItem(MainPanel.m_strLabelsTypo[MainPanel.m_nLanguage][n2]);
            ++n2;
        }
        this.m_box.setSelectedIndex(n);
        this.m_box.setFont(CTextArea.HebrewFont);
        super.changeLanguage();
    }

    public void loadImages() {
        ImageLoaderThread imageLoaderThread = new ImageLoaderThread(this.m_lPictureLow, 2, 0, this.m_lBuchID, 0);
        imageLoaderThread.setSize(this.m_lSizeM);
        imageLoaderThread.run();
        if (ImageLoader.m_imgLow != null) {
            this.m_imageLabel = new JLabel(ImageLoader.m_imgLow);
            this.m_scrollPane.setViewportView(this.m_imageLabel);
            this.revalidate();
        } else {
            this.m_scrollPane.setViewportView(null);
        }
    }

    public void zoomPressed() {
        this.btnZoom.setCursor(MainPanel.cursorWait);
        ImageLoader.m_imgHigh = null;
        ImageLoader imageLoader = new ImageLoader(this.m_lPictureHigh, 3, 0, 3, this.m_lBuchID);
        imageLoader.setSize(this.m_lSizeH);
        imageLoader.start();
        imageLoader.end();
        this.setCursor(MainPanel.cursorDefault);
        PictureDialog pictureDialog = new PictureDialog(ImageLoader.m_imgHigh);
        this.btnZoom.setCursor(MainPanel.cursorDefault);
        pictureDialog.show();
    }

    public void replacePressed() {
        ImageLoader.clearImages();
        ReplaceDialog replaceDialog = new ReplaceDialog(this.m_mainPanel);
        replaceDialog.setThumbInfo(this.m_lPictureThumb, this.m_lPictureLow, this.m_lPictureHigh, this.m_lID, 0);
        replaceDialog.show();
    }

    private Frame getFrame() {
        Container container = this.getParent();
        while (container != null) {
            if (container instanceof Frame) {
                return (Frame)container;
            }
            container = container.getParent();
        }
        return null;
    }

    public void thisPressed() {
        String string = this.m_textField[2].getText();
        int n = string.indexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        Frame frame = this.getFrame();
        if (this.fileDialog == null) {
            this.fileDialog = new FileDialog(frame);
        }
        this.fileDialog.setMode(1);
        this.fileDialog.setFile(string);
        this.fileDialog.show();
        String string2 = this.fileDialog.getFile();
        if (string2 == null) {
            return;
        }
        if (string2.indexOf(46) == -1) {
            string2 = string2 + ".ai";
        }
        String string3 = this.fileDialog.getDirectory();
        this.setCursor(MainPanel.cursorWait);
        if (Utils.fileExists(string3 + string2)) {
            Utils.messageBox("file exists");
            return;
        }
        ImageLoader imageLoader = new ImageLoader(this.m_lVektor, this.m_lBuchID, string3 + string2);
        imageLoader.start();
        if (imageLoader.succeeded()) {
            Utils.messageBox("download complete");
        }
        imageLoader.end();
        this.setCursor(MainPanel.cursorDefault);
    }

    public void allPressed() {
    }

    public String getExtraFilter() {
        if (MainPanel.m_cbxSearch.isSelected()) {
            return "";
        }
        return "BUCH_ID = " + MainPanel.getCurrentID();
    }

    public String getExtraOrder() {
        String string = "SCHRIFTSATZ, CHARID";
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void DB2Fields() {
        this.m_bFieldsReady = false;
        if (this.m_ResultSet == null) {
            return;
        }
        this.clearFields();
        try {
            this.m_lID = this.m_ResultSet.getInt("ID");
            this.m_lNR = this.m_ResultSet.getInt("NR");
            int n = 0;
            while (true) {
                if (n >= this.TEXTFIELDS) {
                    this.m_lBuchID = this.m_ResultSet.getLong("BUCH_ID");
                    this.m_lPictureThumb = this.m_ResultSet.getLong("THUMB_L");
                    this.m_lPictureLow = this.m_ResultSet.getLong("THUMB_M");
                    this.m_lPictureHigh = this.m_ResultSet.getLong("THUMB_H");
                    this.m_lVektor = this.m_ResultSet.getLong("VEKTOR");
                    this.m_lSizeM = this.m_ResultSet.getLong("SIZE2");
                    this.m_lSizeH = this.m_ResultSet.getLong("SIZE3");
                    this.m_nSetType = this.m_ResultSet.getLong("SETTYP");
                    m_nSchrType = this.m_ResultSet.getLong("SCHRIFTTYPE");
                    m_nSetID = this.m_ResultSet.getLong("SETID");
                    break;
                }
                String string = this.m_ResultSet.getString(this.m_strFields[n]);
                if (string != null) {
                    this.m_textField[n].setText(string.trim());
                }
                ++n;
            }
        }
        catch (Exception exception) {
            Utils.displayException(exception);
        }
        this.btnThis.setEnabled(this.m_lVektor > 0L);
        this.m_textField[1].setVisible(m_nSchrType < 5L);
        this.m_label[1].setEnabled(m_nSchrType < 5L);
        this.m_box.setSelectedIndex((int)m_nSchrType);
        this.m_box.repaint();
        int n = -1;
        int n2 = 0;
        while (n2 < BibliographiePanel.m_nSetCount) {
            if (m_nSetID == BibliographiePanel.m_lSetIDs[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n >= 0) {
            this.m_textField[1].setText(BibliographiePanel.m_strSetAlias[n]);
        } else {
            this.m_textField[1].setText(BibliographiePanel.getSelectedSet());
        }
        super.DB2Fields();
        this.m_strBookName = this.getBookName();
        this.showStatus();
        this.btnZoom.setEnabled(this.m_lSizeH > 0L);
        this.m_bFieldsReady = true;
    }

    public void clearFields() {
        ImageLoader.clearImages();
        this.m_lPictureHigh = -1L;
        this.m_lPictureLow = -1L;
        this.m_scrollPane.setViewportView(null);
        this.revalidate();
        super.clearFields();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateSet() {
        if (MainPanel.m_bReadMode) {
            return;
        }
        String string = "" + this.m_box.getSelectedIndex();
        this.m_textField[0].setText(string);
        String string2 = this.buildUpdateString();
        string2 = string2 + " WHERE ID = " + this.m_lID + " AND BUCH_ID = " + this.m_lBuchID;
        try {
            this.m_statement.execute(string2);
            MainPanel.m_connection.commit();
        }
        catch (Exception exception) {
            Utils.displayException(exception);
        }
        this.setDirty(false);
    }

    public void insertSet() {
        if (MainPanel.m_bReadMode) {
            return;
        }
        String string = "BUCH_ID, SCHRIFTTYPE, SCHRIFTSATZ, SETID, SETTYP, ";
        String string2 = "";
        string2 = "" + this.m_lBuchID + "," + m_nSchrType + ", " + m_nSetID + "," + m_nSetID + ", " + this.m_nSetType + ", ";
        String string3 = this.m_textField[2].getText();
        int n = -1;
        if (string3.length() > 0) {
            n = SetupDialog.getOrder(string3);
        }
        if (n >= 0) {
            string = string + "CHARID, ";
            string2 = string2 + n + ", ";
        }
        int n2 = 2;
        while (n2 < this.TEXTFIELDS) {
            String string4 = this.m_textField[n2].getText();
            if (this.m_chFieldTypes[n2] == 's') {
                string4 = "'" + string4 + "'";
            } else if (string4.length() < 1) {
                string4 = "NULL";
            }
            string = string + this.m_strFields[n2];
            string2 = string2 + string4;
            if (n2 != this.TEXTFIELDS - 1) {
                string = string + ", ";
                string2 = string2 + ", ";
            }
            ++n2;
        }
        this.insertSet(string, string2);
    }

    public void setFieldValue(int n, String string) {
        this.m_textField[n].setText(string);
        switch (n) {
            case 0: {
                this.m_box.setSelectedIndex((int)Utils.atol(this.getFieldValue(n)));
                this.m_box.repaint();
                break;
            }
        }
    }

    public void doAfterResized(int n) {
        this.m_box.repaint();
        Dimension dimension = this.m_box.getSize();
        dimension.width = n;
        this.m_box.setSize(dimension);
        this.m_box.repaint();
        this.invalidate();
    }

    public void doBeforeSelect() {
    }

    public void doAfterSelect() {
        this.loadImages();
        String string = this.m_TheFilter != null && this.m_TheFilter.length() > 0 ? this.m_TheFilter + " AND" : "WHERE ";
        string = string + " VEKTOR > 0";
        this.m_lVekCount = Utils.getCount("TYPO", string);
        this.btnAll.setEnabled(this.m_lVekCount > 1L);
        this.m_label[0].setTypeMenu();
    }

    public void panelActivated() {
        super.panelActivated();
        MainPanel.m_cmbSet.addActionListener(this.m_cmbActionListener);
        if (this.m_lID == -1L) {
            this.moveSet(0);
        }
        MainPanel.m_cmbSet.setVisible(false);
        MainPanel.m_cbxSearch.setVisible(true);
        MainPanel.m_cmbSet.setSelectedIndex(CMyPanel.m_nSet);
        MainPanel.m_btnRenameSet.setVisible(false);
        this.m_label[1].setSetMenu();
    }

    public void panelDeactivated() {
        MainPanel.m_cmbSet.removeActionListener(this.m_cmbActionListener);
    }

    public void setChanged() {
        this.m_label[1].setFilter(this.m_label[1].getDBFieldName() + "= " + (MainPanel.m_cmbSet.getSelectedIndex() + 1));
        CMyPanel.m_nSet = MainPanel.m_cmbSet.getSelectedIndex();
        this.doRefresh();
    }

    public void deleteRecord() {
        boolean bl = true;
        String string = "DELETE FROM " + MainPanel.m_strTableOwner + this.m_strTable + " WHERE ID = " + this.m_lID;
        bl = Utils.executeString(string, false);
        if (bl) {
            Utils.messageBox("delete succeeded!");
            if (this.m_lCurrent == 1L) {
                this.moveSet(2);
            } else {
                this.moveSet(1);
            }
            this.refreshCount(this.m_strTable, true);
        }
    }

    public TypographiePanel(MainPanel mainPanel) {
        TypographiePanel typographiePanel = this;
        if (typographiePanel == null) {
            throw null;
        }
        this.m_cmbActionListener = typographiePanel.new CComboListener();
        this.stdTxt = "Photographie";
        this.strLabels = new String[][]{{"Schrifttyp", "Schriftsatz", "Name", "Weitere Namensangaben", "Aufnahmedatum", "Photograph", "Objektrecht", "Bildrecht", "Bearbeitungsdatum", "Bildformat/Aufl\u00f6sung(breite, dpi)", "Bildformat/Aufl\u00f6sung(h\u00f6he, dpi)", "Letterbreite (mm)", "Letterh\u00f6he (mm)", "Obere Hor.-Dickte (mm)", "Untere Hor.-Dickte (mm)", "Rohdaten", "Besonderheiten", "Weitere Hinweise", "Anmerkungen"}, {"Schrifttyp", "Schriftsatz", "Name", "Weitere Namensangaben", "Aufnahmedatum", "Photograph", "Objektrecht", "Bildrecht", "Bearbeitungsdatum", "Bildformat/Aufl\u00f6sung(breite)", "Bildformat/Aufl\u00f6sung(h\u00f6he)", "Letterbreite", "Letterh\u00f6he", "Obere Horizontal-Dickte", "Untere Horizontal-Dickte", "Rohdaten", "Besonderheiten", "Weitere Hinweise", "Anmerkungen"}, {"\u00ef\u00ee\u00e9\u00f1 \u00e2\u00e5\u00f1", "\u00fa\u00e5\u00e0 \u00e2\u00e5\u00f1", "\u00ed\u00f9", "\u00ed\u00e9\u00f4\u00f1\u00e5\u00f0 \u00fa\u00e5\u00ee\u00f9", "\u00ed\u00e5\u00ec\u00e9\u00dd\u00de \u00ea\u00e9\u00f8\u00e0\u00fa", "\u00ed\u00ec\u00dd", "Objektrecht", "Bildrecht", "\u00e3\u00e5\u00e1\u00e9\u00f2\u00de \u00ea\u00e9\u00f8\u00e0\u00fa", "Bildformat/Aufl\u00ddsung(breite)", "Bildformat/Aufl\u00ddsung(h\u00f6he)", "\u00fa\u00e5\u00e0 \u00e1\u00e7\u00e5\u00f8", "\u00fa\u00e5\u00e0 \u00de\u00e1\u00e5\u00e2", "\u00ef\u00e5\u00e9\u00ec\u00f2 \u00e9\u00f7\u00f4\u00e5\u00e0 \u00e5\u00f7 \u00e9\u00e1\u00e5\u00f2", "\u00ef\u00e5\u00fa\u00e7\u00fa \u00e9\u00f7\u00f4\u00e5\u00e0 \u00e5\u00f7 \u00e9\u00e1\u00e5\u00f2", "\u00e9\u00f0\u00e5\u00f9\u00e0\u00f8 \u00f5\u00e1\u00e5\u00f7", "\u00ed\u00e9\u00e3\u00e7\u00e5\u00e9\u00ee \u00ed\u00e9\u00f0\u00ee\u00e9\u00f1", "\u00fa\u00e5\u00f4\u00f1\u00e5\u00f0 \u00fa\u00e5\u00f8\u00f2\u00de", "\u00fa\u00e5\u00f8\u00f2\u00de"}};
        this.strFields = new String[]{"SCHRIFTTYPE", "SCHRIFTSATZ", "NAME", "NAME2", "AUFN_DAT", "PHOTOGRAPH", "OBJRECHT", "BILDRECHT", "BEARB_DAT", "BILDFRMT_B", "BILDFRMT_H", "LETTERBREITE", "LETTERHOEHE", "OBERE_DICKTE", "UNTERE_DICKTE", "ROHDATEN", "BESONDERHEITEN", "WEITERE_HINW", "ANMERKUNGEN"};
        this.chFieldTypes = new char[]{'n', 'n', 's', 's', 's', 's', 's', 's', 's', 'n', 'n', 'n', 'n', 'n', 'n', 's', 's', 's', 's'};
        this.m_mainPanel = mainPanel;
        this.TEXTFIELDS = 19;
        this.m_strTable = "TYPO";
        this.m_strFields = this.strFields;
        this.m_chFieldTypes = this.chFieldTypes;
        this.m_strLabels = this.strLabels;
        this.init();
        this.m_thisPanel = this.buildAllPanels();
        this.add(this.m_thisPanel);
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(object.toString());
            this.setBackground(bl ? Color.blue : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }

        public MyCellRenderer() {
            this.setOpaque(true);
        }
    }

    public class CComboListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getActionCommand() == "comboBoxChanged") {
                TypographiePanel.this.setChanged();
            }
        }
    }
}

